/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.model.registry;

import fr.minepiece.client.model.modifications.AbstractPlayerModification;
import fr.minepiece.client.model.modifications.PlayerModifications;
import fr.minepiece.client.render.playerapi.poses.IPose;
import fr.minepiece.client.render.playerapi.poses.Poses;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBase;

public class ModelRegistry {
    private static final Map<String, AbstractPlayerModification> MODIFICATIONS = new HashMap<String, AbstractPlayerModification>();
    private static final Map<String, IPose> POSES = new HashMap<String, IPose>();
    private static final Map<Class<? extends ModelBase>, ModelPool<? extends ModelBase>> MODEL_POOLS = new HashMap<Class<? extends ModelBase>, ModelPool<? extends ModelBase>>();

    public static void initialize() {
        for (PlayerModifications playerModifications : PlayerModifications.values()) {
            ModelRegistry.registerModification(playerModifications.getName(), playerModifications.getModification());
        }
        for (Enum enum_ : Poses.values()) {
            ModelRegistry.registerPose(((Poses)enum_).getName(), ((Poses)enum_).getPose());
        }
    }

    public static void registerModification(String id, AbstractPlayerModification modification) {
        MODIFICATIONS.put(id, modification);
    }

    @Nullable
    public static AbstractPlayerModification getModification(String id) {
        return MODIFICATIONS.get(id);
    }

    public static void registerPose(String id, IPose pose) {
        POSES.put(id, pose);
    }

    @Nullable
    public static IPose getPose(String id) {
        return POSES.get(id);
    }

    public static <T extends ModelBase> ModelPool<T> getModelPool(Class<T> modelClass, Supplier<T> factory) {
        return MODEL_POOLS.computeIfAbsent(modelClass, k -> new ModelPool(factory));
    }

    public static class ModelPool<T extends ModelBase> {
        private final Supplier<T> factory;
        private final Map<Thread, T> threadLocalModels = new HashMap<Thread, T>();

        public ModelPool(Supplier<T> factory) {
            this.factory = factory;
        }

        public T getModel() {
            Thread currentThread = Thread.currentThread();
            return (T)this.threadLocalModels.computeIfAbsent(currentThread, k -> (ModelBase)this.factory.get());
        }
    }
}

