/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.model.modifications;

import fr.minepiece.client.model.modifications.models.AbstractPlayerModificationModel;
import fr.minepiece.common.capability.CapabilityHelper;
import java.util.HashMap;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public abstract class AbstractPlayerModification {
    protected float customOffsetX;
    protected float customOffsetY;
    protected float customOffsetZ;
    protected float rotateX;
    protected float rotateY;
    protected float rotateZ;
    protected float rotatePointX;
    protected float rotatePointY;
    protected float rotatePointZ;
    protected final HashMap<State, ModelBase> models = new HashMap();

    protected AbstractPlayerModification(HashMap<State, ModelBase> models) {
        this.models.putAll(models);
    }

    protected AbstractPlayerModification(ModelBase model) {
        this.models.put(State.Default, model);
    }

    public void render(RenderPlayer playerRenderer, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        playerRenderer.func_110776_a(this.getTexture());
        AbstractPlayerModification.applyColor((EntityPlayer)player);
        State state = this.getState(player);
        ModelBase model = this.models.get((Object)state);
        if (model != null) {
            this.setRotationAngle(model, playerRenderer, player, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale);
            if (model instanceof AbstractPlayerModificationModel) {
                ((AbstractPlayerModificationModel)model).setModelOffset(player, this.customOffsetX, this.customOffsetY, this.customOffsetZ, this.rotateX, this.rotateY, this.rotateZ, this.rotatePointX, this.rotatePointY, this.rotatePointZ);
            }
            this.render(model, player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    protected void render(ModelBase model, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        model.func_78088_a((Entity)player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
    }

    protected void setRotationAngle(ModelBase model, RenderPlayer playerRenderer, AbstractClientPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, (Entity)player);
    }

    protected State getState(AbstractClientPlayer player) {
        return State.Default;
    }

    public void setModelVisibilities(ModelPlayer modelPlayer) {
    }

    public void setModelOffset(AbstractClientPlayer player, ModelPlayer modelPlayer) {
    }

    public void setModelVisibilities(ModelBiped modelBiped) {
    }

    public abstract ResourceLocation getTexture();

    public static void applyColor(EntityPlayer player) {
        int color = CapabilityHelper.getPlayerModifications(player).getModificationColor();
        if (color == 0) {
            return;
        }
        float[] colors = AbstractPlayerModification.intToRgb(color);
        GlStateManager.func_179124_c((float)colors[0], (float)colors[1], (float)colors[2]);
    }

    protected float[] hexToRgb(String hexColor) {
        int hex = Integer.decode(hexColor);
        int red = (hex & 0xFF0000) >> 16;
        int green = (hex & 0xFF00) >> 8;
        int blue = hex & 0xFF;
        return new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }

    protected static float[] intToRgb(int color) {
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color & 0xFF;
        return new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f};
    }

    public static enum State {
        Default,
        Swimming;

    }
}

