/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.model.layers;

import fr.minepiece.client.model.CustomArmorModelBiped;
import fr.minepiece.client.model.modifications.AbstractPlayerModification;
import fr.minepiece.client.model.modifications.PlayerModifications;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import java.lang.reflect.Field;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.layers.LayerArmorBase;
import net.minecraft.client.renderer.entity.layers.LayerBipedArmor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class LayerCustomBipedArmor
extends LayerBipedArmor {
    private final RenderLivingBase<?> renderer;

    public LayerCustomBipedArmor(RenderLivingBase<?> rendererIn) {
        super(rendererIn);
        this.renderer = rendererIn;
    }

    protected void func_177177_a() {
        this.field_177189_c = new CustomArmorModelBiped(0.5f);
        this.field_177186_d = new CustomArmorModelBiped(1.0f);
    }

    public void func_177141_a(EntityLivingBase entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.CHEST);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.LEGS);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.FEET);
        this.renderArmorLayer(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch, scale, EntityEquipmentSlot.HEAD);
    }

    private void renderArmorLayer(EntityLivingBase entityLivingBaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale, EntityEquipmentSlot slotIn) {
        ItemArmor itemarmor;
        ItemStack itemstack;
        IPlayerModifications modifications = (IPlayerModifications)entityLivingBaseIn.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (modifications != null);
        this.resetModelVisibilities((ModelBiped)this.field_177189_c);
        this.resetModelVisibilities((ModelBiped)this.field_177186_d);
        if (!modifications.getModifications().isEmpty()) {
            for (String modification : modifications.getModifications()) {
                AbstractPlayerModification playerModification = PlayerModifications.getModificationByName(modification);
                playerModification.setModelVisibilities((ModelBiped)this.field_177189_c);
                playerModification.setModelVisibilities((ModelBiped)this.field_177186_d);
            }
        }
        if ((itemstack = entityLivingBaseIn.func_184582_a(slotIn)).func_77973_b() instanceof ItemArmor && (itemarmor = (ItemArmor)itemstack.func_77973_b()).func_185083_B_() == slotIn) {
            CustomArmorModelBiped modelBiped = this.getModelFromSlot(slotIn);
            modelBiped = this.getArmorModelHook(entityLivingBaseIn, itemstack, slotIn, modelBiped);
            modelBiped.func_178686_a(this.renderer.func_177087_b());
            modelBiped.func_78086_a(entityLivingBaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.func_188359_a(modelBiped, slotIn);
            this.renderer.func_110776_a(this.getArmorResource((Entity)entityLivingBaseIn, itemstack, slotIn, null));
            float[] colors = this.getLayerArmorBaseColors((LayerArmorBase<?>)this);
            float colorR = colors[0];
            float colorG = colors[1];
            float colorB = colors[2];
            float alpha = colors[3];
            if (itemarmor.hasOverlay(itemstack)) {
                int i = itemarmor.func_82814_b(itemstack);
                float redConstant = (float)(i >> 16 & 0xFF) / 255.0f;
                float greenConstant = (float)(i >> 8 & 0xFF) / 255.0f;
                float blueConstant = (float)(i & 0xFF) / 255.0f;
                GlStateManager.func_179131_c((float)(colorR * redConstant), (float)(colorG * greenConstant), (float)(colorB * blueConstant), (float)alpha);
                modelBiped.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
                this.renderer.func_110776_a(this.getArmorResource((Entity)entityLivingBaseIn, itemstack, slotIn, "overlay"));
            }
            GlStateManager.func_179131_c((float)colorR, (float)colorG, (float)colorB, (float)alpha);
            modelBiped.func_78088_a((Entity)entityLivingBaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            if (!this.getLayerArmorBaseSkipRenderGlint((LayerArmorBase<?>)this) && itemstack.func_77962_s()) {
                LayerCustomBipedArmor.func_188364_a(this.renderer, (EntityLivingBase)entityLivingBaseIn, (ModelBase)modelBiped, (float)limbSwing, (float)limbSwingAmount, (float)partialTicks, (float)ageInTicks, (float)netHeadYaw, (float)headPitch, (float)scale);
            }
        }
    }

    private void resetModelVisibilities(ModelBiped modelPlayer) {
        modelPlayer.field_178722_k.field_78807_k = false;
        modelPlayer.field_178721_j.field_78807_k = false;
        modelPlayer.field_178724_i.field_78807_k = false;
        modelPlayer.field_178723_h.field_78807_k = false;
        modelPlayer.field_78115_e.field_78807_k = false;
        modelPlayer.field_78116_c.field_78807_k = false;
        modelPlayer.field_178720_f.field_78807_k = false;
    }

    public CustomArmorModelBiped getModelFromSlot(EntityEquipmentSlot slotIn) {
        return (CustomArmorModelBiped)(this.isLegSlot(slotIn) ? (ModelBiped)this.field_177189_c : (ModelBiped)this.field_177186_d);
    }

    protected CustomArmorModelBiped getArmorModelHook(EntityLivingBase entity, ItemStack itemStack, EntityEquipmentSlot slot, ModelBiped model) {
        return (CustomArmorModelBiped)ForgeHooksClient.getArmorModel((EntityLivingBase)entity, (ItemStack)itemStack, (EntityEquipmentSlot)slot, (ModelBiped)model);
    }

    private boolean isLegSlot(EntityEquipmentSlot slotIn) {
        return slotIn == EntityEquipmentSlot.LEGS;
    }

    private float[] getLayerArmorBaseColors(LayerArmorBase<?> layerArmorBase) {
        try {
            Field colorRField = ReflectionHelper.findField(LayerArmorBase.class, (String)"colorR", (String)"field_177184_f");
            Field colorGField = ReflectionHelper.findField(LayerArmorBase.class, (String)"colorG", (String)"field_177185_g");
            Field colorBField = ReflectionHelper.findField(LayerArmorBase.class, (String)"colorB", (String)"field_177192_h");
            Field alphaField = ReflectionHelper.findField(LayerArmorBase.class, (String)"alpha", (String)"field_177187_e");
            colorRField.setAccessible(true);
            colorGField.setAccessible(true);
            colorBField.setAccessible(true);
            alphaField.setAccessible(true);
            float colorR = colorRField.getFloat(layerArmorBase);
            float colorG = colorGField.getFloat(layerArmorBase);
            float colorB = colorBField.getFloat(layerArmorBase);
            float alpha = alphaField.getFloat(layerArmorBase);
            return new float[]{colorR, colorG, colorB, alpha};
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean getLayerArmorBaseSkipRenderGlint(LayerArmorBase<?> layerArmorBase) {
        try {
            Field skipRenderGlintField = ObfuscationReflectionHelper.findField(LayerArmorBase.class, (String)"field_177193_i");
            skipRenderGlintField.setAccessible(true);
            return skipRenderGlintField.getBoolean(layerArmorBase);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }
}

