/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.model.blocks;

import fr.minepiece.common.blocks.canons.CannonLength;
import fr.minepiece.common.blocks.canons.CannonMaterial;
import fr.minepiece.common.blocks.canons.TileEntityCannon;
import net.minecraft.util.ResourceLocation;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.AnimatedGeoModel;

public class CannonBlockModel
extends AnimatedGeoModel<TileEntityCannon> {
    private static final float DEG_TO_RAD = (float)Math.PI / 180;

    public ResourceLocation getModelLocation(TileEntityCannon tileEntityCannon) {
        CannonLength length = tileEntityCannon.getCannonLength();
        return new ResourceLocation("minepiece", "geo/blocks/cannon_" + length.func_176610_l() + ".geo.json");
    }

    public ResourceLocation getTextureLocation(TileEntityCannon tileEntityCannon) {
        CannonLength length = tileEntityCannon.getCannonLength();
        CannonMaterial material = tileEntityCannon.getCannonMaterial();
        return new ResourceLocation("minepiece", "textures/blocks/cannon_" + length.func_176610_l() + "_" + material.func_176610_l() + ".png");
    }

    public ResourceLocation getAnimationFileLocation(TileEntityCannon tileEntityCannon) {
        CannonLength length = tileEntityCannon.getCannonLength();
        return new ResourceLocation("minepiece", "animations/cannon_long.animation.json");
    }

    public void setLivingAnimations(TileEntityCannon entity, Integer uniqueID, AnimationEvent customPredicate) {
        super.setLivingAnimations((IAnimatable)entity, uniqueID, customPredicate);
        IBone corpsBone = this.getAnimationProcessor().getBone("corps");
        if (corpsBone != null) {
            float yaw = entity.getCannonYaw();
            float pitch = entity.getCannonPitch();
            corpsBone.setRotationY(yaw * ((float)(-Math.PI) / 180));
            corpsBone.setRotationX(pitch * ((float)Math.PI / 180));
        }
    }
}

