/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.model;

import fr.minepiece.common.init.ModTieredItems;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(modid="minepiece", value={Side.CLIENT})
public class ClientModTieredItems {
    public static void init() {
        ClientModTieredItems.registerItemModelProperties();
    }

    public static void registerItemModelProperties() {
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_KATANA);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_SWORD);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_LONGSWORD);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_BATTLEAXE);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_MACE);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_LANCE);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_TRIDENT);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_DAGGER);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_FLINTLOCK_PISTOL);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_FLINTLOCK_RIFLE);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_BAZOOKA);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_HELMET);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_MARINE_HELMET);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_CHESTPLATE);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_MARINE_CHESTPLATE);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_LEGGINGS);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_MARINE_LEGGINGS);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_BOOTS);
        ClientModTieredItems.registerTierProperty(ModTieredItems.TIERED_MARINE_BOOTS);
    }

    private static void registerTierProperty(Item item) {
        item.func_185043_a(new ResourceLocation("tier"), (stack, worldIn, entityIn) -> stack.func_77942_o() ? (float)stack.func_77978_p().func_74762_e("Tier") : 0.0f);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        ClientModTieredItems.registerWeaponModels();
        ClientModTieredItems.registerArmorModels();
        ClientModTieredItems.registerFragmentModels();
    }

    private static void registerWeaponModels() {
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_KATANA);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_SWORD);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_LONGSWORD);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_BATTLEAXE);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_MACE);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_LANCE);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_TRIDENT);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_DAGGER);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_FLINTLOCK_PISTOL);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_FLINTLOCK_RIFLE);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_BAZOOKA);
    }

    private static void registerArmorModels() {
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_HELMET);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_MARINE_HELMET);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_CHESTPLATE);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_MARINE_CHESTPLATE);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_LEGGINGS);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_MARINE_LEGGINGS);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_BOOTS);
        ClientModTieredItems.registerBaseModel(ModTieredItems.TIERED_MARINE_BOOTS);
    }

    private static void registerFragmentModels() {
        int i;
        for (i = 0; i < 5; ++i) {
            ClientModTieredItems.registerVariantModel(ModTieredItems.WEAPON_FRAGMENT, i);
        }
        for (i = 0; i < 3; ++i) {
            ClientModTieredItems.registerVariantModel(ModTieredItems.ARMOR_FRAGMENT, i);
        }
    }

    private static void registerBaseModel(Item item) {
        String path = item.getRegistryName().toString();
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(path, "inventory"));
    }

    private static void registerVariantModel(Item item, int meta) {
        String path = item.getRegistryName().toString() + "_tier_" + (meta + 1);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(path, "inventory"));
    }
}

