/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.interactions;

import fr.minepiece.client.events.OverlayRenderer;
import fr.minepiece.client.gui.misc.OverheatGui;
import fr.minepiece.client.particles.vfx.implementations.ParticleCCBlur;
import fr.minepiece.client.particles.vfx.implementations.ParticleFire;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgBeamPacket;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgFlamethrowerAbility;
import fr.minepiece.common.api.abilities.races.cyborg.CyborgLaserAbility;
import fr.minepiece.common.api.abilities.races.giant.GiantIkokuAbility;
import fr.minepiece.common.api.abilities.races.human.HumanMetaliumAbility;
import fr.minepiece.common.api.abilities.races.minks.MinksExplosionAbility;
import fr.minepiece.common.api.abilities.races.tontatta.TontattaJumpAbility;
import fr.minepiece.common.network.packets.ParticleBlurPacket;
import fr.minepiece.common.network.packets.races.CyborgFlameThrowerPacket;
import fr.minepiece.common.network.packets.races.HumanMetaliumPacket;
import fr.minepiece.common.network.packets.races.MinksEWavePacket;
import fr.minepiece.common.network.packets.races.ParticleVortexPacket;
import fr.minepiece.common.network.packets.races.TontattaHealthBoostPacket;
import fr.minepiece.common.network.packets.races.TontattaJumpPacket;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ClientController {
    public static void handleEvent(Events event, IMessage message) {
        switch (event) {
            case CYBORG_LASER: {
                Minecraft.func_71410_x().func_152344_a(() -> CyborgLaserAbility.addNewBeamToRender((CyborgBeamPacket)message));
                break;
            }
            case CYBORG_FLAMETHROWER: {
                World world = ClientController.getClientWorld();
                if (world == null) break;
                CyborgFlamethrowerAbility.particlesToRender.add(CyborgFlamethrowerAbility.FlameUnit.getFlameParticles(world, ((CyborgFlameThrowerPacket)message).getCoordinates()));
                break;
            }
            case CYBORG_OVERHEAT: {
                break;
            }
            case MINKS_WAVE: {
                Minecraft.func_71410_x().func_152344_a(() -> MinksExplosionAbility.addWaveToRender((MinksEWavePacket)message));
                break;
            }
            case GIANT_IKOKU: {
                GiantIkokuAbility.addIkokuToRender(((ParticleVortexPacket)message).getCoordinates());
                break;
            }
            case TONTATTA_HEALTH_BOOST: {
                OverlayRenderer.setHasActivatedInstantHealthAbility(((TontattaHealthBoostPacket)message).getEntityId());
                ClientController.renderTontattaHealthParticles((TontattaHealthBoostPacket)message);
                break;
            }
            case TONTATTA_JUMP_BOOST: {
                TontattaJumpAbility.hasActivatedJumpAbility.add(((TontattaJumpPacket)message).getEntityId());
                break;
            }
            case SPAWN_PARTICLE: {
                break;
            }
            case HUMAN_METALIUM: {
                HumanMetaliumAbility.timeLeftPerPlayer.put(((HumanMetaliumPacket)message).getUuid(), 120);
                break;
            }
            case SPAWN_BLUR_PARTICLE: {
                ClientController.spawnParticleBlur((ParticleBlurPacket)message);
                break;
            }
            case OPEN_OVERHEAT_GUI: {
                ClientController.openOverheatGui();
            }
        }
    }

    private static void openOverheatGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new OverheatGui());
    }

    private static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    private static void renderTontattaHealthParticles(TontattaHealthBoostPacket message) {
        Random random = new Random();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double x = message.getX();
        double y = message.getY();
        double z = message.getZ();
        for (int i = 0; i < 3; ++i) {
            ParticleFire p = new ParticleFire(player.field_70170_p, random.nextFloat() > 0.5f ? x + random.nextDouble() : x - random.nextDouble(), y + random.nextDouble() + 0.1, random.nextFloat() > 0.5f ? z + random.nextDouble() : z - random.nextDouble());
            p.setGravity(0.0f);
            p.setLife(50);
            p.setAlphaFading(1.0f);
            p.setRapidExpand();
            p.setScale(3.0f);
            p.setMainColor(5231427, 9028228, 0.75f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
        }
    }

    private static void spawnParticleBlur(ParticleBlurPacket particleBlurPacket) {
        ParticleCCBlur particleCCBlur = new ParticleCCBlur(ClientController.getClientWorld(), particleBlurPacket.getX(), particleBlurPacket.getY(), particleBlurPacket.getZ());
        particleCCBlur.setAlphaFading(particleBlurPacket.isAlphaFading() ? 1.0f : 0.0f);
        particleCCBlur.setGravity(0.0f);
        particleCCBlur.setLife(particleBlurPacket.getLife());
        particleCCBlur.setScale(particleBlurPacket.getScale());
        particleCCBlur.setColor(particleBlurPacket.getColor());
        ClientController.spawnParticleBlur(particleCCBlur);
    }

    public static void spawnParticleBlur(ParticleCCBlur particleCCBlur) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleCCBlur);
    }

    public static enum Events {
        CYBORG_LASER,
        CYBORG_FLAMETHROWER,
        CYBORG_OVERHEAT,
        MINKS_WAVE,
        GIANT_IKOKU,
        TONTATTA_HEALTH_BOOST,
        TONTATTA_JUMP_BOOST,
        SPAWN_PARTICLE,
        HUMAN_METALIUM,
        SPAWN_BLUR_PARTICLE,
        OPEN_OVERHEAT_GUI;

    }
}

