/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.practical;

import fr.minepiece.client.gui.component.button.GuiAPI;
import fr.minepiece.client.gui.component.button.GuiTexturedButton;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.textarea.TextInfo;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.StatisticChangePacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class StatisticGui
extends GuiAPI {
    private static final ResourceLocation background = new ResourceLocation("minepiece", "textures/gui/new/base/base_interface_large.png");
    private static final ResourceLocation visualizer = new ResourceLocation("minepiece", "textures/gui/new/visualizers/interface_stats.png");
    private static final ResourceLocation smallPaper = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_5.png");
    private static final ResourceLocation mediumPaper = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_6.png");
    private static final ResourceLocation longPaper = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_2.png");
    private static final ResourceLocation strengthIconLocation = new ResourceLocation("minepiece", "textures/gui/new/composants/stats_force.png");
    private static final ResourceLocation speedIconLocation = new ResourceLocation("minepiece", "textures/gui/new/composants/stats_speed.png");
    private static final ResourceLocation healthIconLocation = new ResourceLocation("minepiece", "textures/gui/new/composants/stats_vie.png");
    private static final ResourceLocation energyIconLocation = new ResourceLocation("minepiece", "textures/gui/new/composants/stats_energie.png");
    private static final ResourceLocation plusSign = new ResourceLocation("minepiece", "textures/gui/new/composants/plus.png");
    private static final ResourceLocation plusHoverSign = new ResourceLocation("minepiece", "textures/gui/new/composants/plus_hover.png");
    private static final ResourceLocation lock = new ResourceLocation("minepiece", "textures/gui/new/composants/lock.png");
    private final String username;
    private boolean updated = false;
    private int strength;
    private int speed;
    private int health;
    private int energy;
    private int statPoints;

    public StatisticGui(String username) {
        super(null, "statistic");
        this.username = username;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        EntityPlayer player = PlayerUtils.getPlayerByUsername(this.username);
        assert (player != null);
        IMinePieceStats stats = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        this.strength = stats.getStrength();
        this.speed = stats.getSpeed();
        this.energy = stats.getMaxEnergy();
        this.health = stats.getHP();
        this.statPoints = stats.getStatPoints();
        GuiTexturedButton header = new GuiTexturedButton((double)this.width(37.5f), (double)this.height(18.4f), (double)this.width(14.0f), (double)this.height(8.0f), new TextInfo("Points de Statistiques", 0x422433, 2.4, false));
        header.setTexture(longPaper);
        this.addComponent(header);
        GuiTexturedButton availablePoints = new GuiTexturedButton((double)this.width(53.0f), (double)this.height(18.4f), (double)this.width(6.0f), (double)this.height(8.0f), new TextInfo("" + this.statPoints, 0x422434, 6.0, false));
        availablePoints.setTexture(smallPaper);
        availablePoints.setUpdate(guiTexturedButton -> {
            TextInfo newTextInfo = guiTexturedButton.getTextInfo();
            newTextInfo.setString(this.statPoints + "");
            guiTexturedButton.setTextInfo(newTextInfo);
        });
        this.addComponent(availablePoints);
        GuiTexturedButton strengthHolder = new GuiTexturedButton(this.width(21.5f), this.height(32.25f), this.width(13.75f), this.height(12.25f));
        strengthHolder.setTexture(mediumPaper);
        this.addComponent(strengthHolder);
        GuiTexturedButton strengthIcon = new GuiTexturedButton(this.width(25.0f), this.height(33.25f), this.width(6.5f), this.height(10.25f));
        strengthIcon.setTexture(strengthIconLocation);
        this.addComponent(strengthIcon);
        GuiTexturedButton speedHolder = new GuiTexturedButton(this.width(36.0f), this.height(32.25f), this.width(13.75f), this.height(12.25f));
        speedHolder.setTexture(mediumPaper);
        this.addComponent(speedHolder);
        GuiTexturedButton speedIcon = new GuiTexturedButton(this.width(39.5f), this.height(33.25f), this.width(6.5f), this.height(10.25f));
        speedIcon.setTexture(speedIconLocation);
        this.addComponent(speedIcon);
        GuiTexturedButton healthHolder = new GuiTexturedButton(this.width(50.5f), this.height(32.25f), this.width(13.75f), this.height(12.25f));
        healthHolder.setTexture(mediumPaper);
        this.addComponent(healthHolder);
        GuiTexturedButton healthIcon = new GuiTexturedButton(this.width(54.0f), this.height(33.25f), this.width(6.5f), this.height(10.25f));
        healthIcon.setTexture(healthIconLocation);
        this.addComponent(healthIcon);
        GuiTexturedButton energyHolder = new GuiTexturedButton(this.width(65.0f), this.height(32.25f), this.width(13.75f), this.height(12.25f));
        energyHolder.setTexture(mediumPaper);
        this.addComponent(energyHolder);
        GuiTexturedButton energyIcon = new GuiTexturedButton(this.width(68.5f), this.height(33.25f), this.width(6.5f), this.height(10.25f));
        energyIcon.setTexture(energyIconLocation);
        this.addComponent(energyIcon);
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        assert (data != null);
        boolean isLevel20 = data.getLevel() >= 20;
        System.out.println("levl: " + data.getLevel() + ", bool: " + (data.getLevel() >= 20));
        boolean canSpendOnEnergy = stats.getMaxEnergy() < 10;
        boolean allowEnergy = isLevel20 && canSpendOnEnergy;
        System.out.println("Allow energy? " + allowEnergy + " because is level 20: " + isLevel20 + " or is level 20 and can spend: " + canSpendOnEnergy);
        if (!allowEnergy) {
            this.addEnergyLock(isLevel20);
        }
        GuiTexturedButton strengthPlusSign = new GuiTexturedButton(this.width(26.775f), this.height(46.7f), this.width(3.2f), this.height(5.6f));
        strengthPlusSign.setTexture(plusSign);
        strengthPlusSign.setHoveredTexture(plusHoverSign);
        strengthPlusSign.setCallback(guiComponent -> {
            if (this.statPoints > 0) {
                ModPackets.NETWORK.sendToServer((IMessage)new StatisticChangePacket(StatisticChangePacket.Statistic.STRENGTH));
                ++this.strength;
                --this.statPoints;
                System.out.println("Plus sign for strenght pressed");
            }
        });
        this.addComponent(strengthPlusSign);
        GuiTexturedButton speedPlusSign = new GuiTexturedButton(this.width(41.275f), this.height(46.7f), this.width(3.2f), this.height(5.6f));
        speedPlusSign.setTexture(plusSign);
        speedPlusSign.setHoveredTexture(plusHoverSign);
        speedPlusSign.setCallback(guiComponent -> {
            if (this.statPoints > 0) {
                ModPackets.NETWORK.sendToServer((IMessage)new StatisticChangePacket(StatisticChangePacket.Statistic.SPEED));
                ++this.speed;
                --this.statPoints;
                System.out.println("Plus sign for speed pressed");
            }
        });
        this.addComponent(speedPlusSign);
        GuiTexturedButton healthPlusSign = new GuiTexturedButton(this.width(55.775), this.height(46.7f), this.width(3.2f), this.height(5.6f));
        healthPlusSign.setTexture(plusSign);
        healthPlusSign.setHoveredTexture(plusHoverSign);
        healthPlusSign.setCallback(guiComponent -> {
            if (this.statPoints > 0) {
                ModPackets.NETWORK.sendToServer((IMessage)new StatisticChangePacket(StatisticChangePacket.Statistic.HEALTH));
                ++this.health;
                --this.statPoints;
                System.out.println("Plus sign for health pressed");
            }
        });
        this.addComponent(healthPlusSign);
        if (allowEnergy) {
            GuiTexturedButton energyPlusSign = new GuiTexturedButton(this.width(70.275), this.height(46.7f), this.width(3.2f), this.height(5.6f));
            energyPlusSign.setTexture(plusSign);
            energyPlusSign.setHoveredTexture(plusHoverSign);
            energyPlusSign.setCallback(guiComponent -> {
                if (this.statPoints > 0) {
                    ModPackets.NETWORK.sendToServer((IMessage)new StatisticChangePacket(StatisticChangePacket.Statistic.ENERGY));
                    ++this.energy;
                    --this.statPoints;
                    if (this.energy >= 10) {
                        energyPlusSign.setEnabled(false);
                        this.addEnergyLock(data.getLevel() >= 20);
                    }
                    System.out.println("Plus sign for energy pressed");
                }
            });
            this.addComponent(energyPlusSign);
        }
        GuiTexturedButton strengthPointIndicator = new GuiTexturedButton((double)this.width(21.5f), (double)this.height(65.2f), (double)this.width(13.75f), (double)this.height(7.4f), new TextInfo("Force : " + this.strength, 4334645, 3.8, false));
        strengthPointIndicator.setTexture(longPaper);
        strengthPointIndicator.setUpdate(guiTexturedButton -> {
            TextInfo newTextInfo = guiTexturedButton.getTextInfo();
            newTextInfo.setString("Force : " + this.strength);
            guiTexturedButton.setTextInfo(newTextInfo);
        });
        this.addComponent(strengthPointIndicator);
        GuiTexturedButton speedPointIndicator = new GuiTexturedButton((double)this.width(36.0f), (double)this.height(65.2f), (double)this.width(13.75f), (double)this.height(7.4f), new TextInfo("Vitesse : " + this.speed, 4334646, 3.8, false));
        speedPointIndicator.setTexture(longPaper);
        speedPointIndicator.setUpdate(guiTexturedButton -> {
            TextInfo newTextInfo = guiTexturedButton.getTextInfo();
            newTextInfo.setString("Vitesse : " + this.speed);
            guiTexturedButton.setTextInfo(newTextInfo);
        });
        this.addComponent(speedPointIndicator);
        GuiTexturedButton healthPointIndicator = new GuiTexturedButton((double)this.width(50.5f), (double)this.height(65.2f), (double)this.width(13.75f), (double)this.height(7.4f), new TextInfo("Vie : " + this.health, 4334647, 3.8, false));
        healthPointIndicator.setTexture(longPaper);
        healthPointIndicator.setUpdate(guiTexturedButton -> {
            TextInfo newTextInfo = guiTexturedButton.getTextInfo();
            newTextInfo.setString("Vie : " + this.health);
            guiTexturedButton.setTextInfo(newTextInfo);
        });
        this.addComponent(healthPointIndicator);
        GuiTexturedButton energyPointIndicator = new GuiTexturedButton((double)this.width(65.0f), (double)this.height(65.2f), (double)this.width(13.75f), (double)this.height(7.4f), new TextInfo("\u00c9nergie : " + this.energy, 4334648, 3.8, false));
        energyPointIndicator.setTexture(longPaper);
        energyPointIndicator.setUpdate(guiTexturedButton -> {
            TextInfo newTextInfo = guiTexturedButton.getTextInfo();
            newTextInfo.setString("\u00c9nergie : " + this.energy);
            guiTexturedButton.setTextInfo(newTextInfo);
        });
        this.addComponent(energyPointIndicator);
    }

    @Override
    public void func_73863_a(int scaledMouseX, int scaledMouseY, float ticks) {
        super.func_73863_a(scaledMouseX, scaledMouseY, ticks);
        if (!this.updated) {
            return;
        }
        this.func_73866_w_();
    }

    private void addEnergyLock(boolean isLevel20) {
        GuiTexturedButton energyLock = new GuiTexturedButton(this.width(70.275), this.height(46.7f), this.width(3.2f), this.height(5.6f));
        energyLock.setTexture(lock);
        if (!isLevel20) {
            energyLock.setTooltipsText("\u00a7cVous devez \u00eatre niveau 20");
        } else {
            energyLock.setTooltipsText("\u00a7cLimite atteinte");
        }
        this.addComponent(energyLock);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        this.func_146276_q_();
        GuiUtils.drawImageTransparent(this.width(0.0f), this.height(0.0f), background, this.width(100.0f), this.height(100.0f));
    }

    public int getStrength() {
        return this.strength;
    }

    public int getSpeed() {
        return this.speed;
    }

    public int getHealth() {
        return this.health;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getStatPoints() {
        return this.statPoints;
    }
}

