/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.practical;

import fr.minepiece.client.gui.component.PlayerRenderer;
import fr.minepiece.client.gui.component.button.GuiAPI;
import fr.minepiece.client.gui.component.button.GuiTexturedButton;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.textarea.GuiSimpleTextLabel;
import fr.minepiece.client.gui.component.textarea.TextInfo;
import fr.minepiece.common.api.utils.PlayerUtils;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class IdentityGui
extends GuiAPI {
    private static final ResourceLocation background = new ResourceLocation("minepiece", "textures/gui/new/base/base_interface_inv.png");
    private static final ResourceLocation visualizer = new ResourceLocation("minepiece", "textures/gui/new/visualizers/modele_carte_identite.png");
    private static final ResourceLocation paperUltraLong = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_3.png");
    private static final ResourceLocation paperShort = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_5.png");
    private static final ResourceLocation mediumPaper = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_4.png");
    private static final ResourceLocation emptyBar = new ResourceLocation("minepiece", "textures/gui/new/composants/carte_identite_bar.png");
    private static final ResourceLocation jobBar = new ResourceLocation("minepiece", "textures/gui/new/composants/carte_identite_bar_metier.png");
    private static final ResourceLocation xpBar = new ResourceLocation("minepiece", "textures/gui/new/composants/carte_identite_bar_xp.png");
    private final String username;
    private static final Minecraft minecraft = Minecraft.func_71410_x();

    public IdentityGui(String username) {
        super(null, "identity_card");
        this.username = username;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        EntityPlayer player = PlayerUtils.getPlayerByUsername(this.username);
        assert (player != null);
        IMinePieceData stats = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        String prenom = stats.getRPName();
        String nom = stats.getRPLastName();
        int age = stats.getRPAge();
        String race = stats.getRace().getName();
        int xp = stats.getXP();
        int level = stats.getLevel();
        long requiredXp = PlayerUtils.calculateRequiredXP(1 + level);
        PlayerRenderer playerRenderer = new PlayerRenderer(this.width(31.0f), this.height(19.0f), this.width(12.15f), this.height(30.0f), Minecraft.func_71410_x());
        playerRenderer.setScale(160.0f);
        this.addComponent(playerRenderer);
        GuiTexturedButton prenomDisplay = new GuiTexturedButton((double)this.width(46.3f), (double)this.height(19.0f), (double)this.width(22.7f), (double)this.height(7.5f), new TextInfo(prenom, 0x422433, 4.0, false));
        prenomDisplay.setTexture(paperUltraLong);
        this.addComponent(prenomDisplay);
        GuiTexturedButton nomDisplay = new GuiTexturedButton((double)this.width(46.3f), (double)this.height(27.5f), (double)this.width(22.7f), (double)this.height(7.5f), new TextInfo(nom, 0x422432, 4.0, false));
        nomDisplay.setTexture(paperUltraLong);
        this.addComponent(nomDisplay);
        GuiTexturedButton ageDisplay = new GuiTexturedButton((double)this.width(46.3f), (double)this.height(36.6f), (double)this.width(5.8f), (double)this.height(7.5f), new TextInfo(String.valueOf(age), 4334641, 4.0, false));
        ageDisplay.setTexture(paperShort);
        ageDisplay.setTooltipsText("Age");
        this.addComponent(ageDisplay);
        GuiTexturedButton raceDisplay = new GuiTexturedButton((double)this.width(57.5f), (double)this.height(36.6f), (double)this.width(11.5f), (double)this.height(7.5f), new TextInfo(race, 4334640, 2.7, false));
        raceDisplay.setTexture(mediumPaper);
        this.addComponent(raceDisplay);
        GuiTexturedButton playerLevelBackground = new GuiTexturedButton(this.width(33.05f), this.height(53.3f), this.width(33.85), this.height(2.95f));
        playerLevelBackground.setTexture(emptyBar);
        playerLevelBackground.setTooltipsText("\u00a7aNiveau " + level);
        this.addComponent(playerLevelBackground);
        GuiTexturedButton playerLevelProgression = new GuiTexturedButton(this.width(33.33f), this.height(53.8f), this.width((double)((float)xp / (float)requiredXp) * 33.37), this.height(1.95));
        playerLevelProgression.setTexture(xpBar);
        this.addComponent(playerLevelProgression);
        GuiSimpleTextLabel playerLevelDisplay = new GuiSimpleTextLabel((double)this.width(33.05f), (double)this.height(53.7f), this.width(33.85), (double)this.height(2.95f), new TextInfo(xp + " / " + requiredXp, Color.white.getRGB(), 2.7, false));
        this.addComponent(playerLevelDisplay);
        int jobID = stats.getJobID();
        String jobName = "";
        int jobXP = stats.getJobXP();
        int jobLevel = stats.getJobLevel();
        long jobRequiredXp = PlayerUtils.calculateRequiredXP(1 + jobLevel);
        if (jobID == 0) {
            jobName = "M\u00e9decin";
        }
        if (jobID == 1) {
            jobName = "Cuisinier";
        }
        if (jobID == 2) {
            jobName = "Forgeron";
        }
        GuiTexturedButton jobDisplay = new GuiTexturedButton((double)this.width(33.05f), (double)this.height(57.5f), (double)this.width(11.5f), (double)this.height(7.5f), new TextInfo(jobName, 4334640, 2.7, false));
        jobDisplay.setTexture(mediumPaper);
        this.addComponent(jobDisplay);
        GuiTexturedButton jobLevelDisplay = new GuiTexturedButton((double)this.width(46.3f), (double)this.height(57.5f), (double)this.width(5.8f), (double)this.height(7.5f), new TextInfo(String.valueOf(jobLevel), 4334641, 4.0, false));
        jobLevelDisplay.setTexture(paperShort);
        jobLevelDisplay.setTooltipsText("Job level");
        this.addComponent(jobLevelDisplay);
        GuiTexturedButton playerJobLevelBackground = new GuiTexturedButton(this.width(33.05f), this.height(68.3f), this.width(33.85), this.height(2.95f));
        playerJobLevelBackground.setTexture(emptyBar);
        playerJobLevelBackground.setTooltipsText("\u00a7aNiveau " + jobLevel);
        this.addComponent(playerJobLevelBackground);
        GuiTexturedButton playerJobLevelProgression = new GuiTexturedButton(this.width(33.33f), this.height(68.8f), this.width((double)((float)jobXP / (float)jobRequiredXp) * 33.37), this.height(1.95));
        playerJobLevelProgression.setTexture(xpBar);
        this.addComponent(playerJobLevelProgression);
        GuiSimpleTextLabel playerJobLevelDisplay = new GuiSimpleTextLabel((double)this.width(33.05f), (double)this.height(68.7f), this.width(33.85), (double)this.height(2.95f), new TextInfo(jobXP + " / " + jobRequiredXp, Color.white.getRGB(), 2.7, false));
        this.addComponent(playerJobLevelDisplay);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        this.func_146276_q_();
        GuiUtils.drawImageTransparent(this.width(25.0f), this.height(9.3f), background, this.width(51.5f), this.height(81.7f));
    }
}

