/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.practical;

import fr.minepiece.client.config.ClientConfig;
import fr.minepiece.client.gui.component.button.GuiAPI;
import fr.minepiece.client.gui.component.button.GuiButton;
import fr.minepiece.client.gui.component.button.GuiTexturedButton;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.button.scroll.ScrollArea;
import fr.minepiece.client.gui.component.button.scroll.ScrollableArea;
import fr.minepiece.client.gui.component.textarea.TextInfo;
import fr.minepiece.common.api.abilities.AbilitiesEnum;
import fr.minepiece.common.capability.CapabilityHelper;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class AbilitySelectionGui
extends GuiAPI {
    private static final ResourceLocation background = new ResourceLocation("minepiece", "textures/gui/new/base/base_interface_large.png");
    private static final ResourceLocation visualizer = new ResourceLocation("minepiece", "textures/gui/new/visualizers/modele_competance.png");
    private static final ResourceLocation visualizerSmall = new ResourceLocation("minepiece", "textures/gui/new/visualizers/modele_competance_maquette.png");
    private static final ResourceLocation visualizerBig = new ResourceLocation("minepiece", "textures/gui/new/visualizers/modele_competance_maquetteV2.png");
    private static final ResourceLocation container_small = new ResourceLocation("minepiece", "textures/gui/new/composants/container_small.png");
    private static final ResourceLocation container_big = new ResourceLocation("minepiece", "textures/gui/new/composants/container_big.png");
    private static final ResourceLocation container_small_inner = new ResourceLocation("minepiece", "textures/gui/new/composants/container_small_inner.png");
    private static final ResourceLocation container_small_outer = new ResourceLocation("minepiece", "textures/gui/new/composants/container_small_outer.png");
    private static final ResourceLocation container_big_inner = new ResourceLocation("minepiece", "textures/gui/new/composants/container_big_inner.png");
    private static final ResourceLocation container_big_outer = new ResourceLocation("minepiece", "textures/gui/new/composants/container_big_outer.png");
    private static final ResourceLocation scroll = new ResourceLocation("minepiece", "textures/gui/new/composants/scrollbar.png");
    private static final ResourceLocation scrollHover = new ResourceLocation("minepiece", "textures/gui/new/composants/scrollbar_hover.png");
    private static final ResourceLocation smallField = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_5.png");
    private static final ResourceLocation longField = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_3.png");
    private static final ResourceLocation empty = new ResourceLocation("minepiece", "textures/empty.png");
    private ArrayList<AbilitiesEnum> abilitiesBar = new ArrayList();

    public AbilitySelectionGui() {
        super(null, "ability_selection");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.updateAbilitiesBar();
        this.addScrollableArea(this.addAbilitiesSelector());
        this.addScrollableArea(this.addAbilitiesViewer());
        this.func_73876_c();
    }

    private void updateAbilitiesBar() {
        this.abilitiesBar = ClientConfig.getSkills().stream().map(AbilitiesEnum::getAbilityFromName).collect(Collectors.toCollection(ArrayList::new));
    }

    private ScrollableArea addAbilitiesViewer() {
        GuiTexturedButton smallInner = new GuiTexturedButton(this.width(23.18f), this.height(17.04f), this.width(12.55f), this.height(65.37f));
        smallInner.setTexture(container_small_inner);
        this.addComponent(smallInner);
        GuiButton innerContainer = new GuiButton(this.width(25.0f), this.height(20.28f), this.width(8.91f), this.height(58.89f));
        ScrollableArea scrollableArea = new ScrollableArea(this.width(25.0f), this.height(20.28f), this.width(33.91f), this.height(79.17f), new ScrollArea(this.width(33.59f), this.height(20.28f), this.height(58.89f), this.width(3.18f), this.height(7.03f)));
        scrollableArea.setScrollTexture(String.valueOf(scroll).replace(".png", "")).setScrollHoverTexture(String.valueOf(scrollHover).replace(".png", ""));
        innerContainer.setArea(scrollableArea);
        this.removeImpossibleAbilities();
        for (int i = 0; i < this.abilitiesBar.size(); ++i) {
            AbilitiesEnum ability = this.abilitiesBar.get(i);
            GuiTexturedButton field = new GuiTexturedButton(this.width(1.5f), this.height(2.0f) + this.height(12.0f) * (float)i, this.width(5.78f), this.height(7.5f));
            field.setTexture(smallField);
            innerContainer.addChild(field);
            GuiTexturedButton icon = new GuiTexturedButton(this.width(2.74f), this.height(2.95f) + this.height(12.0f) * (float)i, this.width(3.18f), this.height(5.64f));
            int finalI = i;
            icon.setCallback(node -> {
                this.removeAbility(finalI);
                this.updateAbilitiesBar();
                if (this.abilitiesBar.get(finalI) != null) {
                    ((GuiTexturedButton)node).setTexture(this.abilitiesBar.get(finalI).getIcon());
                } else {
                    ((GuiTexturedButton)node).setTexture(empty);
                }
            });
            icon.setUpdate(node -> {
                if (this.abilitiesBar.get(finalI) != null) {
                    node.setTexture(this.abilitiesBar.get(finalI).getIcon());
                } else {
                    node.setTexture(empty);
                }
            });
            innerContainer.addChild(icon);
            if (ability != null) {
                icon.setTexture(ability.getIcon());
                continue;
            }
            icon.setTexture(empty);
        }
        this.addComponent(innerContainer);
        GuiTexturedButton smallOuter = new GuiTexturedButton(this.width(23.18f), this.height(17.04f), this.width(12.55f), this.height(65.37f));
        smallOuter.setTexture(container_small_outer);
        this.addComponent(smallOuter);
        return scrollableArea;
    }

    private ScrollableArea addAbilitiesSelector() {
        GuiTexturedButton bigInner = new GuiTexturedButton(this.width(35.73f), this.height(15.65f), this.width(41.93f), this.height(68.15f));
        bigInner.setTexture(container_big_inner);
        this.addComponent(bigInner);
        GuiButton innerContainer = new GuiButton(this.width(37.55f), this.height(18.98f), this.width(38.23f), this.height(61.48f));
        ScrollableArea scrollableArea = new ScrollableArea(this.width(37.56f), this.height(18.98f), this.width(75.78f), this.height(80.46f), new ScrollArea(this.width(75.31f), this.height(18.8f), this.height(61.57f), this.width(3.18f), this.height(7.03f)));
        scrollableArea.setScrollTexture(String.valueOf(scroll).replace(".png", "")).setScrollHoverTexture(String.valueOf(scrollHover).replace(".png", ""));
        innerContainer.setArea(scrollableArea);
        ArrayList<String> abilities = CapabilityHelper.getPlayerData((EntityPlayer)this.field_146297_k.field_71439_g).getSkills();
        int i = 0;
        while (i < abilities.size()) {
            AbilitiesEnum ability = AbilitiesEnum.getAbilityFromName(abilities.get(i));
            assert (ability != null);
            float margin = this.height(10.0f) * (float)i;
            GuiTexturedButton iconField = new GuiTexturedButton(this.width(0.7f), this.height(2.45f) + margin, this.width(5.78f), this.height(7.5f));
            iconField.setTexture(smallField);
            innerContainer.addChild(iconField);
            GuiTexturedButton descriptionField = new GuiTexturedButton((double)this.width(7.0f), (double)(this.height(2.0f) + margin), (double)this.width(30.26f), (double)this.height(8.42f), new TextInfo(I18n.func_135052_a((String)ability.getDescription(), (Object[])new Object[0]), 0x422433 + i, 4.0, false));
            descriptionField.setTexture(longField);
            innerContainer.addChild(descriptionField);
            GuiTexturedButton icon = new GuiTexturedButton(this.width(2.0f), this.height(3.39f) + margin, this.width(3.18f), this.height(5.63f));
            int finalI = i++;
            icon.setCallback(node -> {
                if (this.isAbilityAlredySelected(ability)) {
                    return;
                }
                this.abilitiesBar.set(finalI, ability);
                this.addAbilityAtBottom(ability);
            });
            icon.setTexture(ability.getIcon());
            innerContainer.addChild(icon);
        }
        this.addComponent(innerContainer);
        GuiTexturedButton bigOuter = new GuiTexturedButton(this.width(35.73f), this.height(15.65f), this.width(41.93f), this.height(68.15f));
        bigOuter.setTexture(container_big_outer);
        this.addComponent(bigOuter);
        return scrollableArea;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        this.func_146276_q_();
        GuiUtils.drawImageTransparent(this.width(0.0f), this.height(0.0f), visualizerBig, this.width(100.0f), this.height(100.0f));
    }

    private boolean isAbilityAlredySelected(AbilitiesEnum ability) {
        return this.abilitiesBar.contains((Object)ability);
    }

    private void addAbilityAtBottom(AbilitiesEnum ability) {
        ArrayList<String> abilities = ClientConfig.getSkills();
        for (int i = 0; i < abilities.size(); ++i) {
            if (!Objects.equals(abilities.get(i), "")) continue;
            ClientConfig.setSkill(i + 1, ability.getName());
            this.updateAbilitiesBar();
            break;
        }
    }

    private void removeAbility(int index) {
        ClientConfig.setSkill(index + 1, "");
        this.abilitiesBar.set(index, null);
    }

    private void removeImpossibleAbilities() {
        ArrayList<String> abilities = ClientConfig.getSkills();
        System.out.println("ABILITIES: " + abilities);
        for (int i = 0; i < abilities.size(); ++i) {
            AbilitiesEnum ability = AbilitiesEnum.getAbilityFromName(abilities.get(i));
            ArrayList<String> unlocked = CapabilityHelper.getPlayerData((EntityPlayer)this.field_146297_k.field_71439_g).getSkills();
            if (ability == null || !unlocked.contains(ability.getName())) {
                abilities.set(i, "");
            }
            ClientConfig.setSkill(i + 1, abilities.get(i));
        }
        this.updateAbilitiesBar();
    }
}

