/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.playercustomization;

import fr.minepiece.client.gui.playercustomization.AbstractModificationGui;
import fr.minepiece.common.capability.CapabilityHelper;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiPageButtonList;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlider;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class ColorSelectorGui
extends GuiScreen {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("minepiece", "textures/gui/background.png");
    private ScaledResolution res = null;
    private Minecraft MC = Minecraft.func_71410_x();
    private float hue = 0.0f;
    private float saturation = 0.0f;
    private float brightness = 0.0f;
    private GuiPageButtonList.GuiResponder modificationGuiResponder = new GuiPageButtonList.GuiResponder(){

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
            if (id == 0) {
                ColorSelectorGui.this.hue = value / 355.0f;
            } else if (id == 1) {
                ColorSelectorGui.this.saturation = value / 100.0f;
            } else if (id == 2) {
                ColorSelectorGui.this.brightness = value / 100.0f;
            }
            ColorSelectorGui.this.color = Color.HSBtoRGB(ColorSelectorGui.this.hue, ColorSelectorGui.this.saturation, ColorSelectorGui.this.brightness);
            CapabilityHelper.getPlayerModifications((EntityPlayer)((ColorSelectorGui)ColorSelectorGui.this).MC.field_71439_g).setModificationColor(ColorSelectorGui.this.color);
        }

        public void func_175319_a(int id, String value) {
        }
    };
    private GuiPageButtonList.GuiResponder skinGuiResponder = new GuiPageButtonList.GuiResponder(){

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
            if (id == 0) {
                ColorSelectorGui.this.hue = value / 355.0f;
            } else if (id == 1) {
                ColorSelectorGui.this.saturation = value / 100.0f;
            } else if (id == 2) {
                ColorSelectorGui.this.brightness = value / 100.0f;
            }
            ColorSelectorGui.this.color = Color.HSBtoRGB(ColorSelectorGui.this.hue, ColorSelectorGui.this.saturation, ColorSelectorGui.this.brightness);
            CapabilityHelper.getPlayerModifications((EntityPlayer)((ColorSelectorGui)ColorSelectorGui.this).MC.field_71439_g).setSkinColor(ColorSelectorGui.this.color);
        }

        public void func_175319_a(int id, String value) {
        }
    };
    private GuiPageButtonList.GuiResponder doubleGuiResponder = new GuiPageButtonList.GuiResponder(){

        public void func_175321_a(int id, boolean value) {
        }

        public void func_175320_a(int id, float value) {
            if (id == 0) {
                ColorSelectorGui.this.hue = value / 355.0f;
            } else if (id == 1) {
                ColorSelectorGui.this.saturation = value / 100.0f;
            } else if (id == 2) {
                ColorSelectorGui.this.brightness = value / 100.0f;
            }
            ColorSelectorGui.this.color = Color.HSBtoRGB(ColorSelectorGui.this.hue, ColorSelectorGui.this.saturation, ColorSelectorGui.this.brightness);
            CapabilityHelper.getPlayerModifications((EntityPlayer)((ColorSelectorGui)ColorSelectorGui.this).MC.field_71439_g).setSkinColor(ColorSelectorGui.this.color);
            CapabilityHelper.getPlayerModifications((EntityPlayer)((ColorSelectorGui)ColorSelectorGui.this).MC.field_71439_g).setModificationColor(ColorSelectorGui.this.color);
        }

        public void func_175319_a(int id, String value) {
        }
    };
    private final boolean isModification;
    private int color = 0;
    private AbstractModificationGui previousGui;
    private ArrayList<String> currentModifications;

    public ColorSelectorGui(AbstractModificationGui previousGui, ArrayList<String> currentModifications, boolean isModification) {
        this.previousGui = previousGui;
        this.currentModifications = currentModifications;
        this.isModification = isModification;
    }

    public ColorSelectorGui(AbstractModificationGui previousGui) {
        this.previousGui = previousGui;
        this.isModification = true;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        int borderSize = 3;
        ColorSelectorGui.func_73734_a((int)(this.field_146294_l / 2 - borderSize), (int)(this.field_146295_m / 2 - 120 - borderSize), (int)(this.field_146294_l / 2 + 150 + borderSize), (int)(this.field_146295_m / 2 - 40 + borderSize), (int)Color.BLACK.getRGB());
        ColorSelectorGui.func_73734_a((int)(this.field_146294_l / 2), (int)(this.field_146295_m / 2 - 120), (int)(this.field_146294_l / 2 + 150), (int)(this.field_146295_m / 2 - 40), (int)this.color);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.drawEntityOnScreen(this.field_146294_l / 2 - 70, this.field_146295_m / 2 + 45, 90, mouseX, mouseY + 150, (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 3) {
            this.previousGui.modifications = this.currentModifications;
            System.out.println("SETTING MODIFICATIONS TO: " + this.currentModifications);
            this.MC.func_147108_a((GuiScreen)this.previousGui);
        }
    }

    public void func_73866_w_() {
        Enum limitations;
        this.res = new ScaledResolution(this.MC);
        GuiSlider.FormatHelper formatHelper = new GuiSlider.FormatHelper(){

            public String func_175318_a(int id, String name, float value) {
                return name + ": " + Math.round(value);
            }
        };
        Enum enum_ = limitations = this.isModification ? ColorSelectorGui.getModificationLimitation((EntityPlayer)this.MC.field_71439_g) : ColorSelectorGui.getSkinLimitation((EntityPlayer)this.MC.field_71439_g);
        if (limitations.getMinHue() == -1) {
            limitations = ColorSelectorGui.getModificationLimitation((EntityPlayer)this.MC.field_71439_g);
        }
        GuiPageButtonList.GuiResponder responder = this.isModification ? this.modificationGuiResponder : this.skinGuiResponder;
        SkinLimitations skinLimitations = ColorSelectorGui.getSkinLimitation((EntityPlayer)this.MC.field_71439_g);
        if (skinLimitations.getMinHue() == -1) {
            System.out.println("Skin is linked to modification");
            responder = this.doubleGuiResponder;
        }
        this.field_146292_n.add(new GuiSlider(responder, 0, this.field_146294_l / 2, this.field_146295_m / 2 - 25, "Teinte", (float)limitations.getMinHue(), (float)limitations.getMaxHue(), (float)limitations.getMaxHue(), formatHelper));
        this.field_146292_n.add(new GuiSlider(responder, 1, this.field_146294_l / 2, this.field_146295_m / 2, "Saturation", (float)limitations.getMinSat(), (float)limitations.getMaxSat(), (float)limitations.getMaxSat(), formatHelper));
        this.field_146292_n.add(new GuiSlider(responder, 2, this.field_146294_l / 2, this.field_146295_m / 2 + 25, "Luminosit\u00e9", (float)limitations.getMinBright(), (float)limitations.getMaxBright(), (float)limitations.getMaxBright(), formatHelper));
        responder.func_175320_a(0, (float)limitations.getMaxHue());
        responder.func_175320_a(1, (float)limitations.getMaxSat());
        responder.func_175320_a(2, (float)limitations.getMaxBright());
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 - 100, this.field_146295_m / 2 + 60, 200, 20, "Retour"));
    }

    public void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityLivingBase ent) {
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)300.0f);
        GlStateManager.func_179152_a((float)(-scale), (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float renderYawOffset = ent.field_70761_aq;
        float yaw = ent.field_70177_z;
        float pitch = ent.field_70125_A;
        float prevRotationYawHead = ent.field_70758_at;
        float rotationYawHead = ent.field_70759_as;
        float entityX = mouseX - (float)posX;
        float entityY = mouseY - (float)posY;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float bodyRotation = (float)Math.atan(entityX / 40.0f) * 20.0f;
        GlStateManager.func_179114_b((float)bodyRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        float bodyVerticalRotation = (float)Math.atan(entityY / 40.0f) * 10.0f;
        GlStateManager.func_179114_b((float)bodyVerticalRotation, (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)(-Math.atan(entityX / 40.0f)) * 20.0f;
        ent.field_70177_z = -((float)Math.atan(entityX / 40.0f) * 40.0f);
        ent.field_70125_A = (float)Math.atan(entityY / 40.0f) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = renderYawOffset;
        ent.field_70177_z = yaw;
        ent.field_70125_A = pitch;
        ent.field_70758_at = prevRotationYawHead;
        ent.field_70759_as = rotationYawHead;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    public boolean func_73868_f() {
        return false;
    }

    public static ModificationLimitations getModificationLimitation(EntityPlayer player) {
        switch (CapabilityHelper.getPlayerData(player).getRace()) {
            case FISHMAN: {
                if (ColorSelectorGui.isMermaid(player)) {
                    return ModificationLimitations.MERMAID;
                }
                return ModificationLimitations.FISHMAN;
            }
            case TONTATTA: {
                return ModificationLimitations.TONTATTA;
            }
            case MINKS: {
                return ModificationLimitations.MINKS;
            }
            case CYBORG: {
                return ModificationLimitations.CYBORG;
            }
        }
        return ModificationLimitations.HUMAN;
    }

    public static SkinLimitations getSkinLimitation(EntityPlayer player) {
        switch (CapabilityHelper.getPlayerData(player).getRace()) {
            case FISHMAN: {
                if (ColorSelectorGui.isMermaid(player)) {
                    return SkinLimitations.MERMAID;
                }
                return SkinLimitations.FISHMAN;
            }
            case TONTATTA: {
                return SkinLimitations.TONTATTA;
            }
            case MINKS: {
                return SkinLimitations.MINKS;
            }
            case CYBORG: {
                return SkinLimitations.CYBORG;
            }
            case GIANT: {
                return SkinLimitations.GIANT;
            }
            case HUMAN: {
                return SkinLimitations.HUMAN;
            }
        }
        return SkinLimitations.HUMAN;
    }

    private static boolean isMermaid(EntityPlayer player) {
        List<String> mermaidModifications = Arrays.asList("shark_tail", "mermaid_tail", "sea_horse_tail", "gold_fish_tail", "whale_shark_tail", "back_sea_horse_fin");
        return CapabilityHelper.getPlayerModifications(player).getModifications().stream().anyMatch(mermaidModifications::contains);
    }

    public static enum SkinLimitations implements Limitations
    {
        FISHMAN(-1, -1, -1, -1, -1, -1),
        MERMAID(0, 35, 25, 65, 25, 100),
        TONTATTA(5, 35, 20, 60, 10, 100),
        MINKS(-1, -1, -1, -1, -1, -1),
        CYBORG(5, 35, 20, 60, 10, 100),
        HUMAN(5, 35, 20, 60, 10, 100),
        GIANT(5, 35, 20, 60, 10, 100);

        public final int minHue;
        public final int maxHue;
        public final int minSat;
        public final int maxSat;
        public final int minBright;
        public final int maxBright;

        private SkinLimitations(int minHue, int maxHue, int minSat, int maxSat, int minBright, int maxBright) {
            this.minHue = minHue;
            this.maxHue = maxHue;
            this.minSat = minSat;
            this.maxSat = maxSat;
            this.minBright = minBright;
            this.maxBright = maxBright;
        }

        @Override
        public int getMinHue() {
            return this.minHue;
        }

        @Override
        public int getMaxHue() {
            return this.maxHue;
        }

        @Override
        public int getMinSat() {
            return this.minSat;
        }

        @Override
        public int getMaxSat() {
            return this.maxSat;
        }

        @Override
        public int getMinBright() {
            return this.minBright;
        }

        @Override
        public int getMaxBright() {
            return this.maxBright;
        }
    }

    public static enum ModificationLimitations implements Limitations
    {
        FISHMAN(0, 355, 25, 65, 50, 100),
        MERMAID(0, 355, 25, 65, 25, 100),
        TONTATTA(0, 355, 20, 80, 10, 100),
        MINKS(15, 55, 15, 80, 10, 100),
        CYBORG(25, 55, 15, 60, 15, 90),
        HUMAN(-1, -1, -1, -1, -1, -1),
        GIANT(-1, -1, -1, -1, -1, -1);

        public final int minHue;
        public final int maxHue;
        public final int minSat;
        public final int maxSat;
        public final int minBright;
        public final int maxBright;

        private ModificationLimitations(int minHue, int maxHue, int minSat, int maxSat, int minBright, int maxBright) {
            this.minHue = minHue;
            this.maxHue = maxHue;
            this.minSat = minSat;
            this.maxSat = maxSat;
            this.minBright = minBright;
            this.maxBright = maxBright;
        }

        @Override
        public int getMinHue() {
            return this.minHue;
        }

        @Override
        public int getMaxHue() {
            return this.maxHue;
        }

        @Override
        public int getMinSat() {
            return this.minSat;
        }

        @Override
        public int getMaxSat() {
            return this.maxSat;
        }

        @Override
        public int getMinBright() {
            return this.minBright;
        }

        @Override
        public int getMaxBright() {
            return this.maxBright;
        }
    }

    public static interface Limitations {
        public int getMinHue();

        public int getMaxHue();

        public int getMinSat();

        public int getMaxSat();

        public int getMinBright();

        public int getMaxBright();
    }
}

