/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.playercustomization;

import fr.minepiece.client.gui.component.PlayerRenderer;
import fr.minepiece.client.gui.component.button.GuiAPI;
import fr.minepiece.client.gui.component.button.GuiTexturedButton;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.textarea.TextInfo;
import fr.minepiece.client.gui.playercustomization.ColorSelectorGui;
import fr.minepiece.client.model.modifications.SkinModifications;
import fr.minepiece.client.render.Skins;
import fr.minepiece.common.api.races.MinePieceRaces;
import fr.minepiece.common.capability.CapabilityHelper;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import fr.minepiece.common.network.ModPackets;
import fr.minepiece.common.network.packets.ModificationSyncPacket;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public abstract class AbstractModificationGui
extends GuiAPI {
    private static final ResourceLocation background = new ResourceLocation("minepiece", "textures/gui/new/base/base_interface_papier_signhere.png");
    private static final ResourceLocation visualizer = new ResourceLocation("minepiece", "textures/gui/new/visualizers/modele_skin_sexe.png");
    private static final ResourceLocation bigField = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_grande_fp.png");
    private static final ResourceLocation smallField = new ResourceLocation("minepiece", "textures/gui/new/composants/zone_de_texte_petite_fp.png");
    private static final ResourceLocation leftArrow = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_gauche_courbe_unhovered.png");
    private static final ResourceLocation rightArrow = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_droite_courbe_unhovered.png");
    private static final ResourceLocation leftArrowHovered = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_gauche_courbe.png");
    private static final ResourceLocation rightArrowHovered = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_droite_courbe.png");
    private static final ResourceLocation playerRender = new ResourceLocation("minepiece", "textures/gui/new/composants/papier_player.png");
    protected static final ResourceLocation rightArrowBig = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_droite.png");
    protected static final ResourceLocation rightArrowBigHovered = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_droite_hover.png");
    protected static final ResourceLocation leftArrowBig = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_gauche.png");
    protected static final ResourceLocation leftArrowBigHovered = new ResourceLocation("minepiece", "textures/gui/new/composants/fleche_de_gauche_hover.png");
    private static final ResourceLocation nextSmallArrow = new ResourceLocation("minepiece", "textures/gui/new/composants/droites.png");
    private static final ResourceLocation nextSmallHover = new ResourceLocation("minepiece", "textures/gui/new/composants/droite_hover.png");
    private static final ResourceLocation previousSmallArrow = new ResourceLocation("minepiece", "textures/gui/new/composants/gauche.png");
    private static final ResourceLocation previousSmallHover = new ResourceLocation("minepiece", "textures/gui/new/composants/gauche_hover.png");
    protected static final ResourceLocation colorSelector = new ResourceLocation("minepiece", "textures/gui/new/composants/color_selector.png");
    protected static final ResourceLocation signatureUnhovered = new ResourceLocation("minepiece", "textures/gui/new/composants/popup/x_unhovered.png");
    protected static final ResourceLocation signatureHovered = new ResourceLocation("minepiece", "textures/gui/new/composants/popup/x_hovered.png");
    protected ArrayList<String> modifications = new ArrayList<String>(Collections.nCopies(4, ""));

    public AbstractModificationGui(String name) {
        super(null, name);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.resetModifications(this.field_146297_k.field_71439_g);
        List<HashMap<String, List<String>>> modificationsList = this.getModificationList();
        if (modificationsList.isEmpty() || modificationsList.size() > 4) {
            throw new RuntimeException("There are no provided modifications or there are more than 4 set of displayable modifications!");
        }
        for (int i = 0; i < modificationsList.size(); ++i) {
            HashMap<String, List<String>> modificationList = modificationsList.get(i);
            Set<String> modifications = modificationList.keySet();
            if (modifications.isEmpty()) {
                throw new RuntimeException("There are no provided modifications!");
            }
            if (this.modifications.get(i).isEmpty()) {
                this.modifications.set(i, modifications.iterator().next());
            }
            int finalIndex = i;
            GuiTexturedButton modificationField = new GuiTexturedButton((double)this.width(31.77f), (double)this.height(31.85f + (float)i * 12.04f), (double)this.width(16.2f), (double)this.height(10.28f), new TextInfo(this.modifications.get(finalIndex), 0x422433 + i, 4.0, false));
            modificationField.setTexture(smallField);
            modificationField.setUpdate(field -> {
                TextInfo newTextInfo = field.getTextInfo();
                newTextInfo.setString(this.modifications.get(finalIndex));
                field.setTextInfo(newTextInfo);
            });
            this.addComponent(modificationField);
            GuiTexturedButton colorSelector = new GuiTexturedButton(this.width(45.47f), this.height(30.37f + (float)i * 12.04f), this.width(2.65f), this.height(4.72f));
            colorSelector.setTexture(AbstractModificationGui.colorSelector);
            colorSelector.setCallback(button -> {
                this.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new ColorSelectorGui(this, this.modifications, finalIndex == 0));
            });
            this.addComponent(colorSelector);
            GuiTexturedButton arrowPrevious = new GuiTexturedButton(this.width(28.12f), this.height(34.63f + (float)i * 12.04f), this.width(3.98f), this.height(4.26f));
            arrowPrevious.setTexture(leftArrow);
            arrowPrevious.setHoveredTexture(leftArrowHovered);
            arrowPrevious.setCallback(arrow -> {
                this.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                this.previousModification(finalIndex);
                this.updatePlayerModifications(this.field_146297_k.field_71439_g);
            });
            this.addComponent(arrowPrevious);
            GuiTexturedButton arrowNext = new GuiTexturedButton(this.width(47.66f), this.height(34.63f + (float)i * 12.04f), this.width(3.98f), this.height(4.26f));
            arrowNext.setTexture(rightArrow);
            arrowNext.setHoveredTexture(rightArrowHovered);
            arrowNext.setCallback(arrow -> {
                this.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
                this.nextModification(finalIndex);
                this.updatePlayerModifications(this.field_146297_k.field_71439_g);
            });
            this.addComponent(arrowNext);
        }
        GuiTexturedButton modificationField = new GuiTexturedButton((double)this.width(35.42f), (double)this.height(14.72f), (double)this.width(30.79f), (double)this.height(10.28f), new TextInfo("Modifications Race", 0x422433, 4.0, false));
        modificationField.setTexture(bigField);
        this.addComponent(modificationField);
        GuiTexturedButton playerBackground = new GuiTexturedButton(this.width(52.08f), this.height(32.78f), this.width(18.81f), this.height(43.61f));
        playerBackground.setTexture(playerRender);
        this.addComponent(playerBackground);
        PlayerRenderer playerRenderer = new PlayerRenderer(this.width(52.08f), this.height(33.78f), this.width(18.81f), this.height(41.61f), Minecraft.func_71410_x());
        playerRenderer.setScale(230.0f);
        this.addComponent(playerRenderer);
        GuiTexturedButton rotatePlayerRight = new GuiTexturedButton(this.width(63.96f), this.height(26.39f), this.width(2.5f), this.height(5.2f));
        rotatePlayerRight.setTexture(nextSmallArrow);
        rotatePlayerRight.setHoveredTexture(nextSmallHover);
        rotatePlayerRight.setCallback(nameNext -> {
            playerRenderer.increaseYawOffset(-15.0f);
            this.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
        });
        this.addComponent(rotatePlayerRight);
        GuiTexturedButton rotatePlayerLeft = new GuiTexturedButton(this.width(56.09f), this.height(26.39f), this.width(2.5f), this.height(5.2f));
        rotatePlayerLeft.setTexture(previousSmallArrow);
        rotatePlayerLeft.setHoveredTexture(previousSmallHover);
        rotatePlayerLeft.setCallback(namePrevious -> {
            playerRenderer.increaseYawOffset(15.0f);
            this.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
        });
        this.addComponent(rotatePlayerLeft);
        GuiTexturedButton sign = new GuiTexturedButton(this.width(62.76f), this.height(80.93f), this.width(2.92f), this.height(4.26f));
        sign.setTexture(signatureUnhovered);
        sign.setHoveredTexture(signatureHovered);
        sign.setCallback(arrow -> {
            this.field_146297_k.field_71439_g.func_184185_a(SoundEvents.field_187909_gi, 1.0f, 1.0f);
            this.field_146297_k.func_147108_a(null);
        });
        this.addComponent(sign);
        this.updatePlayerModifications(this.field_146297_k.field_71439_g);
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        this.func_146276_q_();
        GuiUtils.drawImageTransparent(this.width(27.08f), this.height(11.48), background, this.width(45.89f), this.height(76.95f));
    }

    protected void nextModification(int index) {
        List<HashMap<String, List<String>>> modificationsList = this.getModificationList();
        HashMap<String, List<String>> modificationList = modificationsList.get(index);
        ArrayList<String> modifications = new ArrayList<String>(modificationList.keySet());
        int currentIndex = modifications.indexOf(this.modifications.get(index));
        int previousIndex = (currentIndex - 1 + modifications.size()) % modifications.size();
        this.modifications.set(index, modifications.get(previousIndex));
    }

    protected void previousModification(int index) {
        List<HashMap<String, List<String>>> modificationsList = this.getModificationList();
        HashMap<String, List<String>> modificationList = modificationsList.get(index);
        ArrayList<String> modifications = new ArrayList<String>(modificationList.keySet());
        int currentIndex = modifications.indexOf(this.modifications.get(index));
        int nextIndex = (currentIndex + 1) % modifications.size();
        this.modifications.set(index, modifications.get(nextIndex));
    }

    protected void updateSkin(IPlayerModifications modifications, boolean isMinks) {
        String gender = this.modifications.get(1);
        String fit = this.modifications.get(2);
        if (isMinks) {
            if (Objects.equals(gender, "Homme")) {
                if (Objects.equals(fit, "Gros")) {
                    modifications.setSkin(Skins.MINKS_MALE_FAT.getName());
                } else if (Objects.equals(fit, "Muscle")) {
                    modifications.setSkin(Skins.MINKS_MALE_FIT.getName());
                } else if (Objects.equals(fit, "Normal")) {
                    modifications.setSkin(Skins.MINKS_MALE_NORMAL.getName());
                }
            } else if (Objects.equals(gender, "Femme")) {
                if (Objects.equals(fit, "Gros")) {
                    modifications.setSkin(Skins.MINKS_FEMALE_FAT.getName());
                } else if (Objects.equals(fit, "Muscle")) {
                    modifications.setSkin(Skins.MINKS_FEMALE_FIT.getName());
                } else if (Objects.equals(fit, "Normal")) {
                    modifications.setSkin(Skins.MINKS_FEMALE_NORMAL.getName());
                }
            }
        } else if (Objects.equals(gender, "Homme")) {
            if (Objects.equals(fit, "Gros")) {
                modifications.setSkin(Skins.HUMAN_MALE_FAT.getName());
            } else if (Objects.equals(fit, "Muscle")) {
                modifications.setSkin(Skins.HUMAN_MALE_FIT.getName());
            } else if (Objects.equals(fit, "Normal")) {
                modifications.setSkin(Skins.HUMAN_MALE_NORMAL.getName());
            }
        } else if (Objects.equals(gender, "Femme")) {
            if (Objects.equals(fit, "Gros")) {
                modifications.setSkin(Skins.HUMAN_FEMALE_FAT.getName());
            } else if (Objects.equals(fit, "Muscle")) {
                modifications.setSkin(Skins.HUMAN_FEMALE_FIT.getName());
            } else if (Objects.equals(fit, "Normal")) {
                modifications.setSkin(Skins.HUMAN_FEMALE_NORMAL.getName());
            }
        }
    }

    protected void updatePlayerModifications(EntityPlayerSP player) {
        List<String> modificationsList = this.getModificationValues();
        IPlayerModifications modifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (modifications != null);
        modifications.setSkinModifications(new ArrayList<String>());
        if (this.isCyborg(player)) {
            modifications.setSkinModifications((ArrayList)modificationsList);
        } else {
            modifications.setModifications((ArrayList)modificationsList);
        }
        if (this.isFishman(player)) {
            modifications.setSkinModifications(new ArrayList<String>(Collections.singletonList(SkinModifications.FISHMAN_GILLS.getName())));
        }
        if (modifications.getSkinColor() == 0) {
            modifications.setSkinColor(Color.WHITE.getRGB());
        }
        this.updateColors(player, modifications);
        this.updateSkin(modifications, ((IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null)).getRace() == MinePieceRaces.MINKS);
        ModPackets.NETWORK.sendToServer((IMessage)new ModificationSyncPacket(modifications.getModifications(), modifications.getSkinModifications(), modifications.getPose(), modifications.getSkin(), modifications.getSkinColor(), modifications.getModificationColor()));
    }

    private void updateColors(EntityPlayerSP playerSP, IPlayerModifications modifications) {
        boolean skinLinked;
        ColorSelectorGui.SkinLimitations skinLimitations = ColorSelectorGui.getSkinLimitation((EntityPlayer)playerSP);
        ColorSelectorGui.ModificationLimitations modificationLimitations = ColorSelectorGui.getModificationLimitation((EntityPlayer)playerSP);
        int currentSkinColor = modifications.getSkinColor();
        int currentModificationColor = modifications.getModificationColor();
        int currentSkinHue = this.getHue(currentSkinColor);
        int currentSkinSaturation = this.getSaturation(currentSkinColor);
        int currentSkinBrightness = this.getBrightness(currentSkinColor);
        int currentModificationHue = this.getHue(currentModificationColor);
        int currentModificationSaturation = this.getSaturation(currentModificationColor);
        int currentModificationBrightness = this.getBrightness(currentModificationColor);
        boolean bl = skinLinked = skinLimitations != null && skinLimitations.getMinHue() == -1;
        if (!skinLinked) {
            if (currentSkinHue < skinLimitations.getMinHue()) {
                currentSkinHue = skinLimitations.getMinHue();
            } else if (currentSkinHue > skinLimitations.getMaxHue()) {
                currentSkinHue = skinLimitations.getMaxHue();
            }
            if (currentSkinSaturation < skinLimitations.getMinSat()) {
                currentSkinSaturation = skinLimitations.getMinSat();
            } else if (currentSkinSaturation > skinLimitations.getMaxSat()) {
                currentSkinSaturation = skinLimitations.getMaxSat();
            }
            if (currentSkinBrightness < skinLimitations.getMinBright()) {
                currentSkinBrightness = skinLimitations.getMinBright();
            } else if (currentSkinBrightness > skinLimitations.getMaxBright()) {
                currentSkinBrightness = skinLimitations.getMaxBright();
            }
        }
        if (modificationLimitations != null) {
            if (currentModificationHue < modificationLimitations.getMinHue()) {
                currentModificationHue = modificationLimitations.getMinHue();
            } else if (currentModificationHue > modificationLimitations.getMaxHue()) {
                currentModificationHue = modificationLimitations.getMaxHue();
            }
            if (currentModificationSaturation < modificationLimitations.getMinSat()) {
                currentModificationSaturation = modificationLimitations.getMinSat();
            } else if (currentModificationSaturation > modificationLimitations.getMaxSat()) {
                currentModificationSaturation = modificationLimitations.getMaxSat();
            }
            if (currentModificationBrightness < modificationLimitations.getMinBright()) {
                currentModificationBrightness = modificationLimitations.getMinBright();
            } else if (currentModificationBrightness > modificationLimitations.getMaxBright()) {
                currentModificationBrightness = modificationLimitations.getMaxBright();
            }
        }
        if (skinLinked) {
            currentSkinHue = currentModificationHue;
            currentSkinSaturation = currentModificationSaturation;
            currentSkinBrightness = currentModificationBrightness;
        }
        int newSkinColor = this.hsvToInt(currentSkinHue, currentSkinSaturation, currentSkinBrightness);
        int newModificationColor = this.hsvToInt(currentModificationHue, currentModificationSaturation, currentModificationBrightness);
        modifications.setSkinColor(newSkinColor);
        modifications.setModificationColor(newModificationColor);
    }

    private int getHue(int color) {
        float[] hsv = new float[3];
        Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsv);
        return Math.round(hsv[0] * 355.0f);
    }

    private int getSaturation(int color) {
        float[] hsv = new float[3];
        Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsv);
        return Math.round(hsv[1] * 100.0f);
    }

    private int getBrightness(int color) {
        float[] hsv = new float[3];
        Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, hsv);
        return Math.round(hsv[2] * 100.0f);
    }

    private int hsvToInt(int hue, int saturation, int brightness) {
        float scaledHue = (float)hue / 355.0f;
        float scaledSaturation = (float)saturation / 100.0f;
        float scaledBrightness = (float)brightness / 100.0f;
        int rgb = Color.HSBtoRGB(scaledHue, scaledSaturation, scaledBrightness);
        return rgb & 0xFFFFFF;
    }

    private boolean isFishman(EntityPlayerSP playerSP) {
        return !Collections.disjoint(CapabilityHelper.getPlayerModifications((EntityPlayer)playerSP).getModifications(), Arrays.asList("fishman_nose", "cow_fish", "fighter_fishman", "right_ray_fin", "left_ray_fin", "sea_bream"));
    }

    private boolean isCyborg(EntityPlayerSP playerSP) {
        return CapabilityHelper.getPlayerData((EntityPlayer)playerSP).getRace() == MinePieceRaces.CYBORG;
    }

    private List<String> getModificationValues() {
        ArrayList<String> modificationValues = new ArrayList<String>();
        List<HashMap<String, List<String>>> modificationsList = this.getModificationList();
        block0: for (String key : this.modifications) {
            for (HashMap<String, List<String>> modificationMap : modificationsList) {
                if (!modificationMap.containsKey(key)) continue;
                modificationValues.addAll((Collection<String>)modificationMap.get(key));
                continue block0;
            }
        }
        return modificationValues;
    }

    private void resetModifications(EntityPlayerSP player) {
        IPlayerModifications modifications = (IPlayerModifications)player.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
        assert (modifications != null);
        modifications.setModifications(new ArrayList<String>());
        modifications.setSkinModifications(new ArrayList<String>());
    }

    protected abstract List<HashMap<String, List<String>>> getModificationList();

    protected abstract void nextGUI();
}

