/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.misc;

import fr.minepiece.client.gui.component.button.GuiAPI;
import fr.minepiece.client.gui.component.button.GuiTexturedButton;
import fr.minepiece.client.gui.component.button.GuiUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;

public class OverheatGui
extends GuiAPI {
    private static final ResourceLocation background = new ResourceLocation("minepiece", "textures/gui/misc/overheat/red_overlay.png");
    private static final ResourceLocation drop1 = new ResourceLocation("minepiece", "textures/gui/misc/overheat/drop1.png");
    private static final ResourceLocation drop2 = new ResourceLocation("minepiece", "textures/gui/misc/overheat/drop2.png");
    private static final ResourceLocation drop3 = new ResourceLocation("minepiece", "textures/gui/misc/overheat/drop3.png");
    private static final ResourceLocation warning = new ResourceLocation("minepiece", "textures/gui/misc/overheat/warning.png");
    private GuiTexturedButton warningSign;
    private final HashMap<GuiTexturedButton, Long> dropList = new HashMap();
    protected long openTime = System.currentTimeMillis();
    private long lastFlash = 0L;
    private long lastDrop = 0L;
    private final int duration = 5000;

    public OverheatGui() {
        super(null, "overheat");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.warningSign = new GuiTexturedButton(this.width(0.0f), this.height(0.0f), this.width(100.0f), this.height(100.0f));
        this.warningSign.setTexture(warning);
        this.addComponent(this.warningSign);
    }

    public void func_73876_c() {
        if (this.checkTime(5000)) {
            Minecraft.func_71410_x().func_147108_a(null);
        }
        if (this.lastFlash + 500L < System.currentTimeMillis()) {
            if (this.getComponents().contains(this.warningSign)) {
                this.getComponents().remove(this.warningSign);
            } else {
                this.getComponents().add(this.warningSign);
            }
            this.lastFlash = System.currentTimeMillis();
        }
        if (this.lastDrop + 250L < System.currentTimeMillis()) {
            this.addDrop();
        }
        Iterator<GuiTexturedButton> iterator = this.dropList.keySet().iterator();
        while (iterator.hasNext()) {
            GuiTexturedButton drop = iterator.next();
            drop.setY(drop.getY() + 1.0);
            if (System.currentTimeMillis() - this.dropList.get(drop) <= 750L) continue;
            this.getComponents().remove(drop);
            iterator.remove();
        }
        super.func_73876_c();
    }

    private boolean checkTime(int time) {
        return System.currentTimeMillis() - this.openTime > (long)time;
    }

    private void addDrop() {
        String dropTexture = this.getRandomDrop();
        ResourceLocation dropResource = null;
        float xWidth = 0.0f;
        float yHeight = 0.0f;
        if (dropTexture == "drop1") {
            dropResource = drop1;
            xWidth = 2.61f;
            yHeight = 6.76f;
        } else if (dropTexture == "drop2") {
            dropResource = drop2;
            xWidth = 3.7f;
            yHeight = 8.55f;
        } else if (dropTexture == "drop3") {
            dropResource = drop3;
            xWidth = 4.21f;
            yHeight = 10.83f;
        }
        float xStart = (float)new Random().nextInt(81) + 10.0f;
        float yStart = (float)new Random().nextInt(51) + 30.0f;
        GuiTexturedButton drop = new GuiTexturedButton(this.width(xStart), this.height(yStart), this.width(xWidth), this.height(yHeight));
        drop.setTexture(dropResource);
        this.dropList.put(drop, System.currentTimeMillis());
        this.getComponents().add(drop);
        this.lastDrop = System.currentTimeMillis();
    }

    private String getRandomDrop() {
        Random rand = new Random();
        int randomNum = rand.nextInt(3);
        switch (randomNum) {
            case 0: {
                return "drop1";
            }
            case 1: {
                return "drop2";
            }
            case 2: {
                return "drop3";
            }
        }
        return "drop1";
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float ticks) {
        double ratio = (double)(System.currentTimeMillis() - this.openTime) / 5000.0;
        float alpha = (float)Math.min(ratio + 0.25, 1.0);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        GuiUtils.drawImageTransparent(this.width(0.0f), this.height(0.0f), background, this.width(100.0f), this.height(100.0f));
    }
}

