/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.hud.components;

import fr.minepiece.client.config.ClientConfig;
import fr.minepiece.client.gui.hud.IHudComponent;
import fr.minepiece.client.utils.RenderUtils;
import fr.minepiece.common.api.abilities.AbilitiesEnum;
import fr.minepiece.common.capability.mpcooldowns.IMinePieceCooldown;
import fr.minepiece.common.capability.mpcooldowns.MinePieceCooldownStorage;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpdata.MinePieceDataStorage;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.mpstats.MinePieceStatsStorage;
import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.TemperatureProvider;
import fr.minepiece.common.capability.temperature.TemperatureState;
import fr.minepiece.common.capability.thirst.IThirst;
import fr.minepiece.common.capability.thirst.ThirstProvider;
import fr.minepiece.common.init.ModKeybindings;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.GuiIngameForge;

public class StatsBarHud
implements IHudComponent {
    private static ResourceLocation HEART_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/heart_empty.png");
    private static ResourceLocation HEART_FULL = new ResourceLocation("minepiece", "textures/hud/barres/heart_full.png");
    private static ResourceLocation HEART_POISON_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/heart_poison_empty.png");
    private static ResourceLocation HEART_POISON_FULL = new ResourceLocation("minepiece", "textures/hud/barres/heart_poison_full.png");
    private static ResourceLocation HEART_WITHER_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/heart_wither_empty.png");
    private static ResourceLocation HEART_WITHER_FULL = new ResourceLocation("minepiece", "textures/hud/barres/heart_wither_full.png");
    private static ResourceLocation ABSO_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/heart_abso_empty.png");
    private static ResourceLocation ABSO_FULL = new ResourceLocation("minepiece", "textures/hud/barres/heart_abso_full.png");
    private static ResourceLocation ARMOR_EMTPY = new ResourceLocation("minepiece", "textures/hud/barres/armor_empty.png");
    private static ResourceLocation ARMOR_FULL = new ResourceLocation("minepiece", "textures/hud/barres/armor_full.png");
    private static ResourceLocation FOOD_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/food_empty.png");
    private static ResourceLocation FOOD_FULL = new ResourceLocation("minepiece", "textures/hud/barres/food_full.png");
    private static ResourceLocation FOOD_EMPTY_HUNGER = new ResourceLocation("minepiece", "textures/hud/barres/food_empty_hunger.png");
    private static ResourceLocation FOOD_FULL_HUNGER = new ResourceLocation("minepiece", "textures/hud/barres/food_full_hunger.png");
    private static ResourceLocation WATER_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/water_empty.png");
    private static ResourceLocation WATER_FULL = new ResourceLocation("minepiece", "textures/hud/barres/water_full.png");
    private static ResourceLocation ENERGY_EMPTY = new ResourceLocation("minepiece", "textures/hud/barres/enerrgy_empty.png");
    private static ResourceLocation ENERGY_FULL = new ResourceLocation("minepiece", "textures/hud/barres/enerrgy_full.png");
    private static ResourceLocation GOUVERNAIL = new ResourceLocation("minepiece", "textures/hud/gouvernail.png");
    private static ResourceLocation SKULL_NORMAL = new ResourceLocation("minepiece", "textures/hud/skull_normal.png");
    private static ResourceLocation SKULL_COLD_1 = new ResourceLocation("minepiece", "textures/hud/skull_hypo_1.png");
    private static ResourceLocation SKULL_COLD_2 = new ResourceLocation("minepiece", "textures/hud/skull_hypo_2.png");
    private static ResourceLocation SKULL_COLD_3 = new ResourceLocation("minepiece", "textures/hud/skull_hypo_3.png");
    private static ResourceLocation SKULL_COLD_4 = new ResourceLocation("minepiece", "textures/hud/skull_hypo_4.png");
    private static ResourceLocation SKULL_HOT_1 = new ResourceLocation("minepiece", "textures/hud/skull_hyper_1.png");
    private static ResourceLocation SKULL_HOT_2 = new ResourceLocation("minepiece", "textures/hud/skull_hyper_2.png");
    private static ResourceLocation SKULL_HOT_3 = new ResourceLocation("minepiece", "textures/hud/skull_hyper_3.png");
    private static ResourceLocation SKULL_HOT_4 = new ResourceLocation("minepiece", "textures/hud/skull_hyper_4.png");
    private static ResourceLocation VERTICAL_HOTBAR = new ResourceLocation("minepiece", "textures/hud/vertical_hotbar.png");
    private static ResourceLocation ABILITY_BLUE = new ResourceLocation("minepiece", "textures/hud/competence_bleu.png");
    private static ResourceLocation ABILITY_RED = new ResourceLocation("minepiece", "textures/hud/competence_rouge.png");
    private static ResourceLocation ABILITY_GREEN = new ResourceLocation("minepiece", "textures/hud/competence_vert.png");
    private final Minecraft mc = Minecraft.func_71410_x();
    public static final ResourceLocation ICONS = new ResourceLocation("textures/gui/icons.png");
    private static boolean isCombat = false;
    private double playerHealth;
    private double playerAbsorption;
    private double lastPlayerHealth;
    private double lastPlayerAbsorption;
    private long healthUpdateCounter;
    private long absorptionUpdateCounter;
    private boolean isRegen = false;

    @Override
    public void render(Minecraft mc, ScaledResolution res, EntityPlayer player) {
        int width = res.func_78326_a();
        int height = res.func_78328_b();
        int xStart = width / 2 - 91;
        int yStart = height - GuiIngameForge.left_height;
        mc.field_71424_I.func_76320_a("health");
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        this.renderHealthBar(player, xStart, yStart, res);
        mc.field_71424_I.func_76318_c("armor");
        mc.field_71424_I.func_76318_c("health");
        if (player.func_110139_bj() > 0.0f) {
            // empty if block
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        mc.field_71424_I.func_76319_b();
    }

    private void renderHealthBar(EntityPlayer player, int xStart, int yStart, ScaledResolution res) {
        ResourceLocation foregroundFood;
        ResourceLocation backgroundFood;
        ResourceLocation foregroundHealth;
        ResourceLocation backgroundHealth;
        boolean highlight;
        double value;
        long updateCounter = this.mc.field_71456_v.func_73834_c();
        if ((double)player.func_110143_aJ() < this.playerHealth && player.field_70172_ad > 0) {
            this.healthUpdateCounter = updateCounter + 20L;
            this.lastPlayerHealth = this.playerHealth;
        } else if ((double)player.func_110143_aJ() > this.playerHealth && player.field_70172_ad > 0) {
            this.healthUpdateCounter = updateCounter + 20L;
            this.lastPlayerHealth = this.playerHealth;
        }
        this.playerHealth = player.func_110143_aJ();
        if (this.lastPlayerHealth > (double)player.func_110143_aJ()) {
            this.isRegen = false;
        } else if (this.lastPlayerHealth != 0.0 && this.lastPlayerHealth < (double)player.func_110143_aJ()) {
            this.isRegen = true;
        }
        double displayValue = value = (double)player.func_110143_aJ();
        boolean bl = highlight = this.healthUpdateCounter > updateCounter && (this.healthUpdateCounter - updateCounter) / 3L % 2L == 1L;
        if (this.lastPlayerHealth > value) {
            displayValue = value + (this.lastPlayerHealth - value) * ((double)player.field_70172_ad / (double)player.field_70771_an);
        } else if (this.lastPlayerHealth != 0.0 && this.lastPlayerHealth < value) {
            displayValue = value - this.lastPlayerHealth;
        }
        displayValue = value = (double)player.func_110139_bj();
        boolean bl2 = highlight = this.absorptionUpdateCounter > updateCounter && (this.absorptionUpdateCounter - updateCounter) / 3L % 2L == 1L;
        if (!this.isRegen) {
            this.lastPlayerHealth = this.playerHealth;
        }
        if (value < this.playerAbsorption && player.field_70172_ad > 0) {
            this.absorptionUpdateCounter = updateCounter + 20L;
            this.lastPlayerAbsorption = this.playerAbsorption;
        } else if (value > this.playerAbsorption && player.field_70172_ad > 0) {
            this.absorptionUpdateCounter = updateCounter + 20L;
            this.lastPlayerAbsorption = this.playerAbsorption;
        }
        this.playerAbsorption = value;
        if (this.lastPlayerAbsorption > value) {
            displayValue = value + (this.lastPlayerAbsorption - value) * ((double)player.field_70172_ad / (double)player.field_70771_an);
        } else if (this.lastPlayerAbsorption != 0.0 && this.lastPlayerAbsorption < value) {
            displayValue = value - this.lastPlayerAbsorption;
        }
        if (player.func_70644_a(MobEffects.field_76436_u)) {
            backgroundHealth = HEART_POISON_EMPTY;
            foregroundHealth = HEART_POISON_FULL;
        } else if (player.func_70644_a(MobEffects.field_82731_v)) {
            backgroundHealth = HEART_WITHER_EMPTY;
            foregroundHealth = HEART_WITHER_FULL;
        } else {
            backgroundHealth = HEART_EMPTY;
            foregroundHealth = HEART_FULL;
        }
        if (player.func_70644_a(MobEffects.field_76438_s)) {
            backgroundFood = FOOD_EMPTY_HUNGER;
            foregroundFood = FOOD_FULL_HUNGER;
        } else {
            backgroundFood = FOOD_EMPTY;
            foregroundFood = FOOD_FULL;
        }
        highlight = this.healthUpdateCounter > updateCounter && (this.healthUpdateCounter - updateCounter) / 3L % 2L == 1L;
        boolean isCreative = Minecraft.func_71410_x().field_71439_g.func_184812_l_();
        int ymod = -5;
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        this.renderGouvernail(player, res.func_78326_a() / 2 - 27, res.func_78328_b() - 49, GOUVERNAIL);
        if (!isCreative) {
            this.renderTemperature(player, res.func_78326_a() / 2 - 8, res.func_78328_b() - 23 - 16, StatsBarHud.getSkullTexture(((ITemperature)player.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null)).getCurrentState()));
        }
        if (!isCreative) {
            this.renderHealthBar(player, xStart, yStart, backgroundHealth, ymod, foregroundHealth, highlight);
        }
        if (!isCreative) {
            this.renderFoodBar(player, xStart + 91 + 17, yStart, backgroundFood, ymod, foregroundFood);
        }
        ymod += 10;
        if (!isCreative) {
            this.renderArmorBar(player, xStart, yStart, ARMOR_EMTPY, ymod, ARMOR_FULL);
        }
        if (!isCreative) {
            this.renderThirstBar(player, xStart + 91 + 17, yStart, WATER_EMPTY, ymod, WATER_FULL);
        }
        this.mc.func_110434_K().func_110577_a(ICONS);
        this.renderAir(player, xStart + 91 + 91, yStart, ymod += 10);
        this.renderEnergy(player, 10, res.func_78328_b() - 90, ENERGY_EMPTY, ENERGY_FULL);
        this.renderAbilityHotbar(player, 10, 30);
    }

    private void renderAbilityHotbar(EntityPlayer player, int xStart, int yStart) {
        IMinePieceData data = (IMinePieceData)player.getCapability(MinePieceDataStorage.MP_DATA_CAPABILITY, null);
        IMinePieceCooldown cooldowns = (IMinePieceCooldown)player.getCapability(MinePieceCooldownStorage.MP_COOLDOWN_CAPABILITY, null);
        assert (data != null);
        assert (cooldowns != null);
        ArrayList<String> abilities = ClientConfig.getSkills();
        if (!isCombat) {
            int i;
            this.mc.func_110434_K().func_110577_a(ABILITY_BLUE);
            for (i = 0; i < 5; ++i) {
                int y = yStart + i * 20;
                Gui.func_146110_a((int)xStart, (int)y, (float)0.0f, (float)0.0f, (int)22, (int)22, (float)22.0f, (float)22.0f);
            }
            for (i = 0; i < abilities.size() && !ClientConfig.getSkills().get(i).isEmpty(); ++i) {
                String ability = abilities.get(i);
                int y = yStart + 3 + i * 20;
                ResourceLocation img = AbilitiesEnum.getAbilityFromName(ability).getIcon();
                this.mc.func_110434_K().func_110577_a(img);
                Gui.func_146110_a((int)(xStart + 3), (int)y, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        } else {
            for (int i = 0; i < 5; ++i) {
                int y = yStart + i * 20;
                if (ClientConfig.getSkills().get(i).isEmpty()) {
                    this.mc.func_110434_K().func_110577_a(ABILITY_RED);
                    Gui.func_146110_a((int)xStart, (int)y, (float)0.0f, (float)0.0f, (int)22, (int)22, (float)22.0f, (float)22.0f);
                    continue;
                }
                String ability = abilities.get(i);
                long cooldown = cooldowns.getCooldown(ability);
                if (cooldown > System.currentTimeMillis()) {
                    this.mc.func_110434_K().func_110577_a(ABILITY_RED);
                } else {
                    this.mc.func_110434_K().func_110577_a(ABILITY_GREEN);
                }
                Gui.func_146110_a((int)xStart, (int)y, (float)0.0f, (float)0.0f, (int)22, (int)22, (float)22.0f, (float)22.0f);
                ResourceLocation img = AbilitiesEnum.getAbilityFromName(ability).getIcon();
                this.mc.func_110434_K().func_110577_a(img);
                Gui.func_146110_a((int)(xStart + 3), (int)(y + 3), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
                GlStateManager.func_179123_a();
                if (cooldown > System.currentTimeMillis()) {
                    double ticksLeft = cooldown - System.currentTimeMillis();
                    double maxTicks = AbilitiesEnum.getAbilityFromName(ability).getAbility().getCooldownInMilliseconds();
                    double progress = ticksLeft / maxTicks;
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179097_i();
                    GlStateManager.func_179090_x();
                    Tessellator tessellator1 = Tessellator.func_178181_a();
                    BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                    this.draw(bufferbuilder1, xStart + 3, y + 3 + MathHelper.func_76128_c((double)(16.0 * (1.0 - progress))), 16, MathHelper.func_76143_f((double)(16.0 * progress)), 255, 255, 255, 127);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179126_j();
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                GlStateManager.func_179099_b();
            }
        }
    }

    private void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)(x + 0), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + 0), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + 0), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    private void renderTemperature(EntityPlayer player, int xStart, int yStart, ResourceLocation resource) {
        this.mc.func_110434_K().func_110577_a(resource);
        Gui.func_146110_a((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
    }

    private void renderGouvernail(EntityPlayer player, int xStart, int yStart, ResourceLocation resource) {
        this.mc.func_110434_K().func_110577_a(resource);
        Gui.func_146110_a((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)54, (int)27, (float)54.0f, (float)27.0f);
    }

    private void renderEnergy(EntityPlayer player, int xStart, int yStart, ResourceLocation background, ResourceLocation foreground) {
        this.mc.func_110434_K().func_110577_a(background);
        Gui.func_146110_a((int)xStart, (int)yStart, (float)0.0f, (float)0.0f, (int)8, (int)74, (float)8.0f, (float)74.0f);
        this.mc.func_110434_K().func_110577_a(foreground);
        IMinePieceStats data = (IMinePieceStats)player.getCapability(MinePieceStatsStorage.MP_STATS_CAPABILITY, null);
        double energy = data.getEnergy();
        double maxEnergy = data.getActualMaxEnergy();
        double ratio = energy / maxEnergy;
        int energyHeight = (int)(ratio * 74.0);
        Gui.func_146110_a((int)xStart, (int)(yStart + 74 - energyHeight), (float)0.0f, (float)(74 - energyHeight), (int)8, (int)energyHeight, (float)8.0f, (float)74.0f);
        if (player.func_70093_af()) {
            this.mc.field_71466_p.func_175063_a(String.format("%d / " + data.getActualMaxEnergy(), data.getEnergy()), (float)(xStart + 10), (float)(yStart + 74 - energyHeight), Color.YELLOW.getRGB());
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderAir(EntityPlayer player, int xStart, int yStart, int ymod) {
        if (player.func_70055_a(Material.field_151586_h)) {
            int air = player.func_70086_ai();
            int full = MathHelper.func_76143_f((double)((double)(air - 2) * 10.0 / 300.0));
            int partial = MathHelper.func_76143_f((double)((double)air * 10.0 / 300.0)) - full;
            for (int i = 0; i < full + partial; ++i) {
                this.drawTexturedModalRect(xStart - i * 8 - 9, yStart - ymod, i < full ? 16 : 25, 18, 9, 9);
            }
        }
    }

    private void renderThirstBar(EntityPlayer player, int xStart, int yStart, ResourceLocation background, int ymod, ResourceLocation foreground) {
        this.mc.func_110434_K().func_110577_a(background);
        Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)74, (int)8, (float)74.0f, (float)8.0f);
        this.mc.func_110434_K().func_110577_a(foreground);
        IThirst data = (IThirst)player.getCapability(ThirstProvider.THIRST_CAPABILITY, null);
        double thirst = data.getThirstLevel();
        double maxThirst = 20.0;
        double ratio = thirst / maxThirst;
        Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratio * 74.0)), (int)8, (float)74.0f, (float)8.0f);
        if (player.func_70093_af()) {
            this.mc.field_71466_p.func_175063_a(String.format("%d / 20", (int)thirst), (float)(xStart + 10), (float)(yStart - ymod), Color.WHITE.getRGB());
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderFoodBar(EntityPlayer player, int xStart, int yStart, ResourceLocation background, int ymod, ResourceLocation foreground) {
        this.mc.func_110434_K().func_110577_a(background);
        Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)74, (int)8, (float)74.0f, (float)8.0f);
        this.mc.func_110434_K().func_110577_a(foreground);
        double food = player.func_71024_bL().func_75116_a();
        double maxFood = 20.0;
        double ratio = food / maxFood;
        Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratio * 74.0)), (int)8, (float)74.0f, (float)8.0f);
        if (player.func_70093_af()) {
            this.mc.field_71466_p.func_175063_a(String.format("%d / " + (int)maxFood, (int)food), (float)(xStart + 10), (float)(yStart - ymod), Color.WHITE.getRGB());
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderArmorBar(EntityPlayer player, int xStart, int yStart, ResourceLocation background, int ymod, ResourceLocation foreground) {
        if (player.func_70658_aO() > 0) {
            this.mc.func_110434_K().func_110577_a(background);
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)74, (int)8, (float)74.0f, (float)8.0f);
            this.mc.func_110434_K().func_110577_a(foreground);
            double armor = player.func_70658_aO();
            double maxArmor = 20.0;
            double ratio = armor / maxArmor;
            ratio = MathHelper.func_151237_a((double)ratio, (double)0.0, (double)1.0);
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratio * 74.0)), (int)8, (float)74.0f, (float)8.0f);
            if (player.func_70093_af()) {
                this.mc.field_71466_p.func_175063_a(String.format("%d / 20", (int)armor), (float)(xStart + 10), (float)(yStart - ymod), Color.WHITE.getRGB());
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void renderHealthBar(EntityPlayer player, int xStart, int yStart, ResourceLocation background, int ymod, ResourceLocation foreground, boolean highlight) {
        this.mc.func_110434_K().func_110577_a(background);
        Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)74, (int)8, (float)74.0f, (float)8.0f);
        if (this.playerAbsorption > 0.0 && this.playerAbsorption % 20.0 / 20.0 > this.playerHealth / (double)player.func_110138_aP()) {
            this.mc.func_110434_K().func_110577_a(ABSO_FULL);
            double absorption = this.playerAbsorption;
            double maxAbsorption = 20.0;
            double ratioAbsorption = absorption / maxAbsorption;
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratioAbsorption * 74.0)), (int)8, (float)74.0f, (float)8.0f);
            this.mc.func_110434_K().func_110577_a(foreground);
            double health = this.playerHealth;
            double maxHealth = player.func_110138_aP();
            double ratio = health / maxHealth;
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratio * 74.0)), (int)8, (float)74.0f, (float)8.0f);
        } else if (this.playerAbsorption > 0.0 && this.playerAbsorption % 20.0 / 20.0 < this.playerHealth / (double)player.func_110138_aP()) {
            this.mc.func_110434_K().func_110577_a(background);
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)74, (int)8, (float)74.0f, (float)8.0f);
            this.mc.func_110434_K().func_110577_a(foreground);
            double health = this.playerHealth;
            double maxHealth = player.func_110138_aP();
            double ratio = health / maxHealth;
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratio * 74.0)), (int)8, (float)74.0f, (float)8.0f);
            this.mc.func_110434_K().func_110577_a(ABSO_FULL);
            double absorption = this.playerAbsorption % 20.0;
            double maxAbsorption = 20.0;
            double ratioAbsorption = absorption / maxAbsorption;
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)((int)(ratioAbsorption * 74.0)), (int)8, (float)74.0f, (float)8.0f);
        } else {
            this.mc.func_110434_K().func_110577_a(background);
            Gui.func_146110_a((int)xStart, (int)(yStart - ymod), (float)0.0f, (float)0.0f, (int)74, (int)8, (float)74.0f, (float)8.0f);
            this.mc.func_110434_K().func_110577_a(foreground);
            if (highlight) {
                GlStateManager.func_179090_x();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            double health = this.playerHealth;
            double maxHealth = player.func_110138_aP();
            double ratio = health / maxHealth;
            Gui.func_146110_a((int)(xStart + 2), (int)(yStart - ymod + 2), (float)2.0f, (float)2.0f, (int)((int)(ratio * 74.0)), (int)4, (float)74.0f, (float)8.0f);
            if (highlight) {
                GlStateManager.func_179098_w();
            }
        }
        if (player.func_70093_af()) {
            this.mc.field_71466_p.func_175063_a(String.format("%d / " + (int)player.func_110138_aP(), (int)this.playerHealth), (float)(xStart + 10), (float)(yStart - ymod), Color.WHITE.getRGB());
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private int colorBarGl(EntityPlayer pl, boolean isWhiteHeart, boolean isBlinkable, boolean isHeart) {
        return isHeart ? this.healthToColorGl(pl, isWhiteHeart, isBlinkable) : this.absorptionToColorGl(pl, isWhiteHeart);
    }

    private int healthToColorGl(EntityPlayer pl, boolean isWhiteHeart, boolean isBlinkable) {
        float alpha;
        int p1;
        int n = pl.func_70644_a(MobEffects.field_76436_u) ? 52 : (p1 = pl.func_70644_a(MobEffects.field_82731_v) ? 88 : 16);
        float f = pl.func_110143_aJ() <= 0.0f ? 1.0f : (alpha = (double)(pl.func_110143_aJ() / pl.func_110138_aP()) <= 0.2 ? (float)((int)(Minecraft.func_71386_F() / 250L) % 2) : 1.0f);
        if (isBlinkable) {
            RenderUtils.color2Gl(RenderUtils.getColor(pl.func_110138_aP(), p1), alpha);
        }
        if (!isWhiteHeart) {
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        return RenderUtils.colorToText(RenderUtils.getColor(RenderUtils.roundTo(pl.func_110138_aP(), 2), p1));
    }

    private int absorptionToColorGl(EntityPlayer pl, boolean isWhiteHeart) {
        if (pl.func_70644_a(MobEffects.field_76436_u)) {
            RenderUtils.color2Gl(RenderUtils.hex2Color("#c5d117"));
            return RenderUtils.colorToText(RenderUtils.hex2Color("#c5d117"));
        }
        if (pl.func_70644_a(MobEffects.field_82731_v)) {
            RenderUtils.color2Gl(RenderUtils.hex2Color("#70590d"));
            return RenderUtils.colorToText(RenderUtils.hex2Color("#70590d"));
        }
        if (isWhiteHeart) {
            RenderUtils.color2Gl(RenderUtils.hex2Color("#d4af37"));
            return RenderUtils.colorToText(RenderUtils.hex2Color("#d4af37"));
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        return RenderUtils.colorToText(RenderUtils.hex2Color("#ffffff"));
    }

    public void drawTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height) {
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + height), 10.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 10.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + height) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + 0), 10.0).func_187315_a((double)((float)(textureX + width) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + 0), (double)(y + 0), 10.0).func_187315_a((double)((float)(textureX + 0) * 0.00390625f), (double)((float)(textureY + 0) * 0.00390625f)).func_181675_d();
        tessellator.func_78381_a();
    }

    private static ResourceLocation getSkullTexture(TemperatureState state) {
        switch (state) {
            case HYPOTHERMIA_DEATH: {
                return SKULL_COLD_4;
            }
            case HYPOTHERMIA_SEVERE: {
                return SKULL_COLD_3;
            }
            case HYPOTHERMIA_MODERATE: {
                return SKULL_COLD_2;
            }
            case HYPOTHERMIA_MILD: {
                return SKULL_COLD_1;
            }
            case NORMAL: {
                return SKULL_NORMAL;
            }
            case HYPERTHERMIA_MILD: {
                return SKULL_HOT_1;
            }
            case HYPERTHERMIA_MODERATE: {
                return SKULL_HOT_2;
            }
            case HYPERTHERMIA_SEVERE: {
                return SKULL_HOT_3;
            }
            case HYPERTHERMIA_DEATH: {
                return SKULL_HOT_4;
            }
        }
        return SKULL_NORMAL;
    }

    public static void setCombat(boolean isCombat) {
        StatsBarHud.isCombat = isCombat;
        if (isCombat) {
            for (KeyBinding kb : Minecraft.func_71410_x().field_71474_y.field_151456_ac) {
                kb.func_151462_b(0);
            }
            int keyId = 2;
            for (KeyBinding kb : ModKeybindings.keyBindsCombatbar) {
                if (kb.func_151463_i() < 9) {
                    kb.func_151462_b(keyId);
                }
                ++keyId;
            }
            KeyBinding.func_74508_b();
        } else {
            for (KeyBinding kb : ModKeybindings.keyBindsCombatbar) {
                if (kb.func_151463_i() >= 9) continue;
                kb.func_151462_b(0);
            }
            int keyId = 2;
            for (KeyBinding kb : Minecraft.func_71410_x().field_71474_y.field_151456_ac) {
                kb.func_151462_b(keyId);
                ++keyId;
            }
            KeyBinding.func_74508_b();
        }
    }

    public static boolean isCombat() {
        return isCombat;
    }
}

