/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.hud;

import fr.minepiece.client.gui.hud.IHudComponent;
import fr.minepiece.client.gui.hud.components.BarometerHud;
import fr.minepiece.client.gui.hud.components.FPSDisplayHud;
import fr.minepiece.client.gui.hud.components.StatsBarHud;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="minepiece")
public class HudHandler {
    private static final List<IHudComponent> COMPONENTS = new ArrayList<IHudComponent>();

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution resolution = new ScaledResolution(mc);
            Entity entity = mc.func_175606_aa();
            if (!(entity instanceof EntityPlayer)) {
                return;
            }
            HudHandler.renderHud(mc, resolution, (EntityPlayer)entity);
        }
    }

    public static void registerComponents() {
        HudHandler.registerComponent(new FPSDisplayHud());
        HudHandler.registerComponent(new BarometerHud());
        HudHandler.registerComponent(new StatsBarHud());
    }

    public static void registerComponent(IHudComponent component) {
        COMPONENTS.add(component);
    }

    public static void renderHud(Minecraft mc, ScaledResolution resolution, EntityPlayer player) {
        for (IHudComponent component : COMPONENTS) {
            component.render(mc, resolution, player);
        }
    }
}

