/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.textarea;

import fr.minepiece.client.gui.component.HoverObject;
import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.TextOverflow;
import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.fontv3.IFont;
import java.awt.Color;
import java.util.Arrays;
import net.minecraft.client.Minecraft;

public class GuiTextLabel
extends GuiComponent {
    public String text;
    public IFont font;
    public int fontSize;
    public Color textColor;
    public TextAlign textAlign;
    public TextOverflow textOverflow;
    public boolean textShadow;
    public Color textShadowColor;

    public GuiTextLabel(double x, double y, String text, IFont font, int fontSize, Color color) {
        super(x, y, GuiUtils.getStringWidth(Minecraft.func_71410_x(), text + " ", font, fontSize), GuiUtils.getFontHeight(Minecraft.func_71410_x(), font, fontSize));
        this.text = text;
        this.font = font;
        this.fontSize = fontSize;
        this.textAlign = TextAlign.LEFT;
        this.textColor = color;
        this.textOverflow = TextOverflow.NONE;
        this.textShadowColor = Color.BLACK;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        super.draw(mc, mouseX, mouseY);
        int posX = 0;
        int strWidth = GuiUtils.getStringWidth(Minecraft.func_71410_x(), this.text, this.font, this.fontSize);
        if (this.width > (double)strWidth) {
            if (this.textAlign == TextAlign.CENTER) {
                posX = (int)(-(this.width / 2.0 - (double)(GuiUtils.getStringWidth(mc, this.text, this.font, this.fontSize) / 2)));
            } else if (this.textAlign == TextAlign.RIGHT) {
                posX = GuiUtils.getStringWidth(mc, this.text, this.font, this.fontSize);
            }
            GuiUtils.drawStringWithCustomFont(mc, this.text, this.x - (double)posX, this.y, this.textColor, this.font, this.fontSize);
        } else {
            String drawText = this.text;
            for (int i = 0; i < this.text.length(); ++i) {
                int w = GuiUtils.getStringWidth(Minecraft.func_71410_x(), this.text.substring(0, i), this.font, this.fontSize);
                if (!((double)w > this.width)) continue;
                drawText = this.text.substring(0, i);
                break;
            }
            String overflowString = this.textOverflow.getOverflow();
            drawText = drawText.substring(0, Math.max(0, drawText.length() - overflowString.length() - 1));
            drawText = drawText + overflowString;
            if (this.textAlign == TextAlign.CENTER) {
                posX = (int)(-(this.width / 2.0 - (double)(GuiUtils.getStringWidth(mc, drawText, this.font, this.fontSize) / 2)));
            } else if (this.textAlign == TextAlign.RIGHT) {
                posX = GuiUtils.getStringWidth(mc, drawText, this.font, this.fontSize);
            }
            GuiUtils.drawStringWithCustomFont(mc, drawText, this.x - (double)posX, this.y, this.textColor, this.font, this.fontSize);
            if (this.isHovered()) {
                GuiUtils.hovers.add(new HoverObject(mouseX, mouseY, Arrays.asList(this.text), this.font, this.getHoverColor()));
            }
        }
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void onRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void onHover(int mouseX, int mouseY) {
    }

    @Override
    public void onHoverOut(int mouseX, int mouseY) {
    }

    @Override
    public void fixedUpdate() {
    }

    @Override
    public void onKeyTyped(char c, int key) {
    }

    public GuiTextLabel setTextColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }

    public GuiTextLabel setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    public GuiTextLabel setTextOverflow(TextOverflow textOverflow) {
        this.textOverflow = textOverflow;
        return this;
    }

    public GuiTextLabel setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public GuiTextLabel setTextShadowColor(Color textShadowColor) {
        this.textShadowColor = textShadowColor;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFont(IFont font) {
        this.font = font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }
}

