/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.textarea;

import fr.minepiece.client.gui.component.NodeUpdate;
import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.textarea.TextInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;

public class GuiSimpleTextLabel
extends GuiComponent
implements NodeUpdate<GuiSimpleTextLabel> {
    private TextInfo textInfo;
    private TextAlign textAlign;
    private boolean multiLine;
    private Consumer<GuiSimpleTextLabel> update;

    public GuiSimpleTextLabel(double x, double y, double width, double height) {
        super(x, y, width, height);
        this.multiLine = false;
    }

    public GuiSimpleTextLabel(double x, double y, double width, double height, TextInfo textInfo) {
        super(x, y, width, height);
        this.textInfo = textInfo;
        this.multiLine = false;
    }

    public GuiSimpleTextLabel(double x, double y, double width, double height, TextAlign textAlign) {
        super(x, y, width, height);
        this.textAlign = textAlign;
    }

    public GuiSimpleTextLabel(double x, double y, double width, double height, TextInfo textInfo, TextAlign textAlign) {
        super(x, y, width, height);
        this.textInfo = textInfo;
        this.textAlign = textAlign;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        super.draw(mc, mouseX, mouseY);
        if (this.textInfo != null) {
            double scaledDPI = this.textInfo.getScale() * Math.sqrt((double)mc.field_71443_c / 1920.0 * ((double)mc.field_71440_d / 1080.0));
            List<String> lines = this.multiLine ? this.getWrappedLines(this.textInfo.getString(), scaledDPI) : Collections.singletonList(this.textInfo.getString());
            int lineHeight = (int)((double)mc.field_71466_p.field_78288_b * scaledDPI);
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                int yOffset = (int)(this.y + (double)(i * lineHeight));
                if (this.textAlign != null) {
                    if (this.textInfo.hasOutline()) {
                        GuiUtils.renderAlignedTextScaled(line, (int)this.x, yOffset, this.textInfo.getColor(), this.textAlign, scaledDPI);
                        continue;
                    }
                    GuiUtils.renderAlignedTextScaled(line, (int)this.x, yOffset, this.textInfo.getColor(), this.textAlign, scaledDPI);
                    continue;
                }
                if (this.textInfo.hasOutline()) {
                    GuiUtils.renderCenteredTextScaledWithShadow(line, (int)(this.x + this.width / 2.0), yOffset + lineHeight / 2, this.textInfo.getColor(), scaledDPI);
                    continue;
                }
                GuiUtils.renderCenteredTextScaled(line, (int)(this.x + this.width / 2.0), yOffset + lineHeight / 2, this.textInfo.getColor(), scaledDPI);
            }
        }
    }

    @Override
    public boolean onClick(int paramInt1, int paramInt2, int paramInt3) {
        return false;
    }

    @Override
    public void onRelease(int paramInt1, int paramInt2, int paramInt3) {
    }

    @Override
    public void onKeyTyped(char paramChar, int paramInt) {
    }

    @Override
    public void onHover(int paramInt1, int paramInt2) {
    }

    @Override
    public void onHoverOut(int paramInt1, int paramInt2) {
    }

    @Override
    public void fixedUpdate() {
    }

    private List<String> getWrappedLines(String text, double scaledDPI) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split("\\s+");
        StringBuilder lineBuilder = new StringBuilder();
        for (String word : words) {
            StringBuilder stringBuilder = new StringBuilder();
            if ((double)Minecraft.func_71410_x().field_71466_p.func_78256_a(stringBuilder.append(lineBuilder.toString()).append(word).toString()) * scaledDPI > this.width) {
                lines.add(lineBuilder.toString());
                lineBuilder = new StringBuilder(word + " ");
                continue;
            }
            lineBuilder.append(word).append(" ");
        }
        lines.add(lineBuilder.toString());
        return lines;
    }

    public TextInfo getTextInfo() {
        return this.textInfo;
    }

    public void setTextInfo(TextInfo textInfo) {
        this.textInfo = textInfo;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public void setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
    }

    public boolean isMultiLine() {
        return this.multiLine;
    }

    public void setMultiLine(boolean multiLine) {
        this.multiLine = multiLine;
    }

    public void setUpdate(Consumer<GuiSimpleTextLabel> update) {
        this.update = update;
    }

    @Override
    public Consumer<GuiSimpleTextLabel> getUpdate() {
        return this.update;
    }
}

