/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.textarea;

import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.TextOverflow;
import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.fontv3.IFont;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;

public class GuiCustomTextLabel
extends GuiComponent {
    public String text;
    public IFont font;
    public int fontSize;
    public Color textColor;
    public TextAlign textAlign;
    public TextOverflow textOverflow;
    public boolean textShadow;
    public Color textShadowColor;

    public GuiCustomTextLabel(double x, double y, double width, double height, String text, IFont font, int fontSize, Color color) {
        super(x, y, width, height);
        this.text = text;
        this.font = font;
        this.fontSize = fontSize;
        this.textAlign = TextAlign.LEFT;
        this.textColor = color;
        this.textOverflow = TextOverflow.NONE;
        this.textShadowColor = Color.BLACK;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        super.draw(mc, mouseX, mouseY);
        int posX = 0;
        int strWidth = GuiUtils.getStringWidth(Minecraft.func_71410_x(), this.text, this.font, this.fontSize);
        if ((double)strWidth <= this.width) {
            if (this.textAlign == TextAlign.CENTER) {
                posX = (int)(-(this.width / 2.0 - (double)(GuiUtils.getStringWidth(mc, this.text, this.font, this.fontSize) / 2)));
            } else if (this.textAlign == TextAlign.RIGHT) {
                posX = GuiUtils.getStringWidth(mc, this.text, this.font, this.fontSize);
            }
            GuiUtils.drawStringWithCustomFont(mc, this.text, this.x - (double)posX, this.y + 3.0, this.textColor, this.font, this.fontSize);
        } else {
            int posY = (int)this.y;
            int lineHeight = (int)this.font.getFontHeight() + 1;
            ArrayList<String> lines = GuiCustomTextLabel.wrapText(this.text, this.width, this.font, this.fontSize);
            if (lines.size() > 1) {
                int lineHeightOffset = (int)(((float)lineHeight - this.font.getFontHeight()) / 2.0f) + 2;
                posY -= lineHeightOffset;
            }
            for (String line : lines) {
                if (this.textAlign == TextAlign.CENTER) {
                    posX = (int)(-(this.width / 2.0 - (double)(GuiUtils.getStringWidth(mc, line, this.font, this.fontSize) / 2)));
                } else if (this.textAlign == TextAlign.RIGHT) {
                    posX = GuiUtils.getStringWidth(mc, line, this.font, this.fontSize);
                }
                GuiUtils.drawStringWithCustomFont(mc, line, this.x - (double)posX, posY, this.textColor, this.font, this.fontSize);
                posY += lineHeight;
            }
        }
    }

    public static ArrayList<String> wrapText(String text, double width, IFont font, float fontSize) {
        String[] words;
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder currentLine = new StringBuilder();
        for (String word : words = text.split(" ")) {
            float wordWidth = font.getWidth(word, fontSize);
            if ((double)wordWidth > width) {
                String[] subWords;
                for (String subWord : subWords = GuiCustomTextLabel.splitWord(word, width, font, fontSize)) {
                    float subWordWidth;
                    float lineWidth = font.getWidth(currentLine.toString(), fontSize);
                    if ((double)(lineWidth + (subWordWidth = font.getWidth(subWord, fontSize))) <= width) {
                        currentLine.append(subWord).append(" ");
                        continue;
                    }
                    lines.add(currentLine.toString().trim());
                    currentLine = new StringBuilder(subWord + " ");
                }
                continue;
            }
            float lineWidth = font.getWidth(currentLine.toString(), fontSize);
            if ((double)(lineWidth + wordWidth) <= width) {
                currentLine.append(word).append(" ");
                continue;
            }
            lines.add(currentLine.toString().trim());
            currentLine = new StringBuilder(word + " ");
        }
        lines.add(currentLine.toString().trim());
        return lines;
    }

    private static String[] splitWord(String word, double width, IFont font, float fontSize) {
        ArrayList<String> subWords = new ArrayList<String>();
        StringBuilder currentSubWord = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            float subWordWidth = font.getWidth(currentSubWord.toString() + c, fontSize);
            if ((double)subWordWidth <= width) {
                currentSubWord.append(c);
                continue;
            }
            subWords.add(currentSubWord.toString());
            currentSubWord = new StringBuilder(String.valueOf(c));
        }
        subWords.add(currentSubWord.toString());
        return subWords.toArray(new String[0]);
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void onRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void onHover(int mouseX, int mouseY) {
    }

    @Override
    public void onHoverOut(int mouseX, int mouseY) {
    }

    @Override
    public void fixedUpdate() {
    }

    @Override
    public void onKeyTyped(char c, int key) {
    }

    public GuiCustomTextLabel setTextColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }

    public GuiCustomTextLabel setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    public GuiCustomTextLabel setTextOverflow(TextOverflow textOverflow) {
        this.textOverflow = textOverflow;
        return this;
    }

    public GuiCustomTextLabel setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public GuiCustomTextLabel setTextShadowColor(Color textShadowColor) {
        this.textShadowColor = textShadowColor;
        return this;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setFont(IFont font) {
        this.font = font;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }
}

