/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.textarea;

public enum CharacterSet {
    ALL(CharacterSet.getAllCharacters()),
    LETTERS(CharacterSet.getLetters()),
    LOWERCASE_LETTERS(CharacterSet.getLowercaseLetters()),
    UPPERCASE_LETTERS(CharacterSet.getUppercaseLetters()),
    NUMBERS(CharacterSet.getNumbers()),
    SYMBOLS(CharacterSet.getSymbols());

    private final char[] chars;

    private CharacterSet(char[] chars) {
        this.chars = chars;
    }

    private static char[] getAllCharacters() {
        char[] allCharacters = new char[95];
        for (int i = 0; i < allCharacters.length; ++i) {
            allCharacters[i] = (char)(32 + i);
        }
        return allCharacters;
    }

    private static char[] getLetters() {
        return CharacterSet.concatenateArrays(CharacterSet.getLowercaseLetters(), CharacterSet.getUppercaseLetters());
    }

    private static char[] getLowercaseLetters() {
        return CharacterSet.generateCharacterArray(97, 123);
    }

    private static char[] getUppercaseLetters() {
        return CharacterSet.generateCharacterArray(65, 91);
    }

    private static char[] getNumbers() {
        return CharacterSet.generateCharacterArray(48, 58);
    }

    private static char[] getSymbols() {
        return new char[]{'!', '@', '#', '$', '%', '&', '(', ')', '*', '+', '-', '=', '/', '\\', '_', '?', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '='};
    }

    private static char[] generateCharacterArray(int start, int end) {
        int length = end - start;
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (char)(start + i);
        }
        return array;
    }

    private static char[] concatenateArrays(char[] array1, char[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        char[] result = new char[length1 + length2];
        System.arraycopy(array1, 0, result, 0, length1);
        System.arraycopy(array2, 0, result, length1, length2);
        return result;
    }

    public char[] getChars() {
        return this.chars;
    }

    private boolean isCharacterInSet(char character) {
        for (char validCharacter : this.chars) {
            if (character != validCharacter) continue;
            return true;
        }
        return false;
    }

    public boolean isTextInSet(String text) {
        for (char c : text.toCharArray()) {
            if (this.isCharacterInSet(c)) continue;
            return false;
        }
        return true;
    }
}

