/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.fontv3;

import fr.minepiece.client.gui.component.fontv3.AbstractFont;
import fr.minepiece.client.gui.component.fontv3.Lang;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Locale;
import net.minecraft.client.renderer.GlStateManager;

public final class TextFont
extends AbstractFont {
    private final float stretching;
    private final float spacing;
    private final float lifting;
    public static final String STYLE_CODES = "0123456789abcdefklmnor";
    public static final int[] COLOR_CODES = new int[32];

    public TextFont(String fileName, int size, float stretching, float spacing, float lifting, Lang lang) {
        int d;
        Font font = TextFont.getFont(fileName, 0, size);
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), true, true);
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        int[] codes = lang.getCharCodes();
        char[] chars = new char[codes[1] - codes[0] + codes[3] - codes[2]];
        int n = 0;
        for (d = 0; d <= 2; d += 2) {
            for (int i = codes[d]; i <= codes[d + 1] - 1; ++i) {
                chars[n] = (char)i;
                Rectangle2D bound = font.getStringBounds(Character.toString(chars[n]), fontRenderContext);
                maxWidth = Math.max(maxWidth, bound.getWidth());
                maxHeight = Math.max(maxHeight, bound.getHeight());
                ++n;
            }
        }
        d = (int)Math.ceil(Math.sqrt((maxHeight + 2.0) * (maxWidth + 2.0) * (double)chars.length));
        this.stretching = stretching;
        this.spacing = spacing;
        this.lifting = lifting;
        this.fontName = font.getFontName(Locale.FRENCH);
        this.fontHeight = (float)(maxHeight / 2.0);
        this.imgHeight = d;
        this.imgWidth = d;
        BufferedImage image = new BufferedImage(this.imgWidth, this.imgHeight, 2);
        Graphics2D graphics = this.setupGraphics(image, font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int posX = 1;
        int posY = 2;
        for (char c : chars) {
            AbstractFont.Glyph glyph = new AbstractFont.Glyph();
            Rectangle2D bounds = fontMetrics.getStringBounds(Character.toString(c), graphics);
            glyph.width = (int)bounds.getWidth() + 1;
            glyph.height = (int)bounds.getHeight() + 2;
            if (posX + glyph.width >= this.imgWidth) {
                posX = 1;
                posY = (int)((double)posY + (maxHeight + (double)fontMetrics.getDescent() + 2.0));
            }
            glyph.x = posX;
            glyph.y = posY;
            graphics.drawString(Character.toString(c), posX, posY + fontMetrics.getAscent());
            posX += glyph.width + 4;
            this.glyphs.put(Character.valueOf(c), glyph);
        }
        this.setTexture(image);
    }

    @Override
    public float renderString(String text, double x, double y, boolean shadow, Color color, float scale) {
        float startPos;
        float posX = startPos = (float)x * 2.0f;
        float posY = (float)(y -= (double)this.getLifting()) * 2.0f;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        this.bindTex();
        for (int i = 0; i < text.length(); ++i) {
            posX += this.renderGlyph(text.charAt(i), posX, posY, red, green, blue, alpha, scale);
        }
        this.unbindTex();
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        return (posX - startPos) / 2.0f;
    }

    @Override
    public float getStretching() {
        return this.stretching;
    }

    @Override
    public float getSpacing() {
        return this.spacing;
    }

    @Override
    public float getLifting() {
        return this.fontHeight + this.lifting;
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            TextFont.COLOR_CODES[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }
}

