/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.fontv3;

import fr.minepiece.client.gui.component.fontv3.AbstractFont;
import fr.minepiece.client.gui.component.fontv3.GlyphPage;
import fr.minepiece.client.gui.component.fontv3.IFont;
import fr.minepiece.client.gui.component.fontv3.Lang;
import java.awt.Color;
import java.util.Locale;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public final class StyledFont
implements IFont {
    private final GlyphPage regular;
    private final GlyphPage bold;
    private final GlyphPage italic;
    private final GlyphPage boldItalic;
    public static final String STYLE_CODES = "0123456789abcdefklmnor";
    public static final int[] COLOR_CODES = new int[32];

    public StyledFont(String fileName, int size, float stretching, float spacing, float lifting, Lang lang) {
        System.out.println("init styled");
        int[] codes = lang.getCharCodes();
        char[] chars = new char[codes[1] - codes[0] + codes[3] - codes[2]];
        int c = 0;
        for (int d = 0; d <= 2; d += 2) {
            for (int i = codes[d]; i <= codes[d + 1] - 1; ++i) {
                chars[c] = (char)i;
                ++c;
            }
        }
        this.regular = new GlyphPage(AbstractFont.getFont(fileName, 0, size), chars, stretching, spacing, lifting);
        this.bold = new GlyphPage(AbstractFont.getFont(fileName, 1, size), chars, stretching, spacing, lifting);
        this.italic = new GlyphPage(AbstractFont.getFont(fileName, 2, size), chars, stretching, spacing, lifting);
        this.boldItalic = new GlyphPage(AbstractFont.getFont(fileName, 3, size), chars, stretching, spacing, lifting);
    }

    public float renderGlyph(char c, float x, float y, boolean bold, boolean italic, float red, float green, float blue, float alpha, float scale) {
        return this.getGlyphPage(bold, italic).renderGlyph(c, x, y, red, green, blue, alpha, scale);
    }

    @Override
    public float getWidth(String text, float scale) {
        boolean bold = false;
        boolean italic = false;
        float width = 0.0f;
        for (int i = 0; i < text.length(); ++i) {
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length() && STYLE_CODES.indexOf(text.toLowerCase(Locale.FRENCH).charAt(i + 1)) != -1) {
                int i1 = STYLE_CODES.indexOf(text.toLowerCase(Locale.FRENCH).charAt(i + 1));
                if (i1 < 16) {
                    bold = false;
                    italic = false;
                } else if (i1 == 17) {
                    bold = true;
                } else if (i1 == 20) {
                    italic = true;
                } else if (i1 == 21) {
                    bold = false;
                    italic = false;
                }
                ++i;
                continue;
            }
            width += this.getGlyphPage(bold, italic).getWidth(c0) + this.regular.getSpacing();
        }
        return (width - this.regular.getSpacing()) / 2.0f;
    }

    private GlyphPage getGlyphPage(boolean boldStyle, boolean italicStyle) {
        if (boldStyle && italicStyle) {
            return this.boldItalic;
        }
        if (boldStyle) {
            return this.bold;
        }
        if (italicStyle) {
            return this.italic;
        }
        return this.regular;
    }

    @Override
    public float renderString(String text, double x, double y, boolean shadow, Color color, float scale) {
        float startPos;
        float posX = startPos = (float)x * 2.0f;
        float posY = (float)(y -= (double)this.getLifting()) * 2.0f;
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        boolean bold = false;
        boolean italic = false;
        boolean strikethrough = false;
        boolean underline = false;
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < text.length(); ++i) {
            BufferBuilder bufferBuilder;
            char c0 = text.charAt(i);
            if (c0 == '\u00a7' && i + 1 < text.length()) {
                char styleCode = text.charAt(i + 1);
                if (STYLE_CODES.indexOf(styleCode) == -1) continue;
                int styleIndex = STYLE_CODES.indexOf(styleCode);
                if (styleIndex < 16) {
                    bold = false;
                    strikethrough = false;
                    underline = false;
                    italic = false;
                    if (shadow) {
                        styleIndex += 16;
                    }
                    int colorCode = COLOR_CODES[styleIndex];
                    red = (float)(colorCode >> 16 & 0xFF) / 255.0f;
                    green = (float)(colorCode >> 8 & 0xFF) / 255.0f;
                    blue = (float)(colorCode & 0xFF) / 255.0f;
                    alpha = 1.0f;
                } else if (styleIndex != 16) {
                    if (styleIndex == 17) {
                        bold = true;
                    } else if (styleIndex == 18) {
                        strikethrough = true;
                    } else if (styleIndex == 19) {
                        underline = true;
                    } else if (styleIndex == 20) {
                        italic = true;
                    } else if (styleIndex == 21) {
                        bold = false;
                        strikethrough = false;
                        underline = false;
                        italic = false;
                    }
                }
                ++i;
                continue;
            }
            float f = this.renderGlyph(c0, posX, posY, bold, italic, red, green, blue, alpha, scale);
            if (strikethrough) {
                float h = this.getLifting() + 2.0f;
                GlStateManager.func_179090_x();
                Tessellator tessellator = Tessellator.func_178181_a();
                bufferBuilder = tessellator.func_178180_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferBuilder.func_181662_b((double)posX, (double)(posY + h + 3.0f), 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(posX + f), (double)(posY + h + 3.0f), 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(posX + f), (double)(posY + h), 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)posX, (double)(posY + h), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            if (underline) {
                float y1 = posY + this.getLifting() * 2.0f - 4.0f;
                GlStateManager.func_179090_x();
                Tessellator tessellator = Tessellator.func_178181_a();
                bufferBuilder = tessellator.func_178180_c();
                bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                bufferBuilder.func_181662_b((double)posX, (double)(y1 + 4.0f), 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(posX + f), (double)(y1 + 4.0f), 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)(posX + f), (double)(y1 + 2.0f), 0.0).func_181675_d();
                bufferBuilder.func_181662_b((double)posX, (double)(y1 + 2.0f), 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179098_w();
            }
            posX += f;
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        return (posX - startPos) / 2.0f;
    }

    public String getFontName() {
        return this.regular.getFontName();
    }

    @Override
    public float getFontHeight() {
        return this.regular.getFontHeight();
    }

    public float getStretching() {
        return this.regular.getStretching();
    }

    public float getSpacing() {
        return this.regular.getSpacing();
    }

    public float getLifting() {
        return this.regular.getLifting();
    }

    static {
        for (int i = 0; i < 32; ++i) {
            int j = (i >> 3 & 1) * 85;
            int k = (i >> 2 & 1) * 170 + j;
            int l = (i >> 1 & 1) * 170 + j;
            int i1 = (i & 1) * 170 + j;
            if (i == 6) {
                k += 85;
            }
            if (i >= 16) {
                k /= 4;
                l /= 4;
                i1 /= 4;
            }
            StyledFont.COLOR_CODES[i] = (k & 0xFF) << 16 | (l & 0xFF) << 8 | i1 & 0xFF;
        }
    }
}

