/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.fontv3;

import fr.minepiece.client.ClientProxy;
import fr.minepiece.client.gui.component.fontv3.IFont;
import fr.minepiece.client.gui.component.fontv3.TextureHelper;
import fr.minepiece.client.gui.component.fontv3.Wrapper;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

public abstract class AbstractFont
implements Wrapper,
IFont {
    protected final Map<Character, Glyph> glyphs = new HashMap<Character, Glyph>();
    protected int texId;
    protected int imgWidth;
    protected int imgHeight;
    protected float fontHeight;
    protected String fontName;

    public abstract float getStretching();

    public abstract float getSpacing();

    public abstract float getLifting();

    @Override
    public float getFontHeight() {
        return this.fontHeight;
    }

    public final String getFontName() {
        return this.fontName;
    }

    protected final void setTexture(BufferedImage img) {
        this.texId = TextureHelper.loadTexture(img);
    }

    public final void bindTex() {
        GlStateManager.func_179144_i((int)this.texId);
    }

    public final void unbindTex() {
        GlStateManager.func_179144_i((int)0);
    }

    public static final Font getFont(String fileName, int style, int size) {
        String path = "/assets/minepiece/font/".concat(fileName);
        Font font = null;
        try {
            font = Font.createFont(0, ClientProxy.class.getResourceAsStream(path)).deriveFont(style, size);
        }
        catch (FontFormatException | IOException e) {
            e.printStackTrace();
        }
        return font;
    }

    public final Graphics2D setupGraphics(BufferedImage img, Font font) {
        Graphics2D graphics = img.createGraphics();
        graphics.setFont(font);
        graphics.setColor(new Color(255, 255, 255, 0));
        graphics.fillRect(0, 0, this.imgWidth, this.imgHeight);
        graphics.setColor(Color.WHITE);
        graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return graphics;
    }

    public float renderGlyph(char c, float x, float y, float red, float green, float blue, float alpha, float scale) {
        Glyph glyph = this.glyphs.get(Character.valueOf(c));
        if (glyph == null) {
            return 0.0f;
        }
        float pageX = (float)glyph.x / (float)this.imgWidth;
        float pageY = (float)glyph.y / (float)this.imgHeight;
        float pageWidth = (float)glyph.width / (float)this.imgWidth;
        float pageHeight = (float)glyph.height / (float)this.imgHeight;
        float width = (float)glyph.width + this.getStretching();
        float height = glyph.height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        GlStateManager.func_179131_c((float)red, (float)green, (float)blue, (float)alpha);
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)((y += 20.0f + height) + height), 0.0).func_187315_a((double)pageX, (double)(pageY + pageHeight)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)(pageX + pageWidth), (double)(pageY + pageHeight)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)(pageX + pageWidth), (double)pageY).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)pageX, (double)pageY).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return width + this.getSpacing();
    }

    public float getWidth(char ch) {
        return (float)this.glyphs.get((Object)Character.valueOf((char)ch)).width + this.getStretching();
    }

    @Override
    public float getWidth(String text, float scale) {
        float width = 0.0f;
        float spacing = this.getSpacing();
        for (int i = 0; i < text.length(); ++i) {
            width += this.getWidth(text.charAt(i)) + spacing;
        }
        return (width - spacing) / 2.0f;
    }

    public class Glyph {
        public int x;
        public int y;
        public int width;
        public int height;
    }
}

