/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button.scroll;

import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.scroll.GuiScrollButton;
import fr.minepiece.client.gui.component.button.scroll.ScrollArea;
import net.minecraft.util.ResourceLocation;

public class ScrollableArea {
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    private ScrollArea scrollArea;
    private double scroll;
    private double maxScroll;
    private boolean cursorScrolling;
    private boolean canScroll;
    private int scrollSpeed = 15;
    private ResourceLocation scrollTexture;
    private ResourceLocation scrollHoverTexture;

    public ScrollableArea(double minX, double minY, double maxX, double maxY, ScrollArea scrollArea) {
        this.minX = minX;
        this.minY = minY;
        this.maxX = maxX;
        this.maxY = maxY;
        this.scrollArea = scrollArea;
    }

    public String toString() {
        return "ScrollableArea(minX=" + this.getMinX() + ", minY=" + this.getMinY() + ", maxX=" + this.getMaxX() + ", maxY=" + this.getMaxY() + ", scrollArea=" + this.getScrollArea() + ", scroll=" + this.getScroll() + ", maxScroll=" + this.getMaxScroll() + ", cursorScrolling=" + this.isCursorScrolling() + ", canScroll=" + this.isCanScroll() + ", scrollSpeed=" + this.getScrollSpeed() + ", scrollTexture=" + this.getScrollTexture() + ", scrollHoverTexture=" + this.getScrollHoverTexture() + ")";
    }

    public double getMinX() {
        return this.minX;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public void setMinY(double minY) {
        this.minY = minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public void setMaxX(double maxX) {
        this.maxX = maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public void setMaxY(double maxY) {
        this.maxY = maxY;
    }

    public ScrollArea getScrollArea() {
        return this.scrollArea;
    }

    public void setScrollArea(ScrollArea scrollArea) {
        this.scrollArea = scrollArea;
    }

    public double getScroll() {
        return this.scroll;
    }

    public void setScroll(double scroll) {
        this.scroll = scroll;
    }

    public double getMaxScroll() {
        return this.maxScroll;
    }

    public void setMaxScroll(double maxScroll) {
        this.maxScroll = maxScroll;
    }

    public boolean isCursorScrolling() {
        return this.cursorScrolling;
    }

    public void setCursorScrolling(boolean cursorScrolling) {
        this.cursorScrolling = cursorScrolling;
    }

    public boolean isCanScroll() {
        return this.canScroll;
    }

    public void setCanScroll(boolean canScroll) {
        this.canScroll = canScroll;
    }

    public int getScrollSpeed() {
        return this.scrollSpeed;
    }

    public ScrollableArea setScrollSpeed(int speed) {
        this.scrollSpeed = speed * 3;
        return this;
    }

    public ResourceLocation getScrollTexture() {
        return this.scrollTexture;
    }

    public ScrollableArea setScrollTexture(String texture) {
        this.scrollTexture = new ResourceLocation(texture + ".png");
        this.scrollHoverTexture = new ResourceLocation(texture + ".png");
        return this;
    }

    public ResourceLocation getScrollHoverTexture() {
        return this.scrollHoverTexture;
    }

    public ScrollableArea setScrollHoverTexture(String texture) {
        this.scrollHoverTexture = new ResourceLocation(texture + ".png");
        return this;
    }

    public boolean inArea(double x, double y) {
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY;
    }

    public boolean inCompleteArea(double x, double y, double width, double height) {
        return x >= this.minX && x + width <= this.maxX && y >= this.minY && y + height <= this.maxY;
    }

    public boolean inArea(GuiComponent node) {
        return this.inArea(node.getAbsoluteX(), node.getAbsoluteY());
    }

    public boolean inCompleteArea(GuiComponent node) {
        return this.inCompleteArea(node.getAbsoluteX(), node.getAbsoluteY(), node.width, node.height);
    }

    public int getWidth() {
        return (int)(this.maxX - this.minX);
    }

    public int getHeight() {
        return (int)(this.maxY - this.minY);
    }

    public GuiScrollButton createScrollBar() {
        return new GuiScrollButton(this.getScrollArea().getX(), this.getScrollArea().getY(), this.getScrollArea().getButtonWidth(), this.getScrollArea().getButtonHeight(), this);
    }
}

