/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button.scroll;

import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.button.scroll.ScrollableArea;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class GuiScrollButton
extends GuiComponent {
    private final ScrollableArea area;
    private double scroll;

    public GuiScrollButton(double x, double y, double width, double height, ScrollableArea area) {
        super(x, y, width, height);
        this.area = area;
        this.setSolid(false);
    }

    @Override
    public ScrollableArea getArea() {
        return this.area;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        if (!this.isEnabled()) {
            GL11.glColor3f((float)0.4f, (float)0.4f, (float)0.4f);
        }
        int fps = Integer.parseInt(Minecraft.func_71410_x().field_71426_K.split(" fps")[0]);
        double diff = this.scroll - this.y;
        double absDiff = Math.abs(diff);
        double offset = 0.2 / (double)((fps == 0 ? 1.0f : (float)fps) / 60.0f) * absDiff / 3.0;
        if (this.area.isCursorScrolling()) {
            offset = 0.4 / (double)((fps == 0 ? 1.0f : (float)fps) / 60.0f) * absDiff;
        }
        this.y = absDiff > (this.area.isCursorScrolling() ? 0.4 : 0.2) ? (this.y += diff > 0.0 ? offset : -offset) : this.scroll;
        this.drawScrollbar();
        super.draw(mc, mouseX, mouseY);
        GL11.glPopMatrix();
    }

    public void drawScrollbar() {
        if (this.area.getScrollTexture() != null) {
            GuiUtils.drawImageTransparent(this.x, this.y, this.isHovered() && this.isEnabled() ? this.area.getScrollHoverTexture() : this.area.getScrollTexture(), this.width, this.height);
        }
    }

    @Override
    public boolean isHovered(int mouseX, int mouseY) {
        if (this.getUi() != null && this.getUi().popup != null) {
            return false;
        }
        return (double)mouseX > this.getAbsoluteX() && (double)mouseX < this.getAbsoluteX() + this.width && (double)mouseY > this.getAbsoluteY() && (double)mouseY < this.getAbsoluteY() + this.height;
    }

    @Override
    public void setY(double y) {
        this.scroll = y;
    }

    @Override
    public void drawDebug() {
        if (this.area.isCursorScrolling()) {
            GuiUtils.drawBorder(this.x, this.y, this.x + this.width, this.y + this.height, new Color(46, 213, 115));
            return;
        }
        super.drawDebug();
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void onRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void onHover(int mouseX, int mouseY) {
    }

    @Override
    public void onHoverOut(int mouseX, int mouseY) {
    }

    @Override
    public void fixedUpdate() {
    }

    @Override
    public void onKeyTyped(char c, int key) {
    }
}

