/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button;

import fr.minepiece.client.ClientProxy;
import fr.minepiece.client.gui.component.HoverObject;
import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.fontv3.IFont;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.vecmath.Vector2d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.ThreadDownloadImageData;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL14;

public class GuiUtils {
    public static int dotDelay = 0;
    public static String dots = "...";
    public static int toolTipY;
    public static List<HoverObject> hovers;

    public static void renderText(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_78276_b(text, givenX, givenY, color);
        GL11.glPopMatrix();
    }

    public static void renderTextWithShadow(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71466_p.func_175063_a(text, (float)givenX, (float)givenY, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredText(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.renderText(text, givenX - mc.field_71466_p.func_78256_a(text) / 2, givenY - mc.field_71466_p.field_78288_b / 2, color);
        GL11.glPopMatrix();
    }

    public static void renderAlignedText(String text, int givenX, int givenY, int color, TextAlign align) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        int textWidth = mc.field_71466_p.func_78256_a(text);
        int textHeight = mc.field_71466_p.field_78288_b;
        int adjustedX = givenX;
        int adjustedY = givenY;
        switch (align) {
            case LEFT: {
                break;
            }
            case CENTER: {
                adjustedX -= textWidth / 2;
                break;
            }
            case RIGHT: {
                adjustedX -= textWidth;
            }
        }
        GuiUtils.renderText(text, adjustedX, adjustedY += textHeight, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextWithShadow(String text, int givenX, int givenY, int color) {
        GL11.glPushMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        GuiUtils.renderTextWithShadow(text, givenX - mc.field_71466_p.func_78256_a(text) / 2, givenY - mc.field_71466_p.field_78288_b / 2, color);
        GL11.glPopMatrix();
    }

    public static void renderTextScaled(String text, int givenX, int givenY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaled(String text, int givenX, int givenY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderCenteredText(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderAlignedTextScaled(String text, int givenX, int givenY, int color, TextAlign align, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderAlignedText(text, 0, 0, color, align);
        GL11.glPopMatrix();
    }

    public static void renderCenteredTextScaledWithShadow(String text, int givenX, int givenY, int color, double givenScale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)givenX, (double)givenY, (double)0.0);
        GL11.glScaled((double)givenScale, (double)givenScale, (double)givenScale);
        GuiUtils.renderCenteredTextWithShadow(text, 0, 0, color);
        GL11.glPopMatrix();
    }

    public static void renderTextWithOutline(String text, int x, int y, int color, int outlineColor) {
        GuiUtils.renderText(text, x - 1, y + 1, outlineColor);
        GuiUtils.renderText(text, x, y + 1, outlineColor);
        GuiUtils.renderText(text, x + 1, y + 1, outlineColor);
        GuiUtils.renderText(text, x - 1, y, outlineColor);
        GuiUtils.renderText(text, x + 1, y, outlineColor);
        GuiUtils.renderText(text, x - 1, y - 1, outlineColor);
        GuiUtils.renderText(text, x, y - 1, outlineColor);
        GuiUtils.renderText(text, x + 1, y - 1, outlineColor);
        GuiUtils.renderText(text, x, y, color);
    }

    public static void renderTextScaledWithOutline(String text, int x, int y, int color, int outlineColor, double givenScale) {
        GuiUtils.renderTextScaled(text, x - 1, y + 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x, y + 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x + 1, y + 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x - 1, y, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x + 1, y, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x - 1, y - 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x, y - 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x + 1, y - 1, outlineColor, givenScale);
        GuiUtils.renderTextScaled(text, x, y, color, givenScale);
    }

    public static void renderRect(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        if (givenX < givenWidth) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
    }

    public static void renderRect(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, float givenAlpha) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        if (givenX < givenWidth) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = givenAlpha;
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)f3);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderRectWithFade(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, float givenFade) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        if (givenX < givenWidth) {
            int i = givenX;
            givenX = givenWidth;
            givenWidth = i;
        }
        if (givenY < givenHeight) {
            int j = givenY;
            givenY = givenHeight;
            givenHeight = j;
        }
        float f3 = (float)(givenColor >> 24 & 0xFF) / 255.0f;
        float f = (float)(givenColor >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(givenColor >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(givenColor & 0xFF) / 255.0f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179131_c((float)f, (float)f1, (float)f2, (float)givenFade);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void renderRectWithOutline(int givenX, int givenY, int givenWidth, int givenHeight, int givenColor, int givenOutlineColor, int outlineThickness) {
        GuiUtils.renderRect(givenX - outlineThickness, givenY - outlineThickness, givenWidth + outlineThickness * 2, givenHeight + outlineThickness * 2, givenOutlineColor);
        GuiUtils.renderRect(givenX, givenY, givenWidth, givenHeight, givenColor);
    }

    public static void renderOutline(int givenX, int givenY, int givenWidth, int givenHeight, int givenOutlineColor, int outlineThickness) {
        GuiUtils.renderRect(givenX - outlineThickness, givenY - outlineThickness, givenWidth + outlineThickness * 2, outlineThickness, givenOutlineColor);
        GuiUtils.renderRect(givenX - outlineThickness + 1, givenY + givenHeight - outlineThickness + 1, givenWidth + outlineThickness * 2 - 2, outlineThickness, givenOutlineColor);
        GuiUtils.renderRect(givenX - outlineThickness, givenY - outlineThickness + 1, outlineThickness, givenHeight + outlineThickness * 2 - 1, givenOutlineColor);
        GuiUtils.renderRect(givenX + givenWidth + outlineThickness - 1, givenY - outlineThickness + 1, outlineThickness, givenHeight + outlineThickness * 2 - 1, givenOutlineColor);
    }

    public static void renderRectWithGradient(int givenX, int givenY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel) {
        GlStateManager.func_179094_E();
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
    }

    public static void renderRectWithGradientWithAlpha(int givenX, int givenY, int givenWidth, int givenHeight, int startColor, int endColor, double givenZLevel, float givenAlphaStart, float givenAlphaEnd) {
        givenWidth = givenX + givenWidth;
        givenHeight = givenY + givenHeight;
        float f = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(startColor & 0xFF) / 255.0f;
        float f4 = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, givenAlphaStart).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenY, givenZLevel).func_181666_a(f1, f2, f3, givenAlphaStart).func_181675_d();
        bufferbuilder.func_181662_b((double)givenX, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, givenAlphaEnd).func_181675_d();
        bufferbuilder.func_181662_b((double)givenWidth, (double)givenHeight, givenZLevel).func_181666_a(f5, f6, f7, givenAlphaEnd).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void renderPositionedImageNoDepth(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GuiUtils.renderPositionedImage(par1, par2, par3, par4, par5, width, height);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public static void renderPositionedImage(ResourceLocation par1, double par2, double par3, double par4, float par5, float width, float height) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderImage(-width / 2.0f, -height / 2.0f, par1, width, height);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderPositionedTextScaled(String givenText, double par2, double par3, double par4, float scale, int givenColor) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        GL11.glPushMatrix();
        GL11.glTranslated((double)par2, (double)par3, (double)par4);
        GL11.glTranslated((double)(-mc.func_175598_ae().field_78730_l), (double)(-mc.func_175598_ae().field_78731_m), (double)(-mc.func_175598_ae().field_78728_n));
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)player.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScalef((float)-0.03f, (float)-0.03f, (float)0.03f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GuiUtils.renderCenteredTextScaled(givenText, 0, 0, givenColor, scale);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void renderImage(double x, double y, ResourceLocation image, double width, double height) {
        GuiUtils.renderColor(0xFFFFFF);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void drawImageTransparent(double x, double y, ResourceLocation image, double width, double height, boolean linearInterpolation) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        GL11.glPushMatrix();
        GL11.glEnable((int)2832);
        GL11.glEnable((int)3042);
        GL14.glBlendEquation((int)32774);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTexParameteri((int)3553, (int)10241, (int)(linearInterpolation ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10240, (int)(linearInterpolation ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    public static void drawImageTransparent(double x, double y, ResourceLocation image, double width, double height, double alpha) {
        GuiUtils.renderColor(0xFFFFFF, alpha);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(image);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GL11.glHint((int)3153, (int)4353);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b(x, y + height, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y + height, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        bufferbuilder.func_181662_b(x + width, y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        bufferbuilder.func_181662_b(x, y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2832);
    }

    public static void renderImageCentered(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight) {
        GL11.glPushMatrix();
        GuiUtils.renderImage(givenX - givenWidth / 2.0, givenY - givenHeight / 2.0, givenTexture, givenWidth, givenHeight);
        GL11.glPopMatrix();
    }

    public static void renderImageCenteredTransparent(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, double alpha) {
        GlStateManager.func_179094_E();
        GuiUtils.drawImageTransparent(givenX - givenWidth / 2.0, givenY - givenHeight / 2.0, givenTexture, givenWidth, givenHeight, alpha);
        GlStateManager.func_179121_F();
    }

    public static void renderImageCenteredScaled(double givenX, double givenY, ResourceLocation givenTexture, double givenWidth, double givenHeight, float givenScale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(givenX - givenX * (double)givenScale), (double)(givenY - givenY * (double)givenScale), (double)0.0);
        GlStateManager.func_179152_a((float)givenScale, (float)givenScale, (float)givenScale);
        GuiUtils.renderImageCentered(givenX, givenY, givenTexture, givenWidth, givenHeight);
        GlStateManager.func_179121_F();
    }

    public static void renderImageTransparent(int givenX, int givenY, ResourceLocation givenTexture, int givenWidth, int givenHeight, double givenAlpha) {
        GL11.glPushMatrix();
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)givenAlpha);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2832);
        GuiUtils.renderImage(givenX, givenY, givenTexture, givenWidth, givenHeight);
        GL11.glDisable((int)2832);
        GL11.glDisable((int)3042);
        GL11.glColor4d((double)255.0, (double)255.0, (double)255.0, (double)255.0);
        GL11.glPopMatrix();
    }

    public static String getScoreboardTitle(Minecraft mc) {
        if (mc.field_71441_e != null && mc.field_71441_e.func_96441_U() != null) {
            ScoreObjective scoreobjective = mc.field_71441_e.func_96441_U().func_96539_a(1);
            if (scoreobjective != null) {
                String scoreTitle = scoreobjective.func_96678_d().replace("\u00a7", "").replaceAll("[a-z]", "").replaceAll("[0-9]", "");
                return scoreTitle;
            }
        } else {
            return null;
        }
        return null;
    }

    public static void renderColor(int par1) {
        Color color = Color.decode("" + par1);
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        GL11.glColor3f((float)red, (float)green, (float)blue);
    }

    public static void renderColor(int par1, double alpha) {
        Color color = Color.decode("" + par1);
        double red = (double)color.getRed() / 255.0;
        double green = (double)color.getGreen() / 255.0;
        double blue = (double)color.getBlue() / 255.0;
        GL11.glColor4d((double)red, (double)green, (double)blue, (double)alpha);
    }

    public static boolean isInBox(int x, int y, int width, int height, int checkX, int checkY) {
        return checkX >= x && checkY >= y && checkX <= x + width && checkY <= y + height;
    }

    public static void renderBoundingBox(AxisAlignedBB givenBB) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderBoundingBoxFilled(AxisAlignedBB givenBB) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldRenderer = tessellator.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        tessellator.func_78381_a();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72340_a, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72339_c).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72337_e, givenBB.field_72334_f).func_181675_d();
        worldRenderer.func_181662_b(givenBB.field_72336_d, givenBB.field_72338_b, givenBB.field_72334_f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static double getDistanceToClientCamera(double x, double y, double z) {
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        double d3 = renderManager.field_78730_l - x;
        double d4 = renderManager.field_78731_m - y;
        double d5 = renderManager.field_78728_n - z;
        return MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
    }

    public static BufferedImage downloadBanner(String url) {
        try {
            return ImageIO.read(new URL(url));
        }
        catch (IOException e) {
            System.out.println("Errors reading online image: '" + url + "'");
            return null;
        }
    }

    public static void drawImageTransparent(double x, double y, ResourceLocation location, double width, double height) {
        GuiUtils.drawImageTransparent(x, y, location, width, height, false);
    }

    public static void drawBorder(double x, double y, double x2, double y2, Color color) {
        GuiUtils.drawRect(x, y - 1.0, x2, y, color);
        GuiUtils.drawRect(x - 1.0, y, x, y2, color);
        GuiUtils.drawRect(x, y2, x2, y2 + 1.0, color);
        GuiUtils.drawRect(x2, y, x2 + 1.0, y2, color);
    }

    public static void drawBorder(double x, double y, double x2, double y2, Color color, double stoke) {
        GuiUtils.drawRect(x, y - stoke, x2, y, color);
        GuiUtils.drawRect(x - stoke, y, x, y2, color);
        GuiUtils.drawRect(x, y2, x2, y2 + stoke, color);
        GuiUtils.drawRect(x2, y, x2 + stoke, y2, color);
    }

    public static void drawRect(double x, double y, double x2, double y2, Color color) {
        GuiUtils.drawShape(color, new Vector2d(x, y2), new Vector2d(x2, y2), new Vector2d(x2, y), new Vector2d(x, y));
    }

    public static void drawShape(Color color, Vector2d ... points) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (Vector2d point : points) {
            bufferbuilder.func_181662_b(point.x, point.y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public static void scissor(Minecraft mc, double x, double y, double width, double height) {
        GL11.glScissor((int)((int)x), (int)((int)((double)mc.field_71440_d - (y + height))), (int)((int)width), (int)((int)height));
    }

    public static void scissorWithScaleFactor(Minecraft mc, double x, double y, double width, double height) {
        ScaledResolution res = new ScaledResolution(mc);
        int scaleFactor = res.func_78325_e();
        GL11.glScissor((int)((int)(x * (double)scaleFactor)), (int)((int)(((double)res.func_78328_b() - (y + height)) * (double)scaleFactor)), (int)((int)(width * (double)scaleFactor)), (int)((int)(height * (double)scaleFactor)));
    }

    public static int getStringWidth(Minecraft mc, String text, IFont font, int fontSize) {
        if (font == null) {
            return 0;
        }
        return (int)font.getWidth(text, fontSize);
    }

    public static double getAccurateStringWidth(Minecraft mc, String text, IFont font, int fontSize) {
        if (font == null) {
            return 0.0;
        }
        return font.getWidth(text, fontSize);
    }

    public static int getFontHeight(Minecraft mc, IFont font, int fontSize) {
        if (font == null) {
            return 0;
        }
        return (int)(font.getFontHeight() + 5.0f);
    }

    public static int drawStringWithCustomFont(Minecraft mc, String text, double posX, double posY, Color color, IFont font, int fontSize) {
        if (font == null) {
            return 0;
        }
        float scaleFactor = (float)Math.min(mc.field_71443_c, 1920) / 1920.0f;
        fontSize = (int)((float)ClientProxy.fontSize * scaleFactor);
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)0.0);
        GL11.glScaled((double)scaleFactor, (double)scaleFactor, (double)scaleFactor);
        float output = font.renderString(text, 0.0, 0.0, false, color, scaleFactor);
        GL11.glPopMatrix();
        return (int)output;
    }

    public static int drawStringWithCustomFont(Minecraft mc, String text, double posX, double posY, Color color, IFont font, int fontSize, boolean shadow, Color shadowColor) {
        if (font == null) {
            return 0;
        }
        float scaleFactor = (float)Math.min(mc.field_71443_c, 1920) / 1920.0f;
        return GuiUtils.getStringWidth(mc, text, font, fontSize *= (int)scaleFactor);
    }

    public static List<String> getSplittedString(Minecraft mc, String text, IFont font, int fontSize, double maxWidth) {
        ArrayList<String> texts = new ArrayList<String>();
        int lastSplit = 0;
        for (int i = 0; i < text.length(); ++i) {
            int width;
            if (text.charAt(i) == '\n') {
                int foundSplit = i;
                texts.add(text.substring(lastSplit, foundSplit));
                lastSplit = foundSplit;
            }
            if (!((double)(width = GuiUtils.getStringWidth(mc, text.substring(lastSplit, i + 1), font, fontSize)) >= maxWidth)) continue;
            int foundSplit = i;
            for (int j = i - 1; j >= lastSplit; --j) {
                if (text.charAt(j) != ' ') continue;
                foundSplit = Math.min(text.length(), j + 1);
                break;
            }
            texts.add(text.substring(lastSplit, foundSplit));
            lastSplit = foundSplit;
        }
        texts.add(text.substring(lastSplit));
        return texts;
    }

    public static void drawSplittedString(Minecraft mc, String text, double x, double y, Color color, IFont font, int fontSize, double maxWidth, TextAlign align) {
        int i;
        int fontHeight = GuiUtils.getFontHeight(mc, font, fontSize + 10);
        ArrayList<String> texts = new ArrayList<String>();
        int lastSplit = 0;
        for (i = 0; i < text.length(); ++i) {
            int width;
            if (text.charAt(i) == '\n') {
                int foundSplit = i;
                texts.add(text.substring(lastSplit, foundSplit));
                lastSplit = foundSplit;
            }
            if (!((double)(width = GuiUtils.getStringWidth(mc, text.substring(lastSplit, i + 1), font, fontSize)) >= maxWidth)) continue;
            int foundSplit = i;
            for (int j = i - 1; j >= lastSplit; --j) {
                if (text.charAt(j) != ' ') continue;
                foundSplit = Math.min(text.length(), j + 1);
                break;
            }
            texts.add(text.substring(lastSplit, foundSplit));
            lastSplit = foundSplit;
        }
        texts.add(text.substring(lastSplit));
        for (i = 0; i < texts.size(); ++i) {
            if (align == TextAlign.CENTER) {
                GuiUtils.drawCenteredStringWithCustomFont(mc, (String)texts.get(i), x, y + (double)(i * fontHeight), color, font, fontSize);
                continue;
            }
            if (align == TextAlign.LEFT) {
                GuiUtils.drawStringWithCustomFont(mc, (String)texts.get(i), x, y + (double)(i * fontHeight), color, font, fontSize);
                continue;
            }
            if (align != TextAlign.RIGHT) continue;
            GuiUtils.drawStringWithCustomFont(mc, (String)texts.get(i), x - (double)GuiUtils.getStringWidth(mc, (String)texts.get(i), font, fontSize), y + (double)(i * fontHeight), color, font, fontSize);
        }
    }

    public static int drawCenteredStringWithCustomFont(Minecraft mc, String text, double posX, double posY, Color color, IFont font, int fontSize) {
        int width = GuiUtils.getStringWidth(mc, text, font, fontSize);
        return GuiUtils.drawStringWithCustomFont(mc, text, posX - (double)(width / 2), posY, color, font, fontSize);
    }

    public static float width(float value) {
        return (float)Minecraft.func_71410_x().field_71443_c / 100.0f * value;
    }

    public static float height(float value) {
        return (float)Minecraft.func_71410_x().field_71440_d / 100.0f * value;
    }

    public static double width(double value) {
        return (double)Minecraft.func_71410_x().field_71443_c / 100.0 * value;
    }

    public static double height(double value) {
        return (double)Minecraft.func_71410_x().field_71440_d / 100.0 * value;
    }

    public static void drawHoveringText(List<String> texts, int x, int y, IFont font) {
        GuiUtils.drawHoveringText(texts, x, y, font, new Color(30, 55, 153));
    }

    public static void drawHoveringText(List<String> texts, int x, int y, IFont font, Color borderColor) {
        if (texts == null || texts.isEmpty() || font == null) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r == null) {
            return;
        }
        if (borderColor == null) {
            GuiUtils.drawHoveringText(texts, x, y, font);
            return;
        }
        x += 12;
        y -= 12;
        int mcWidth = mc.field_71443_c;
        int mcHeight = mc.field_71440_d;
        int FONT_HEIGHT = GuiUtils.getFontHeight(mc, font, 32);
        borderColor = new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), 180);
        Color backgroundColor = new Color(16, 0, 16, 180);
        double offset = (float)mcWidth / 100.0f * 0.1f;
        double padding = (float)mcWidth / 100.0f * 0.5f;
        int width = 0;
        int height = (int)((double)(FONT_HEIGHT * texts.size()) + padding * 2.0);
        for (String text : texts) {
            if (text == null) continue;
            width = (int)Math.max((double)width, (double)GuiUtils.getStringWidth(mc, text, font, 2) + padding * 2.0);
        }
        if (x + width > mcWidth) {
            x -= 28 + width;
        }
        if (y + height > mcHeight) {
            y = mcHeight - height;
        }
        if (y < 0) {
            y = 0;
        }
        GuiUtils.drawRect((double)x - offset, y, (double)(x + width) + offset, y + height, backgroundColor);
        GuiUtils.drawRect(x, (double)y - offset, x + width, y, backgroundColor);
        GuiUtils.drawRect(x, y + height, x + width, (double)(y + height) + offset, backgroundColor);
        GuiUtils.drawRect(x, (double)y + offset, (double)x + offset, (double)(y + height) - offset, borderColor);
        GuiUtils.drawRect((double)(x + width) - offset, (double)y + offset, x + width, (double)(y + height) - offset, borderColor);
        GuiUtils.drawRect((double)x + offset, y, x + width, (double)y + offset, borderColor);
        GuiUtils.drawRect((double)x + offset, (double)(y + height) - offset, x + width, y + height, borderColor);
        GuiUtils.drawRect((double)x + offset, (double)y + offset, (double)(x + width) - offset, (double)(y + height) - offset, backgroundColor);
        int i = 0;
        for (String text : texts) {
            if (text != null) {
                GuiUtils.drawStringWithCustomFont(mc, text, (double)x + padding, (double)y + padding + (double)(i * FONT_HEIGHT), Color.white, font, 32);
            }
            ++i;
        }
    }

    public static void renderPlayerHead(String playerName, double xPos, double yPos) {
        GuiUtils.renderPlayerHead(playerName, xPos, yPos, 1.0);
    }

    public static void renderPlayerHead(String playerName, double xPos, double yPos, double size) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(xPos * (1.0 - size)), (double)(yPos * (1.0 - size)), (double)0.0);
        GL11.glScaled((double)size, (double)size, (double)1.0);
        if (playerName.length() > 0) {
            GuiUtils.getDownloadImageHead(GuiUtils.getLocationSkin(playerName + ".png"), playerName);
        }
        GL11.glPushMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiUtils.getLocationSkin(playerName + ".png"));
        GL11.glTranslated((double)xPos, (double)yPos, (double)0.0);
        GL11.glScaled((double)0.75, (double)0.39, (double)0.0);
        double scale = 2.0;
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71456_v.func_73729_b(0, 0, 32, 32, 32, 32);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static ThreadDownloadImageData getDownloadImageHead(ResourceLocation p_110304_0_, String p_110304_1_) {
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        ITextureObject object = texturemanager.func_110581_b(p_110304_0_);
        if (object == null) {
            object = new ThreadDownloadImageData(null, String.format("https://minotar.net/avatar/Kerlann/64.png", StringUtils.func_76338_a((String)p_110304_1_)), null, (IImageBuffer)new ImageBufferDownload(){

                public BufferedImage func_78432_a(BufferedImage image) {
                    return image;
                }
            });
            texturemanager.func_110579_a(p_110304_0_, object);
        }
        return (ThreadDownloadImageData)object;
    }

    public static ResourceLocation getLocationSkin(String p_110311_0_) {
        return new ResourceLocation("ui", "skins/" + StringUtils.func_76338_a((String)p_110311_0_));
    }

    static {
        hovers = new ArrayList<HoverObject>();
    }
}

