/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button;

import fr.minepiece.client.gui.component.AClickableNode;
import fr.minepiece.client.gui.component.NodeUpdate;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.textarea.TextInfo;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiTexturedButton
extends AClickableNode
implements NodeUpdate<GuiTexturedButton> {
    private ResourceLocation texture = null;
    private ResourceLocation hoveredTexture = null;
    private TextInfo textInfo;
    private Consumer<GuiTexturedButton> update;
    private Supplier<? extends Serializable> supplier;

    public GuiTexturedButton(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public GuiTexturedButton(double x, double y, double width, double height, String texture) {
        super(x, y, width, height);
        this.setTexture(texture);
        this.setHoveredTexture(texture + "_hover");
    }

    public GuiTexturedButton(double x, double y, double width, double height, TextInfo textInfo) {
        super(x, y, width, height);
        this.textInfo = textInfo;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public GuiTexturedButton setTexture(String texture) {
        return this.setTexture(new ResourceLocation(texture));
    }

    public GuiTexturedButton setTexture(ResourceLocation texture) {
        this.texture = texture;
        this.hoveredTexture = texture;
        return this;
    }

    public ResourceLocation getHoveredTexture() {
        return this.hoveredTexture;
    }

    public GuiTexturedButton setHoveredTexture(String hoveredTexture) {
        return this.setHoveredTexture(new ResourceLocation(hoveredTexture));
    }

    public GuiTexturedButton setHoveredTexture(ResourceLocation hoveredTexture) {
        this.hoveredTexture = hoveredTexture;
        return this;
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        super.draw(mc, mouseX, mouseY);
        GL11.glPushMatrix();
        if (!this.isEnabled()) {
            GL11.glColor3f((float)0.4f, (float)0.4f, (float)0.4f);
        }
        if (!this.isHovered()) {
            GuiUtils.drawImageTransparent(this.x, this.y, this.texture, this.width, this.height);
        }
        if (this.isEnabled() && this.isHovered()) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawImageTransparent(this.x, this.y, this.hoveredTexture, this.width, this.height);
        }
        if (this.textInfo != null) {
            double scaledDPI = this.textInfo.getScale() * Math.sqrt((double)mc.field_71443_c / 1920.0 * ((double)mc.field_71440_d / 1080.0));
            if (this.textInfo.hasOutline()) {
                GuiUtils.renderCenteredTextScaledWithShadow(this.textInfo.getString(), (int)(this.x + this.width / 2.0), (int)(this.y + this.height / 2.0), this.textInfo.getColor(), scaledDPI);
            } else {
                GuiUtils.renderCenteredTextScaled(this.textInfo.getString(), (int)(this.x + this.width / 2.0), (int)(this.y + this.height / 2.0), this.textInfo.getColor(), scaledDPI);
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void setTextInfo(TextInfo textInfo) {
        this.textInfo = textInfo;
    }

    public TextInfo getTextInfo() {
        return this.textInfo;
    }

    public Supplier<? extends Serializable> getSupplier() {
        return this.supplier;
    }

    public void setSupplier(Supplier<? extends Serializable> supplier) {
        this.supplier = supplier;
    }

    public void setUpdate(Consumer<GuiTexturedButton> update1) {
        this.update = update1;
    }

    @Override
    public Consumer<GuiTexturedButton> getUpdate() {
        return this.update;
    }
}

