/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button;

import fr.minepiece.client.ClientProxy;
import fr.minepiece.client.gui.component.AClickableNode;
import fr.minepiece.client.gui.component.NodeUpdate;
import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.Validator;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.fontv3.IFont;
import fr.minepiece.client.gui.component.textarea.CharacterSet;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiTextField
extends AClickableNode
implements NodeUpdate<GuiTextField> {
    private String text = "";
    private IFont font = ClientProxy.text;
    private int fontSize = 32;
    private Color textColor = Color.WHITE;
    private TextAlign textAlign = TextAlign.LEFT;
    private Color cursorColor = Color.BLACK;
    private boolean multiline = false;
    private boolean focused;
    private Validator validator;
    private double drawX;
    private double targetDrawX;
    private double drawY;
    private double targetDrawY;
    private int cursor;
    private int cursorIndex;
    private int cursorLine;
    private boolean forceCursor;
    private double lineHeight;
    private double fontHeight;
    private long lastDeleted;
    private boolean deleting;
    private int deletingType;
    private int maxStringLength;
    private CharacterSet characterSet;
    private Consumer<GuiTextField> update;

    public GuiTextField(double x, double y, double width, double height) {
        super(x, y, width, height);
    }

    public String getText() {
        return this.text;
    }

    public GuiTextField setText(String text) {
        this.text = text;
        this.cursor = text.length();
        return this;
    }

    public IFont getFont() {
        return this.font;
    }

    public GuiTextField setFont(IFont font) {
        this.font = font;
        return this;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public GuiTextField setFontSize(int fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public GuiTextField setTextColor(Color textColor) {
        this.textColor = textColor;
        return this;
    }

    public TextAlign getTextAlign() {
        return this.textAlign;
    }

    public GuiTextField setTextAlign(TextAlign textAlign) {
        this.textAlign = textAlign;
        return this;
    }

    public Color getCursorColor() {
        return this.cursorColor;
    }

    public GuiTextField setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
        return this;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public GuiTextField setMultiline(boolean multiline) {
        this.multiline = multiline;
        return this;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public GuiTextField setFocused(boolean focused) {
        this.focused = focused;
        return this;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public GuiTextField setValidator(Validator validator) {
        this.validator = validator;
        return this;
    }

    public double getDrawX() {
        return this.drawX;
    }

    public double getTargetDrawX() {
        return this.targetDrawX;
    }

    public double getDrawY() {
        return this.drawY;
    }

    public double getTargetDrawY() {
        return this.targetDrawY;
    }

    public int getCursor() {
        return this.cursor;
    }

    public int getCursorIndex() {
        return this.cursorIndex;
    }

    public int getCursorLine() {
        return this.cursorLine;
    }

    public boolean isForceCursor() {
        return this.forceCursor;
    }

    public long getLastDeleted() {
        return this.lastDeleted;
    }

    public boolean isDeleting() {
        return this.deleting;
    }

    public int getDeletingType() {
        return this.deletingType;
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        if (this.isHovered(mouseX, mouseY) && this.enabled) {
            this.setCursor(mouseX, mouseY);
            if (this.getUi() != null) {
                this.getUi().getComponents().parallelStream().filter(GuiTextField.class::isInstance).forEach(field -> ((GuiTextField)field).setFocused(false));
            }
            this.setFocused(true);
            return true;
        }
        this.setFocused(false);
        return false;
    }

    @Override
    public void fixedUpdate() {
        super.fixedUpdate();
        boolean bl = this.deleting = this.isFocused() && (Keyboard.isKeyDown((int)14) || Keyboard.isKeyDown((int)211));
        if (System.currentTimeMillis() - this.lastDeleted > 500L && this.deleting) {
            this.lastDeleted = System.currentTimeMillis() - 420L;
            StringBuilder newText = new StringBuilder(this.getText());
            this.cursor = Math.max(0, this.cursor + this.deletingType);
            this.forceCursor = true;
            if (newText.length() > (this.deletingType == -1 ? 0 : this.cursor)) {
                newText.deleteCharAt(this.cursor);
            }
            this.text = newText.toString();
        }
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        super.draw(mc, mouseX, mouseY);
        if (this.isMultiline()) {
            List<String> lines = this.getLines();
            int lineIndex = 0;
            int charIndex = 0;
            boolean shouldBreak = false;
            block0: for (int j = 0; j < lines.size(); ++j) {
                String str = lines.get(j);
                if (shouldBreak) break;
                for (int k = 0; k < str.length(); ++k) {
                    if (++charIndex < this.cursor) continue;
                    shouldBreak = true;
                    lineIndex = j;
                    continue block0;
                }
            }
            this.cursorLine = lineIndex;
            int charCount = 0;
            for (int i = 0; i < lineIndex; ++i) {
                charCount += lines.get(i).length();
            }
            this.cursorIndex = this.cursor - charCount;
            double d1 = this.getLineHeight() * (double)this.cursorLine;
            if (this.y - this.targetDrawY + d1 + this.getLineHeight() > this.y + this.height) {
                this.targetDrawY += this.getLineHeight() * 2.0;
            }
            if (this.y - this.targetDrawY + d1 < this.y) {
                this.targetDrawY = d1;
            }
            double diff = this.targetDrawY - this.drawY;
            double absDiff = Math.abs(diff);
            int fps = Integer.parseInt(mc.field_71426_K.split(" fps")[0]);
            double offset = Math.min(2.0, 0.1 / ((double)(fps == 0 ? 1 : fps) / 600.0)) * absDiff / 3.0;
            this.drawY = absDiff > Math.min(2.0, 0.1 / ((double)(fps == 0 ? 1 : fps) / 600.0)) ? (this.drawY += diff > 0.0 ? offset : -offset) : this.targetDrawY;
            GL11.glPushMatrix();
            GL11.glEnable((int)3089);
            GuiUtils.scissor(mc, 0.0, this.y + this.getUi().currentPageScroll, this.ui.field_146294_l, this.height);
            GL11.glTranslated((double)0.0, (double)0.0, (double)this.getZindex());
            GuiUtils.drawSplittedString(mc, this.text, this.x + (this.textAlign == TextAlign.CENTER ? this.width / 2.0 : (this.textAlign == TextAlign.RIGHT ? this.width : 0.0)), this.y - this.drawY, this.textColor, this.font, this.fontSize, this.width, this.textAlign);
            GL11.glDisable((int)3089);
            GL11.glPopMatrix();
        } else {
            String str = this.text;
            double d1 = GuiUtils.getStringWidth(mc, str = this.text.substring(0, Math.min(str.length(), this.cursor + 1)), this.font, this.fontSize);
            if (d1 > this.width) {
                int lastLetter = str.length();
                for (int i = 0; i < str.length(); ++i) {
                    double sectionWidth = GuiUtils.getStringWidth(mc, str.substring(0, i), this.font, this.fontSize);
                    if (!(sectionWidth >= this.width)) continue;
                    lastLetter = i;
                    break;
                }
                this.targetDrawX = d1 - (double)GuiUtils.getStringWidth(mc, str.substring(0, lastLetter), this.font, this.fontSize) + (double)GuiUtils.getStringWidth(mc, str.substring(str.length() - 1), this.font, this.fontSize);
                if (this.textAlign == TextAlign.CENTER) {
                    this.targetDrawX /= 2.0;
                }
            } else {
                this.targetDrawX = 0.0;
            }
            double diff = this.targetDrawX - this.drawX;
            double absDiff = Math.abs(diff);
            int fps = Integer.parseInt(mc.field_71426_K.split(" fps")[0]);
            double offset = Math.min(2.0, 0.1 / (double)(fps == 0 ? 1 : fps) / 600.0) * absDiff / 3.0;
            this.drawX = absDiff > Math.min(2.0, 0.1 / (double)(fps == 0 ? 1 : fps) / 600.0) ? (this.drawX += diff > 0.0 ? offset : -offset) : this.targetDrawX;
            this.cursorLine = 0;
            this.cursorIndex = this.cursor;
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3089);
            GuiUtils.scissor(mc, this.x, this.y + this.getUi().currentPageScroll, this.width, this.height);
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)this.getZindex());
            if (this.textAlign == TextAlign.CENTER) {
                GuiUtils.drawStringWithCustomFont(mc, this.text, this.x + this.width / 2.0 - this.drawX - d1 / 2.0, this.y + this.height / 2.0 - this.getFontHeight() / 2.0, this.textColor, this.font, this.fontSize);
            } else if (this.textAlign == TextAlign.LEFT) {
                GuiUtils.drawStringWithCustomFont(mc, this.text, this.x - this.drawX, this.y + this.height / 2.0 - this.getFontHeight() / 2.0, this.textColor, this.font, this.fontSize);
            } else if (this.textAlign == TextAlign.RIGHT) {
                GuiUtils.drawStringWithCustomFont(mc, this.text, this.x + this.width - d1, this.y + this.height / 2.0 - this.getFontHeight() / 2.0, this.textColor, this.font, this.fontSize);
            }
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        }
        if (!this.isFocused()) {
            return;
        }
        this.forceCursor = false;
        String line = this.text;
        String textForMaths = this.text.substring(0, Math.min(this.text.length(), this.cursor + 1));
        if (this.isMultiline()) {
            List<String> lines = this.getLines();
            line = lines.get(this.cursorLine);
        }
        double strWidth = GuiUtils.getStringWidth(mc, textForMaths, this.font, this.fontSize);
        this.cursor = Math.min(this.text.length(), this.cursor);
        this.cursor = Math.max(0, this.cursor);
        this.cursorIndex = Math.min(line.length(), this.cursorIndex);
        double cursorOffsetX = GuiUtils.getAccurateStringWidth(mc, line.substring(0, this.cursorIndex), this.font, this.fontSize);
        double cursorOffsetY = this.getLineHeight() * (double)this.cursorLine;
        GL11.glTranslated((double)0.0, (double)0.0, (double)this.getZindex());
        if (this.textAlign == TextAlign.CENTER) {
            GuiUtils.drawRect(this.x + this.width / 2.0 - strWidth / 2.0 - this.targetDrawX + cursorOffsetX, this.y - this.targetDrawY + cursorOffsetY + (this.isMultiline() ? 0.0 : this.height / 2.0 - this.getFontHeight() / 2.0), this.x + this.width / 2.0 - strWidth / 2.0 - this.targetDrawX + cursorOffsetX + (double)this.getUi().width(0.1f), this.y - this.targetDrawY + cursorOffsetY + (this.isMultiline() ? 0.0 : this.height / 2.0 - this.getFontHeight() / 2.0) + this.getFontHeight(), this.cursorColor);
        } else if (this.textAlign == TextAlign.LEFT) {
            GuiUtils.drawRect(this.x - this.targetDrawX + cursorOffsetX, this.y - this.targetDrawY + cursorOffsetY + (this.isMultiline() ? 0.0 : this.height / 2.0 - this.getFontHeight() / 2.0), this.x - this.targetDrawX + cursorOffsetX + (double)this.getUi().width(0.1f), this.y - this.targetDrawY + cursorOffsetY + (this.isMultiline() ? 0.0 : this.height / 2.0 - this.getFontHeight() / 2.0) + this.getFontHeight(), this.cursorColor);
        } else if (this.textAlign == TextAlign.RIGHT) {
            GuiUtils.drawRect(this.x + this.width - strWidth - this.targetDrawX + cursorOffsetX, this.y - this.targetDrawY + cursorOffsetY + (this.isMultiline() ? 0.0 : this.height / 2.0 - this.getFontHeight() / 2.0), this.x + this.width - strWidth - this.targetDrawX + cursorOffsetX + (double)this.getUi().width(0.1f), this.y - this.targetDrawY + cursorOffsetY + (this.isMultiline() ? 0.0 : this.height / 2.0 - this.getFontHeight() / 2.0) + this.getFontHeight(), this.cursorColor);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void onKeyTyped(char c, int key) {
        if (!this.isFocused() || !this.isEnabled()) {
            return;
        }
        if (!this.isValidInput(c) && key != 14 && key != 211 && key != 203 && key != 205 && key != 200 && key != 208 && key != 28 && !Keyboard.isKeyDown((int)29)) {
            return;
        }
        StringBuilder newText = new StringBuilder(this.getText());
        int prevCursor = this.cursor;
        block0 : switch (key) {
            case 14: {
                if (newText.length() > 0) {
                    this.cursor = Math.max(0, this.cursor - 1);
                    if (Keyboard.isKeyDown((int)29)) {
                        boolean foundSpace = false;
                        boolean foundBreak = false;
                        for (int i = this.cursor; i > 0; --i) {
                            if (newText.charAt(i) == ' ') {
                                int newCursor = i == this.cursor ? i : i + 1;
                                newText.delete(newCursor, this.cursor + 1);
                                this.cursor = newCursor;
                                foundSpace = true;
                                break;
                            }
                            if (newText.charAt(i) != '\n') continue;
                            int newCursor = i == this.cursor ? i : i + 1;
                            newText.delete(newCursor, this.cursor + 1);
                            this.cursor = newCursor;
                            foundBreak = true;
                            break;
                        }
                        if (!foundSpace && !foundBreak) {
                            newText.delete(0, this.cursor + 1);
                        }
                    } else {
                        newText.deleteCharAt(this.cursor);
                    }
                }
                this.lastDeleted = System.currentTimeMillis();
                this.deleting = true;
                this.deletingType = -1;
                break;
            }
            case 211: {
                if (newText.length() > this.cursor) {
                    newText.deleteCharAt(this.cursor);
                }
                this.lastDeleted = System.currentTimeMillis();
                this.deleting = true;
                this.deletingType = 0;
                break;
            }
            case 203: {
                this.cursor = Math.max(0, this.cursor - 1);
                if (!Keyboard.isKeyDown((int)29)) break;
                boolean foundSpace = false;
                boolean foundBreak = false;
                for (int i = this.cursor; i > 0; --i) {
                    int newCursor;
                    if (newText.charAt(i) == ' ') {
                        int newCursor2;
                        this.cursor = newCursor2 = i == this.cursor ? i : i + 1;
                        foundSpace = true;
                        break;
                    }
                    if (newText.charAt(i) != '\n') continue;
                    this.cursor = newCursor = i == this.cursor ? i : i + 1;
                    foundBreak = true;
                    break;
                }
                if (foundSpace || foundBreak) break;
                this.cursor = 0;
                break;
            }
            case 205: {
                this.cursor = Math.min(newText.length(), this.cursor + 1);
                if (!Keyboard.isKeyDown((int)29)) break;
                boolean foundSpace = false;
                boolean foundBreak = false;
                for (int i = this.cursor; i < newText.length(); ++i) {
                    int newCursor;
                    if (newText.charAt(i) == ' ') {
                        int newCursor3;
                        this.cursor = newCursor3 = i == this.cursor ? i : i + 1;
                        foundSpace = true;
                        break;
                    }
                    if (newText.charAt(i) != '\n') continue;
                    this.cursor = newCursor = i == this.cursor ? i : i + 1;
                    foundBreak = true;
                    break;
                }
                if (foundSpace || foundBreak) break;
                this.cursor = newText.length();
                break;
            }
            case 200: {
                this.setCursor(this.cursorLine - 1, this.cursorIndex);
                break;
            }
            case 208: {
                this.setCursor(this.cursorLine + 1, this.cursorIndex);
                break;
            }
            case 28: {
                if (!this.isMultiline()) break;
                newText.insert(this.cursor, '\n');
                this.cursor = Math.min(newText.length(), this.cursor + 1);
                break;
            }
            default: {
                if (key == 47 && Keyboard.isKeyDown((int)29)) {
                    String clipboard = GuiScreen.func_146277_j();
                    if (clipboard == null || clipboard.isEmpty() || newText.length() + clipboard.length() > this.maxStringLength) break;
                    for (char c1 : clipboard.toCharArray()) {
                        if (!this.isValidInput(c1)) break block0;
                    }
                    newText.append(clipboard);
                    this.cursor += clipboard.length();
                    break;
                }
                if (!this.isValidInput(c)) break;
                newText.insert(this.cursor, c);
                this.cursor = Math.min(newText.length(), this.cursor + 1);
            }
        }
        if (!this.isValidText(newText.toString())) {
            this.cursor = prevCursor;
            return;
        }
        this.text = newText.toString();
        this.forceCursor = true;
    }

    private boolean isCharInSet(char character) {
        if (this.characterSet != null && this.characterSet.getChars() != null) {
            char[] chars;
            for (char validChar : chars = this.characterSet.getChars()) {
                if (character != validChar) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getLines() {
        if (!this.isMultiline()) {
            return Arrays.asList(this.text);
        }
        return GuiUtils.getSplittedString(Minecraft.func_71410_x(), this.text, this.font, this.fontSize, this.width);
    }

    public void setCursor(int lineIndex, int charIndex) {
        List<String> lines;
        if (lineIndex < 0) {
            lineIndex = 0;
        }
        if (lineIndex > (lines = this.getLines()).size() - 1) {
            lineIndex = lines.size();
        }
        int c = 0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            for (int j = 0; j < line.length(); ++j) {
                if (i == lineIndex) {
                    if (charIndex >= line.length() - 1) {
                        charIndex = line.length() - 1;
                    }
                    if (charIndex < 0) {
                        charIndex = 0;
                    }
                    if (j == charIndex) {
                        this.cursor = c;
                        this.forceCursor = true;
                        return;
                    }
                }
                ++c;
            }
        }
    }

    public void setCursor(double mouseX, double mouseY) {
        if (mouseX < this.x || mouseX > this.x + this.width || mouseY < this.y || mouseY > this.y + this.height) {
            return;
        }
        List<String> lines = this.getLines();
        int c = 0;
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            double charY = this.y - this.drawY + (this.isMultiline() ? this.getLineHeight() * (double)i : this.height / 2.0 - this.getLineHeight() / 2.0);
            for (int j = 0; j < line.length(); ++j) {
                double charX = this.x - this.drawX + GuiUtils.getAccurateStringWidth(Minecraft.func_71410_x(), line.substring(0, j), this.font, this.fontSize);
                if (charY < mouseY && charY + this.getLineHeight() > mouseY && (charX >= mouseX || j == line.length() - 1)) {
                    this.cursor = c;
                    this.forceCursor = true;
                    return;
                }
                ++c;
            }
        }
    }

    public double getLineHeight() {
        if (this.lineHeight == 0.0) {
            this.lineHeight = GuiUtils.getFontHeight(Minecraft.func_71410_x(), this.font, this.fontSize + 20);
        }
        return this.lineHeight;
    }

    public double getFontHeight() {
        if (this.fontHeight == 0.0) {
            this.fontHeight = GuiUtils.getFontHeight(Minecraft.func_71410_x(), this.font, this.fontSize);
        }
        return this.fontHeight;
    }

    public boolean isValidInput(char c) {
        return this.text.length() < this.maxStringLength && this.isCharInSet(c) && ChatAllowedCharacters.func_71566_a((char)c);
    }

    public boolean isValidText(String text) {
        if (text == null) {
            return false;
        }
        if (this.validator != null && text.length() > 0) {
            return this.validator.isValid(text, true);
        }
        return true;
    }

    @Deprecated
    public GuiTextField setFontName(IFont font) {
        this.font = font;
        return this;
    }

    public int getMaxStringLength() {
        return this.maxStringLength;
    }

    public void setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
    }

    public CharacterSet getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(CharacterSet characterSet) {
        this.characterSet = characterSet;
    }

    @Override
    public Consumer<GuiTextField> getUpdate() {
        return this.update;
    }

    public void setUpdate(Consumer<GuiTextField> update) {
        this.update = update;
    }
}

