/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button;

import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.button.GuiTextField;
import fr.minepiece.client.gui.component.button.GuiUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public class GuiMinecraftTextField
extends GuiTextField {
    private static final Color COLOR = Color.decode("#592121");
    private ResourceLocation icon;
    private String placeholder;

    public GuiMinecraftTextField(double x, double y, double width) {
        super(x, y, width, GuiUtils.height(3.9814));
        this.setCursorColor(Color.RED);
        this.setTextColor(Color.YELLOW);
        this.setX(x + this.defaultWidth * (double)0.02f);
        this.setWidth(this.defaultWidth * (double)0.96f);
        this.setFontSize(8);
        this.setTextAlign(TextAlign.LEFT);
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        GuiUtils.drawRect(this.defaultX, this.defaultY, this.defaultX + this.defaultWidth, this.defaultY + this.defaultHeight, COLOR);
        GuiUtils.drawBorder(this.defaultX, this.defaultY, this.defaultX + this.defaultWidth, this.defaultY + this.defaultHeight, this.isFocused() ? Color.WHITE : COLOR, this.width(1.04167));
        if (this.getText().isEmpty() && this.placeholder != null) {
            GuiUtils.drawStringWithCustomFont(mc, this.placeholder, this.x, this.defaultY + (double)this.height(50.0f) - this.getFontHeight() / 2.0, Color.BLACK, this.getFont(), this.getFontSize());
        }
        if (this.icon != null) {
            double iconSize = this.height(60.0f);
            GuiUtils.drawImageTransparent(this.defaultX + this.defaultWidth * (double)0.02f, this.defaultY + this.height / 2.0 - iconSize / 2.0, this.icon, iconSize, iconSize);
        }
        super.draw(mc, mouseX, mouseY);
    }

    public GuiMinecraftTextField setIcon(ResourceLocation icon) {
        if (icon != null) {
            this.setX(this.x + this.defaultWidth * (double)0.1f);
            this.setWidth(this.defaultWidth * (double)0.8f);
        } else {
            this.setX(this.x + this.defaultWidth * (double)0.02f);
            this.setWidth(this.defaultWidth * (double)0.96f);
        }
        this.icon = icon;
        return this;
    }

    public GuiMinecraftTextField setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }
}

