/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button;

import fr.minepiece.client.gui.component.AClickableNode;
import fr.minepiece.client.gui.component.FlexDirection;
import fr.minepiece.client.gui.component.FlexNode;
import fr.minepiece.client.gui.component.TextAlign;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.fontv3.Lang;
import fr.minepiece.client.gui.component.fontv3.TextFont;
import fr.minepiece.client.gui.component.textarea.GuiTextLabel;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;

public abstract class GuiASelector
extends FlexNode {
    private boolean active;
    private ASelector selected;
    private final List<ASelector> selectors = new LinkedList<ASelector>();

    public GuiASelector(double x, double y, double width) {
        super(x, y, width, 2.95f, FlexDirection.COLUMN);
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        if (this.getChildren().isEmpty() && !this.selectors.isEmpty()) {
            if (this.selected == null) {
                this.selected = this.selectors.get(0);
            }
            this.addChild(this.selected);
        }
        super.draw(mc, mouseX, mouseY);
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        if (!this.isHovered(mouseX, mouseY)) {
            this.setActive(false);
        }
        return false;
    }

    public boolean isActive() {
        return this.active;
    }

    public GuiASelector setActive(boolean active) {
        this.active = active;
        this.children.clear();
        if (active) {
            this.addChild(this.selected);
            this.selectors.stream().filter(s -> s != this.selected).forEachOrdered(this::addChild);
        }
        return this;
    }

    public List<ASelector> getSelectors() {
        return this.selectors;
    }

    public ASelector getSelected() {
        return this.selected;
    }

    public GuiASelector setSelected(ASelector selected) {
        this.selected = selected;
        return this;
    }

    public void addSelector(ASelector selector) {
        this.selectors.add(selector);
    }

    public static class SelectorItem {
        private final ResourceLocation texture;
        private final String name;
        private final String hover;

        public SelectorItem(ResourceLocation texture, String name, String hover) {
            this.texture = texture;
            this.name = name;
            this.hover = hover;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public String getName() {
            return this.name;
        }

        public String getHover() {
            return this.hover;
        }
    }

    public static class ASelector
    extends AClickableNode {
        private final GuiASelector selector;
        private final SelectorItem item;

        public ASelector(GuiASelector selector, SelectorItem item) {
            super(0.0, 0.0, selector.getWidth(), GuiUtils.height(6.0f));
            this.selector = selector;
            this.item = item;
            GuiTextLabel text = new GuiTextLabel(selector.getWidth() / 2.0 - (double)this.width(15), this.height(40.0), item.getName().toUpperCase(), new TextFont("greycliff.ttf", 32, 0.0f, 0.0f, 0.0f, Lang.FR), 32, Color.WHITE);
            text.setTextAlign(TextAlign.CENTER);
            this.addChild(text);
            if (item.getHover() != null && !item.getHover().isEmpty()) {
                this.addHover(item.getHover());
            }
        }

        public GuiASelector getSelector() {
            return this.selector;
        }

        public SelectorItem getItem() {
            return this.item;
        }

        @Override
        public void draw(Minecraft mc, int mouseX, int mouseY) {
            super.draw(mc, mouseX, mouseY);
            if (this.item.getTexture() != null) {
                if (!this.selector.isActive() || this.selector.selected == this) {
                    GuiUtils.drawImageTransparent(this.x, this.y, this.item.getTexture(), this.width, this.height, false);
                } else {
                    GuiUtils.drawImageTransparent(this.x, this.y, this.item.getTexture(), this.width, this.height, false);
                }
            }
        }

        public void drawBackground(Minecraft mc, int mouseX, int mouseY) {
        }

        @Override
        public boolean onClick(int mouseX, int mouseY, int mouseButton) {
            if (this.isHovered(mouseX, mouseY) && this.enabled) {
                if (this.selector.selected == this && !this.selector.isActive()) {
                    this.selector.setSelected(this);
                    this.selector.setActive(true);
                    return true;
                }
                if (this.selector.isActive()) {
                    this.selector.setSelected(this);
                    this.selector.setActive(false);
                }
            }
            return super.onClick(mouseX, mouseY, mouseButton);
        }
    }
}

