/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component.button;

import fr.minepiece.client.gui.component.AbstractUI;
import fr.minepiece.client.gui.component.NodeUpdate;
import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.GuiTextLine;
import fr.minepiece.client.gui.component.button.GuiUtils;
import fr.minepiece.client.gui.component.button.scroll.GuiScrollButton;
import fr.minepiece.client.gui.component.button.scroll.ScrollableArea;
import fr.minepiece.client.gui.component.fontv3.IFont;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiAPI
extends AbstractUI {
    private ScrollableArea focusedScrollArea;
    private GuiScrollButton activeScroll;
    private List<ScrollableArea> areas;
    private Minecraft minecraft = Minecraft.func_71410_x();

    public GuiAPI() {
    }

    public GuiAPI(GuiScreen prev, String name) {
        super(prev, name);
    }

    @Override
    public void func_73866_w_() {
        this.focusedScrollArea = null;
        this.activeScroll = null;
        this.areas = new ArrayList<ScrollableArea>();
        super.func_73866_w_();
    }

    public void func_146274_d() throws IOException {
        double mult;
        if (this.popup != null) {
            this.popup.func_146274_d();
            return;
        }
        super.func_146274_d();
        int k = Mouse.getEventDWheel();
        if (this.isFullScreen()) {
            int i = 2;
            double heightRatio = this.getHeight() / 1080.0;
            this.pageScroll += k < 0 ? -50 / i : (k > 0 ? 50 / i : 0);
            this.pageScroll = (int)Math.max(-((double)this.field_146295_m * heightRatio - (double)this.field_146295_m - 1.0), (double)Math.min(0, this.pageScroll));
        }
        if (this.focusedScrollArea == null) {
            return;
        }
        if (!this.focusedScrollArea.isCanScroll()) {
            return;
        }
        double scroll = this.focusedScrollArea.getScroll();
        int scale = new ScaledResolution(this.field_146297_k).func_78325_e();
        double d = mult = Keyboard.isKeyDown((int)29) ? 3.0 : 1.0;
        scroll += k < 0 ? -((double)this.focusedScrollArea.getScrollSpeed() * mult) / (double)scale : (k > 0 ? (double)this.focusedScrollArea.getScrollSpeed() * mult / (double)scale : 0.0);
        scroll = Math.min(0.0, scroll);
        scroll = Math.max(scroll, -this.focusedScrollArea.getMaxScroll());
        this.focusedScrollArea.setScroll(scroll);
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int buttonID) throws IOException {
        super.func_73864_a(mouseX, mouseY, buttonID);
        if (this.popup != null) {
            return;
        }
        this.doNodeUpdates();
        this.activeScroll = this.getComponents().stream().filter(GuiScrollButton.class::isInstance).map(GuiScrollButton.class::cast).filter(GuiComponent::isHovered).findFirst().orElse(null);
        if (this.activeScroll != null && this.activeScroll.getArea().isCanScroll()) {
            this.activeScroll.getArea().setCursorScrolling(true);
        }
    }

    private void doNodeUpdates() {
        Queue<GuiComponent> components = this.getComponents();
        for (GuiComponent component : components) {
            this.doNodeUpdate(component);
        }
    }

    private void doNodeUpdate(GuiComponent component) {
        NodeUpdate nodeUpdate;
        Consumer<NodeUpdate> update;
        if (component instanceof NodeUpdate && (update = (nodeUpdate = (NodeUpdate)((Object)component)).getUpdate()) != null) {
            update.accept(nodeUpdate);
        }
        for (GuiComponent child : component.getChildren()) {
            this.doNodeUpdate(child);
        }
    }

    @Override
    public void func_146286_b(int mouseX, int mouseY, int buttonID) {
        super.func_146286_b(mouseX, mouseY, buttonID);
        if (this.popup != null) {
            return;
        }
        if (this.activeScroll != null) {
            this.activeScroll.getArea().setCursorScrolling(false);
            this.activeScroll = null;
        }
    }

    protected void func_146273_a(int mouseX, int mouseY, int buttonID, long ticks) {
        if (this.popup == null) {
            if (this.activeScroll != null && this.activeScroll.getArea().isCanScroll()) {
                GuiScrollButton node = this.activeScroll;
                double scrollPercent = (double)((int)((double)mouseY - this.currentPageScroll)) - node.getDefaultY();
                scrollPercent /= node.getArea().getScrollArea().getHeight();
                scrollPercent *= 100.0;
                double scroll = -node.getArea().getMaxScroll() / 100.0 * scrollPercent;
                if (scroll > 0.1) {
                    scroll = 0.0;
                }
                if (scroll < -node.getArea().getMaxScroll()) {
                    scroll = -node.getArea().getMaxScroll();
                }
                node.getArea().setScroll(scroll);
            }
            super.func_146273_a(mouseX, (int)((double)mouseY - this.currentPageScroll), buttonID, ticks);
        } else {
            this.popup.func_146273_a(mouseX, (int)((double)mouseY - this.currentPageScroll), buttonID, ticks);
        }
    }

    @Override
    @Deprecated
    public void func_73863_a(int scaledMouseX, int scaledMouseY, float ticks) {
        int mouseX = Mouse.getX();
        int mouseY = this.field_146297_k.field_71440_d - Mouse.getY();
        if (this.isFullScreen()) {
            int fps = Integer.parseInt(this.field_146297_k.field_71426_K.split(" fps")[0]);
            double diff = (double)this.pageScroll - this.currentPageScroll;
            double absDiff = Math.abs(diff);
            double offset = 0.2 / (double)((float)(fps == 0 ? 1 : fps) / 60.0f) * absDiff / 3.0;
            this.currentPageScroll = absDiff > 0.2 ? (this.currentPageScroll += diff > 0.0 ? offset : -offset) : (double)this.pageScroll;
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Minecraft.func_71410_x().field_71443_c, (double)Minecraft.func_71410_x().field_71440_d, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GuiUtils.hovers.clear();
        GL11.glPushMatrix();
        if (this.isFullScreen()) {
            GL11.glTranslated((double)0.0, (double)this.currentPageScroll, (double)0.0);
        }
        this.getComponents().stream().filter(node -> node.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(node -> this.drawNode((GuiComponent)node, this.field_146297_k, mouseX, (int)((double)mouseY - this.currentPageScroll)));
        this.drawBackground(mouseX, mouseY, ticks);
        if (this.isFullScreen()) {
            GL11.glTranslated((double)0.0, (double)(-this.currentPageScroll), (double)0.0);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (!this.isLoaded()) {
            this.focusedScrollArea = null;
            this.activeScroll = null;
            this.areas = new ArrayList<ScrollableArea>();
        }
        for (ScrollableArea area : this.areas) {
            double diff;
            double scroll = area.getScroll();
            double maxScroll = area.getMaxScroll();
            if (scroll > 0.1) {
                diff = Math.abs(0.0 - Math.abs(scroll));
                scroll -= (double)(area.getScrollSpeed() / 50) * Math.max(10.0, diff);
            }
            if (scroll < -maxScroll) {
                diff = Math.abs(Math.abs(maxScroll) - Math.abs(scroll));
                scroll += (double)(area.getScrollSpeed() / 50) * Math.max(10.0, diff);
            }
            Stream<GuiComponent> hide = this.getComponents().parallelStream().filter(node -> node.getArea() != null).filter(GuiComponent::isSolid).filter(node -> node.getArea().equals(area)).filter(node -> !node.getArea().inCompleteArea(node.x, node.defaultY, node.width, node.height));
            long hiddenCount = this.getComponents().parallelStream().filter(node -> node.getArea() != null).filter(GuiComponent::isSolid).filter(node -> node.getArea().equals(area)).filter(node -> !node.getArea().inCompleteArea(node.x, node.defaultY, node.width, node.height)).count();
            long presentCount = this.getComponents().parallelStream().filter(node -> node.getArea() != null).filter(GuiComponent::isSolid).filter(node -> node.getArea().equals(area)).filter(node -> node.getArea().inCompleteArea(node.x, node.defaultY, node.width, node.height)).count();
            if (hiddenCount <= 0L) {
                area.setCanScroll(false);
                scroll = 0.0;
            } else {
                GuiComponent lastHidden = hide.skip(hiddenCount - 1L).findFirst().orElse(null);
                assert (lastHidden != null);
                maxScroll = lastHidden.getDefaultY() - lastHidden.getArea().getMinY() + lastHidden.height - (double)presentCount * lastHidden.height;
                area.setCanScroll(true);
            }
            area.setScroll(scroll);
            area.setMaxScroll(maxScroll);
        }
        boolean foundScrollArea = false;
        for (GuiComponent node2 : this.getComponents()) {
            if (node2.getArea() == null) continue;
            ScrollableArea area = node2.getArea();
            node2.setScroll(area.getScroll());
            if (!area.inArea(mouseX, (double)mouseY - this.currentPageScroll)) continue;
            this.focusedScrollArea = area;
            foundScrollArea = true;
        }
        this.getComponents().stream().filter(GuiScrollButton.class::isInstance).map(GuiScrollButton.class::cast).forEach(wButton -> {
            double maxY = wButton.getDefaultY() + wButton.getArea().getScrollArea().getHeight() - wButton.height;
            double p = wButton.getArea().getScroll() / wButton.getArea().getMaxScroll() * 100.0;
            double y = wButton.getDefaultY() - (wButton.getArea().getScrollArea().getHeight() - wButton.height) / 100.0 * p;
            y = Math.min(y, maxY);
            y = Math.max(y, wButton.getDefaultY());
            wButton.setY(y);
        });
        if (!foundScrollArea && this.areas.size() > 1) {
            this.focusedScrollArea = null;
        }
        if (this.areas.size() == 1) {
            this.focusedScrollArea = this.areas.get(0);
        }
        GL11.glPushMatrix();
        if (this.isFullScreen()) {
            GL11.glTranslated((double)0.0, (double)this.currentPageScroll, (double)0.0);
        }
        this.getComponents().stream().filter(node -> node.getZindex() >= 0 && node.getZindex() < 100).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(node -> this.drawNode((GuiComponent)node, this.field_146297_k, mouseX, (int)((double)mouseY - this.currentPageScroll)));
        this.postDraw(mouseX, mouseY, ticks);
        this.getComponents().stream().filter(node -> node.getZindex() >= 100).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(node -> this.drawNode((GuiComponent)node, this.field_146297_k, mouseX, (int)((double)mouseY - this.currentPageScroll)));
        this.getComponents().stream().filter(component -> component.hovered).filter(component -> component.getTooltipsText() != null).forEach(component -> this.drawHoveringText(Arrays.asList(component.getTooltipsText().split("\n")), mouseX, mouseY, this.width(1.0f) / 6.0f));
        if (this.isFullScreen()) {
            GL11.glTranslated((double)0.0, (double)(-this.currentPageScroll), (double)0.0);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.func_73863_a(mouseX, mouseY, ticks);
    }

    private void drawNode(GuiComponent node, Minecraft mc, int mouseX, int mouseY) {
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (node.getParent() != null) {
            GL11.glTranslated((double)node.getParent().getX(), (double)node.getParent().getY(), (double)0.0);
        }
        if (node.getArea() != null && !(node instanceof GuiScrollButton)) {
            ScrollableArea area = node.getArea();
            boolean drawing = !(node.getAbsoluteX() + node.getWidth() < area.getMinX() || node.getAbsoluteY() + node.getHeight() < area.getMinY() || node.getAbsoluteX() > area.getMaxX() || node.getAbsoluteY() > area.getMaxY());
            GL11.glEnable((int)3089);
            GuiUtils.scissor(mc, area.getMinX(), area.getMinY(), area.getMaxX() - area.getMinX(), area.getMaxY() - area.getMinY());
            node.update(mc, mouseX, mouseY);
            if (node.isVisible() && drawing) {
                node.getChildren().stream().filter(child -> child.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.drawNode((GuiComponent)child, mc, mouseX, mouseY));
                node.draw(mc, mouseX, mouseY);
                node.getChildren().stream().filter(child -> child.getZindex() >= 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.drawNode((GuiComponent)child, mc, mouseX, mouseY));
            }
            GL11.glDisable((int)3089);
        } else {
            node.update(mc, mouseX, mouseY);
            if (node.isVisible()) {
                node.getChildren().stream().filter(child -> child.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.drawNode((GuiComponent)child, mc, mouseX, mouseY));
                node.draw(mc, mouseX, mouseY);
                node.getChildren().stream().filter(child -> child.getZindex() >= 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.drawNode((GuiComponent)child, mc, mouseX, mouseY));
            }
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
    }

    public void addScrollableArea(ScrollableArea area) {
        this.areas.add(area);
        this.addComponent(area.createScrollBar());
    }

    public void addScrollableText(String text, ScrollableArea area, double x, double y, double maxWidth, Color color, IFont font) {
        this.addScrollableArea(area);
        int fontHeight = GuiUtils.getFontHeight(this.field_146297_k, font, 80);
        List<String> texts = GuiUtils.getSplittedString(this.field_146297_k, text, font, 80, maxWidth);
        for (int i = 0; i < texts.size(); ++i) {
            int width = GuiUtils.getStringWidth(this.field_146297_k, texts.get(i), font, 60);
            this.addComponent(new GuiTextLine(x, y + (double)((fontHeight + 1) * i), width, fontHeight, texts.get(i), color, font, 60));
        }
    }

    @Override
    public void drawDebug() {
        this.areas.forEach(area -> GuiUtils.drawBorder(area.getMinX(), area.getMinY(), area.getMaxX(), area.getMaxY(), new Color(47, 54, 64)));
        this.areas.forEach(area -> GuiUtils.drawBorder(area.getScrollArea().getX(), area.getScrollArea().getY(), area.getScrollArea().getX() + area.getScrollArea().getButtonWidth(), area.getScrollArea().getY() + area.getScrollArea().getHeight(), new Color(39, 60, 117)));
        super.drawDebug();
    }

    public boolean isFullScreen() {
        return false;
    }

    public double getHeight() {
        return 1080.0;
    }

    protected void drawHoveringText(List<String> textLines, int mouseX, int mouseY, float scale) {
        if (!textLines.isEmpty()) {
            int screenWidth = this.field_146297_k.field_71443_c;
            int screenHeight = this.field_146297_k.field_71440_d;
            FontRenderer font = this.field_146297_k.field_71466_p;
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            int tooltipTextWidth = 0;
            for (String textLine : textLines) {
                int textLineWidth = font.func_78256_a(textLine);
                if (textLineWidth <= tooltipTextWidth) continue;
                tooltipTextWidth = textLineWidth;
            }
            boolean needsWrap = false;
            int titleLinesCount = 1;
            int tooltipX = mouseX + 12;
            if (tooltipX + tooltipTextWidth + 4 > screenWidth && (tooltipX = mouseX - 16 - tooltipTextWidth) < 4) {
                tooltipTextWidth = mouseX > screenWidth / 2 ? mouseX - 12 - 8 : screenWidth - 16 - mouseX;
                needsWrap = true;
            }
            if (needsWrap) {
                int wrappedTooltipWidth = 0;
                ArrayList<String> wrappedTextLines = new ArrayList<String>();
                for (int i = 0; i < textLines.size(); ++i) {
                    String textLine = textLines.get(i);
                    List wrappedLine = font.func_78271_c(textLine, tooltipTextWidth);
                    if (i == 0) {
                        titleLinesCount = wrappedLine.size();
                    }
                    for (String line : wrappedLine) {
                        int lineWidth = font.func_78256_a(line);
                        if (lineWidth > wrappedTooltipWidth) {
                            wrappedTooltipWidth = lineWidth;
                        }
                        wrappedTextLines.add(line);
                    }
                }
                tooltipTextWidth = wrappedTooltipWidth;
                textLines = wrappedTextLines;
                tooltipX = mouseX > screenWidth / 2 ? mouseX - 16 - tooltipTextWidth : mouseX + 12;
            }
            tooltipTextWidth = (int)((float)tooltipTextWidth * scale);
            int tooltipY = mouseY - 12;
            int tooltipHeight = 8;
            if (textLines.size() > 1) {
                tooltipHeight += (textLines.size() - 1) * 10;
                if (textLines.size() > titleLinesCount) {
                    tooltipHeight += 2;
                }
            }
            tooltipHeight = (int)((float)tooltipHeight * scale);
            if (tooltipY < 4) {
                tooltipY = 4;
            } else if (tooltipY + tooltipHeight + 4 > screenHeight) {
                tooltipY = screenHeight - tooltipHeight - 4;
            }
            int zLevel = 300;
            int backgroundColor = -267386864;
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiAPI.drawGradientRect(300, tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor);
            GuiAPI.drawGradientRect(300, tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor);
            GuiAPI.drawGradientRect(300, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            GuiAPI.drawGradientRect(300, tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            GuiAPI.drawGradientRect(300, tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor);
            GuiAPI.drawGradientRect(300, tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            GuiAPI.drawGradientRect(300, tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, borderColorStart, borderColorEnd);
            GuiAPI.drawGradientRect(300, tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, borderColorStart, borderColorStart);
            GuiAPI.drawGradientRect(300, tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, borderColorEnd, borderColorEnd);
            int tooltipTop = tooltipY;
            for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
                String line = textLines.get(lineNumber);
                GuiUtils.renderTextScaled(line, tooltipX, tooltipY, -1, scale);
                if (lineNumber + 1 == titleLinesCount) {
                    tooltipY += 2;
                }
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
        }
    }

    public static void drawGradientRect(int zLevel, int left, int top, int right, int bottom, int startColor, int endColor) {
        float startAlpha = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(startColor & 0xFF) / 255.0f;
        float endAlpha = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b((double)right, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)top, (double)zLevel).func_181666_a(startRed, startGreen, startBlue, startAlpha).func_181675_d();
        buffer.func_181662_b((double)left, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        buffer.func_181662_b((double)right, (double)bottom, (double)zLevel).func_181666_a(endRed, endGreen, endBlue, endAlpha).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }
}

