/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component;

import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class Validator {
    private final boolean nullable;
    private final int lengthMin;
    private final int lengthMax;
    private final String pattern;
    private final List<String> banList;
    private transient Pattern builtPattern;

    public Validator(boolean nullable, int lengthMin, int lengthMax, String pattern, List<String> banList, Pattern builtPattern) {
        this.nullable = nullable;
        this.lengthMin = lengthMin;
        this.lengthMax = lengthMax;
        this.pattern = pattern;
        this.banList = banList;
        this.builtPattern = builtPattern;
    }

    public Validator(int lengthMin, int lengthMax, String pattern, List<String> banList) {
        this(false, lengthMin, lengthMax, pattern, banList);
    }

    public Validator(boolean nullable, int lengthMin, int lengthMax, String pattern, List<String> banList) {
        this.nullable = nullable;
        this.lengthMin = lengthMin;
        this.lengthMax = lengthMax;
        this.pattern = pattern;
        this.banList = banList;
    }

    public boolean equals(Object o) {
        List<String> other$banList;
        String other$pattern;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Validator)) {
            return false;
        }
        Validator other = (Validator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNullable() != other.isNullable()) {
            return false;
        }
        if (this.getLengthMin() != other.getLengthMin()) {
            return false;
        }
        if (this.getLengthMax() != other.getLengthMax()) {
            return false;
        }
        String this$pattern = this.getPattern();
        if (!Objects.equals(this$pattern, other$pattern = other.getPattern())) {
            return false;
        }
        List<String> this$banList = this.getBanList();
        return Objects.equals(this$banList, other$banList = other.getBanList());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Validator;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public int getLengthMin() {
        return this.lengthMin;
    }

    public int getLengthMax() {
        return this.lengthMax;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getBanList() {
        return this.banList;
    }

    public Pattern getBuiltPattern() {
        return this.builtPattern;
    }

    public boolean check(String name) {
        return this.check(name, false);
    }

    public boolean check(String name, boolean isTextField) {
        if (!this.nullable && (name == null || name.isEmpty())) {
            return false;
        }
        if (name.length() < this.lengthMin && !isTextField || name.length() > this.lengthMax) {
            return false;
        }
        if (this.banList != null && this.banList.contains(name.toLowerCase())) {
            return false;
        }
        if (this.builtPattern == null) {
            this.builtPattern = Pattern.compile(this.pattern);
        }
        return this.builtPattern.matcher(name).matches();
    }

    public abstract boolean isValid(String var1);

    public abstract boolean isValid(String var1, boolean var2);
}

