/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component;

import fr.minepiece.client.gui.component.FlexDirection;
import fr.minepiece.client.gui.component.button.GuiComponent;
import net.minecraft.client.Minecraft;

public class FlexNode
extends GuiComponent {
    private final FlexDirection direction;
    private double margin;

    public FlexNode(double x, double y, double width, double height, FlexDirection direction) {
        super(x, y, width, height);
        this.direction = direction;
    }

    public static FlexNode vertical(double x, double y, double width) {
        return new FlexNode(x, y, width, 0.0, FlexDirection.COLUMN);
    }

    public static FlexNode horizontal(double x, double y, double height) {
        return new FlexNode(x, y, 0.0, height, FlexDirection.ROW);
    }

    @Override
    public void draw(Minecraft mc, int mouseX, int mouseY) {
        super.draw(mc, mouseX, mouseY);
        if (this.direction == FlexDirection.COLUMN) {
            double offsetY = 0.0;
            for (GuiComponent node : this.children) {
                node.y = node.defaultY + offsetY;
                offsetY += node.height + this.margin;
            }
            this.height = offsetY;
        } else if (this.direction == FlexDirection.ROW) {
            double offsetX = 0.0;
            for (GuiComponent node : this.children) {
                node.x = node.defaultX + offsetX;
                offsetX += node.width + this.margin;
            }
            this.width = offsetX;
        }
    }

    public FlexNode setMargin(double margin) {
        this.margin = margin;
        return this;
    }

    @Override
    public boolean onClick(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    @Override
    public void fixedUpdate() {
    }

    @Override
    public void onRelease(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void onKeyTyped(char c, int key) {
    }

    @Override
    public void onHover(int mouseX, int mouseY) {
    }

    @Override
    public void onHoverOut(int mouseX, int mouseY) {
    }
}

