/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.gui.component;

import com.google.common.collect.Queues;
import fr.minepiece.client.gui.component.UIPopup;
import fr.minepiece.client.gui.component.button.GuiComponent;
import fr.minepiece.client.gui.component.button.GuiUtils;
import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public abstract class AbstractUI
extends GuiScreen {
    private final ResourceLocation background;
    private final Queue<GuiComponent> components = Queues.newConcurrentLinkedQueue();
    public int pageScroll;
    public double currentPageScroll;
    public GuiScreen prev;
    public AbstractUI instance;
    public UIPopup popup;
    private boolean loaded;
    private final AtomicLong packetCallbacks;
    private long lastUpdate;
    private boolean drawDebug;

    public AbstractUI() {
        this(null, "");
    }

    public AbstractUI(GuiScreen prev, String name) {
        if (name != null) {
            String[] resource = name.split(":");
            String modId = resource.length > 1 ? resource[0] : "minecraft";
            String texture = resource.length > 1 ? resource[1] : resource[0];
            this.background = new ResourceLocation(modId, "textures/gui/" + texture + "/background.png");
        } else {
            this.background = null;
        }
        this.prev = prev;
        this.packetCallbacks = new AtomicLong(0L);
        this.instance = this;
        this.lastUpdate = System.currentTimeMillis();
        this.field_146297_k = Minecraft.func_71410_x();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public ResourceLocation getBackground() {
        return this.background;
    }

    public Queue<GuiComponent> getComponents() {
        return this.components;
    }

    public void func_73866_w_() {
        this.field_146294_l = this.field_146297_k.field_71443_c;
        this.field_146295_m = this.field_146297_k.field_71440_d;
        this.components.clear();
        this.field_146292_n.clear();
        if (!this.loaded) {
            this.packetCallbacks.set(0L);
            this.setLoaded(true);
            return;
        }
        if (this.popup != null) {
            this.popup.func_73866_w_();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int buttonID) throws IOException {
        if (this.popup == null) {
            for (GuiComponent node : this.components.stream().sorted(Comparator.comparingInt(GuiComponent::getZindex).reversed()).collect(Collectors.toList())) {
                if (!this.clickNode(node, mouseX, mouseY, buttonID)) continue;
                return;
            }
            super.func_73864_a(mouseX, (int)((double)mouseY - this.currentPageScroll), buttonID);
        } else {
            this.popup.func_73864_a(mouseX, (int)((double)mouseY - this.currentPageScroll), buttonID);
        }
    }

    private boolean clickNode(GuiComponent node, int mouseX, int mouseY, int buttonID) {
        int finalMouseY = (int)((double)mouseY - this.currentPageScroll);
        for (GuiComponent child2 : node.getChildren().stream().filter(child -> child.getZindex() >= 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).collect(Collectors.toList())) {
            if (!this.clickNode(child2, mouseX, mouseY, buttonID)) continue;
            return true;
        }
        if (node.onClick(mouseX, finalMouseY, buttonID)) {
            return true;
        }
        for (GuiComponent child2 : node.getChildren().stream().filter(child -> child.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).collect(Collectors.toList())) {
            if (!this.clickNode(child2, mouseX, mouseY, buttonID)) continue;
            return true;
        }
        return false;
    }

    protected void func_146286_b(int mouseX, int mouseY, int buttonID) {
        if (this.popup == null) {
            this.components.stream().sorted(Comparator.comparingInt(GuiComponent::getZindex).reversed()).forEach(node -> this.releaseNode((GuiComponent)node, mouseX, mouseY, buttonID));
            super.func_146286_b(mouseX, (int)((double)mouseY - this.currentPageScroll), buttonID);
        } else {
            this.popup.func_146286_b(mouseX, (int)((double)mouseY - this.currentPageScroll), buttonID);
        }
    }

    private void releaseNode(GuiComponent node, int mouseX, int mouseY, int buttonID) {
        int finalMouseY = (int)((double)mouseY - this.currentPageScroll);
        node.getChildren().stream().filter(child -> child.getZindex() >= 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.releaseNode((GuiComponent)child, mouseX, mouseY, buttonID));
        node.onRelease(mouseX, finalMouseY, buttonID);
        node.getChildren().stream().filter(child -> child.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.releaseNode((GuiComponent)child, mouseX, mouseY, buttonID));
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (keyCode == 68) {
            boolean bl = this.drawDebug = !this.drawDebug;
        }
        if (this.popup == null) {
            this.components.stream().sorted(Comparator.comparingInt(GuiComponent::getZindex).reversed()).forEach(node -> this.keyTypedNode((GuiComponent)node, c, keyCode));
            super.func_73869_a(c, keyCode);
        } else {
            this.popup.func_73869_a(c, keyCode);
        }
    }

    private void keyTypedNode(GuiComponent node, char c, int keyCode) {
        node.getChildren().stream().filter(child -> child.getZindex() >= 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.keyTypedNode((GuiComponent)child, c, keyCode));
        node.onKeyTyped(c, keyCode);
        node.getChildren().stream().filter(child -> child.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(child -> this.keyTypedNode((GuiComponent)child, c, keyCode));
    }

    public void fixedUpdate() {
        this.components.forEach(this::fixedUpdateNode);
    }

    private void fixedUpdateNode(GuiComponent node) {
        node.fixedUpdate();
        node.getChildren().forEach(this::fixedUpdateNode);
    }

    public void drawBackground(int mouseX, int mouseY, float ticks) {
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        this.lastUpdate = System.currentTimeMillis();
        if (this.popup != null) {
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)500.0f);
            this.popup.func_73863_a(mouseX, mouseY, ticks);
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-500.0f);
        }
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)999.0f);
        GuiUtils.hovers.forEach(hover -> GuiUtils.drawHoveringText(hover.getTexts(), hover.getX(), hover.getY(), hover.getFont(), hover.getColor()));
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-999.0f);
        if (this.drawDebug) {
            this.drawDebug(mouseX, mouseY);
        }
    }

    public void postDraw(int mouseX, int mouseY, float ticks) {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void addComponent(GuiComponent node) {
        if (!this.components.contains(node)) {
            this.setRecursiveUI(node);
            this.components.add(node);
        }
    }

    private void setRecursiveUI(GuiComponent node) {
        node.getChildren().forEach(this::setRecursiveUI);
        node.setUi(this);
    }

    public void openPopup(UIPopup popup) {
        popup.field_146297_k = this.field_146297_k;
        popup.field_146294_l = this.field_146294_l;
        popup.field_146295_m = this.field_146295_m;
        this.popup = popup;
        this.popup.func_73866_w_();
    }

    public float width(float value) {
        return (float)this.field_146297_k.field_71443_c / 100.0f * value;
    }

    public float height(float value) {
        return (float)this.field_146297_k.field_71440_d / 100.0f * value;
    }

    public double width(double value) {
        return (double)this.field_146297_k.field_71443_c / 100.0 * value;
    }

    public double height(double value) {
        return (double)this.field_146297_k.field_71440_d / 100.0 * value;
    }

    public boolean isLoading() {
        return !this.loaded;
    }

    public boolean isBlur() {
        return true;
    }

    public boolean hasReturn() {
        return false;
    }

    public void drawBackground() {
    }

    public void drawDebug() {
        this.getComponents().forEach(this::drawDebugNode);
    }

    private void drawDebugNode(GuiComponent node) {
        node.getChildren().stream().filter(child -> child.getZindex() >= 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(this::drawDebugNode);
        node.drawDebug();
        node.getChildren().stream().filter(child -> child.getZindex() < 0).sorted(Comparator.comparingInt(GuiComponent::getZindex)).forEach(this::drawDebugNode);
    }

    public void drawDebug(int mouseX, int mouseY) {
        int i;
        this.drawDebug();
        for (i = 0; i < this.field_146295_m; ++i) {
            if (i % 5 != 0) continue;
            GuiUtils.drawRect((double)mouseX - 0.5, i, (double)mouseX + 0.5, i + 3, new Color(41, 128, 185));
        }
        for (i = 0; i < this.field_146294_l; ++i) {
            if (i % 5 != 0) continue;
            GuiUtils.drawRect(i, (double)mouseY - 0.5, i + 3, (double)mouseY + 0.5, new Color(41, 128, 185));
        }
        String widthRatio = new DecimalFormat("#.##").format(Mouse.getEventButton() == 1 ? (double)mouseX : (double)((float)mouseX / (float)this.field_146294_l * 100.0f)) + (Mouse.getEventButton() == 1 ? "px" : "%");
        String heightRatio = new DecimalFormat("#.##").format(Mouse.getEventButton() == 1 ? (double)mouseY : (double)((float)mouseY / (float)this.field_146295_m * 100.0f)) + (Mouse.getEventButton() == 1 ? "px" : "%");
        this.func_73731_b(this.field_146289_q, widthRatio, mouseX - this.field_146289_q.func_78256_a(widthRatio), mouseY - this.field_146289_q.field_78288_b, -1);
        this.func_73731_b(this.field_146289_q, heightRatio, mouseX - this.field_146289_q.func_78256_a(heightRatio), mouseY, -1);
    }

    public void reload() {
        try {
            this.field_146297_k.func_147108_a((GuiScreen)((Object)((Object)this)).getClass().getConstructor(GuiScreen.class).newInstance(this.prev));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

