/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.events;

import fr.minepiece.client.commands.ClientParticleTestCommand;
import fr.minepiece.client.particles.vfx.implementations.ParticleCCBlur;
import fr.minepiece.client.particles.vfx.implementations.ParticleFire;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="minepiece")
public class WorldRenderLast {
    private static ArrayList<Vec3d> circlePoints = new ArrayList();
    private static int currentIndex = 0;
    private static long lastTickProcessed = -1L;
    public static ArrayList<ArrayList<ParticleCCBlur>> particlesToRender = new ArrayList();

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        int ticksPerParticleChange = 3;
        if (event.player.field_70170_p.func_82737_E() % (long)ticksPerParticleChange != 0L) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
    }

    @SubscribeEvent
    public static void onWorldRender(RenderWorldLastEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        int ticksPerParticleChange = 5;
        int currentTick = (int)player.field_70170_p.func_82737_E();
        if ((long)currentTick == lastTickProcessed) {
            return;
        }
        if (currentTick % ticksPerParticleChange != 0) {
            return;
        }
        if (!ClientParticleTestCommand.shouldRenderCircle) {
            lastTickProcessed = currentTick;
            return;
        }
        circlePoints = (ArrayList)WorldRenderLast.calculateCirclePoints(player.field_70165_t, player.field_70163_u, player.field_70161_v, 4.0, 80);
        Vec3d point = circlePoints.get(currentIndex);
        ParticleFire particle = (ParticleFire)new ParticleFire(player.field_70170_p, point.field_72450_a, point.field_72448_b, point.field_72449_c, 3.0f).setGravity(0.0f).setLife(100);
        ParticleCCBlur particleCCBlur = (ParticleCCBlur)new ParticleCCBlur(player.field_70170_p, point.field_72450_a, point.field_72448_b, point.field_72449_c).setColor(0xFFFFFF).setScale(8.0f).setGravity(0.0f).setLife(100);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particleCCBlur);
        currentIndex = (currentIndex + 1) % 80;
        lastTickProcessed = currentTick;
    }

    private static List<Vec3d> calculateCirclePoints(double centerX, double centerY, double centerZ, double radius, int numPoints) {
        ArrayList<Vec3d> circlePoints = new ArrayList<Vec3d>();
        for (int i = 0; i < numPoints; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)numPoints;
            double x = centerX + radius * Math.cos(angle);
            double y = centerY;
            double z = centerZ + radius * Math.sin(angle);
            circlePoints.add(new Vec3d(x, y, z));
            for (int j = 1; j < 2; ++j) {
                double trailX = x + (double)j * (x - centerX) / (double)numPoints;
                double trailY = y + (double)j * (y - centerY) / (double)numPoints;
                double d = z + (double)j * (z - centerZ) / (double)numPoints;
            }
        }
        return circlePoints;
    }
}

