/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.events;

import fr.minepiece.common.capability.temperature.ITemperature;
import fr.minepiece.common.capability.temperature.TemperatureProvider;
import fr.minepiece.common.capability.temperature.TemperatureState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class TemperatureOverlay
extends Gui {
    private static final int SKULL_SIZE = 16;

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HOTBAR) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player == null) {
            return;
        }
        ITemperature temp = (ITemperature)player.getCapability(TemperatureProvider.TEMPERATURE_CAPABILITY, null);
        if (temp == null) {
            return;
        }
        TemperatureState state = temp.getCurrentState();
        int screenWidth = event.getResolution().func_78326_a();
        int xPos = screenWidth / 2 - 8;
        int yPos = event.getResolution().func_78328_b() - 27;
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        ResourceLocation skullTexture = new ResourceLocation("minepiece", "textures/gui/temperature/skull_" + TemperatureOverlay.getSkullTextureName(state) + ".png");
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    private static String getSkullTextureName(TemperatureState state) {
        switch (state) {
            case HYPOTHERMIA_DEATH: {
                return "hypo_4";
            }
            case HYPOTHERMIA_SEVERE: {
                return "hypo_3";
            }
            case HYPOTHERMIA_MODERATE: {
                return "hypo_2";
            }
            case HYPOTHERMIA_MILD: {
                return "hypo_1";
            }
            case NORMAL: {
                return "normal";
            }
            case HYPERTHERMIA_MILD: {
                return "hyper_1";
            }
            case HYPERTHERMIA_MODERATE: {
                return "hyper_2";
            }
            case HYPERTHERMIA_SEVERE: {
                return "hyper_3";
            }
            case HYPERTHERMIA_DEATH: {
                return "hyper_4";
            }
        }
        return "normal";
    }
}

