/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.events;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="minepiece")
public class OverlayRenderer {
    private static final ResourceLocation OVERLAY_TEXTURE = new ResourceLocation("minepiece", "textures/overlays/tontatta_instanthealth_overlay.png");
    private static float alpha = 1.0f;
    private static ArrayList<Integer> hasActivatedInstantHealthAbility = new ArrayList();

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g != null && hasActivatedInstantHealthAbility.contains(mc.field_71439_g.func_145782_y())) {
                int x = 0;
                int y = 0;
                int width = event.getResolution().func_78326_a();
                int height = event.getResolution().func_78328_b();
                mc.field_71446_o.func_110577_a(OVERLAY_TEXTURE);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                OverlayRenderer.drawTexturedModalRectt(x, y, 0, 0, width, height);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onClientPlayerTick(TickEvent.PlayerTickEvent event) {
        if (hasActivatedInstantHealthAbility.contains(event.player.func_145782_y())) {
            if (alpha > 0.0f) {
                alpha -= 0.006f;
            } else {
                hasActivatedInstantHealthAbility.removeIf(entityId -> entityId.intValue() == event.player.func_145782_y());
            }
        } else {
            alpha = 1.0f;
        }
    }

    public static void setHasActivatedInstantHealthAbility(int entityId) {
        hasActivatedInstantHealthAbility.add(entityId);
    }

    private static void drawTexturedModalRectt(int x, int y, int textureX, int textureY, int width, int height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_187315_a((double)((float)textureX / (float)width), (double)((float)(textureY + height) / (float)height)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)((float)(textureX + width) / (float)width), (double)((float)(textureY + height) / (float)height)).func_181675_d();
        bufferBuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_187315_a((double)((float)(textureX + width) / (float)width), (double)((float)textureY / (float)height)).func_181675_d();
        bufferBuilder.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)((float)textureX / (float)width), (double)((float)textureY / (float)height)).func_181675_d();
        tessellator.func_78381_a();
    }
}

