/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.events;

import fr.minepiece.client.commands.FPSTestCommand;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class FPSEvents {
    private static ArrayList<Integer> fps = new ArrayList();
    private static int ticksLeft = 0;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase == TickEvent.Phase.END && ticksLeft > 0) {
            EntityPlayer player = e.player;
            if (ticksLeft % 20 == 0) {
                fps.add(Minecraft.func_175610_ah());
            }
            if (--ticksLeft == 0) {
                int averageFPS = 0;
                for (int i : fps) {
                    averageFPS += i;
                }
                FPSTestCommand.sendFPSMessage(player, averageFPS /= fps.size(), FPSEvents.calculateMedian(fps));
            }
        }
    }

    private static int calculateMedian(ArrayList<Integer> fps) {
        ArrayList<Integer> sortedFPS = new ArrayList<Integer>(fps);
        sortedFPS.sort(Integer::compareTo);
        int size = sortedFPS.size();
        if (size % 2 == 0) {
            return (sortedFPS.get(size / 2 - 1) + sortedFPS.get(size / 2)) / 2;
        }
        return sortedFPS.get(size / 2);
    }

    public static void startFPSCountdown(int ticks) {
        ticksLeft = ticks;
        fps.clear();
    }
}

