/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.events;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(value={Side.CLIENT})
@SideOnly(value=Side.CLIENT)
public class ClientKOHandler {
    private static final HashMap<UUID, Long> clientKOPlayers = new HashMap();
    private static final ClientKOHandler INSTANCE = new ClientKOHandler();

    public static ClientKOHandler getInstance() {
        return INSTANCE;
    }

    public boolean isPlayerInKO(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        return clientKOPlayers.containsKey(player.func_110124_au());
    }

    public static void updateKOState(UUID playerUUID, boolean isKO) {
        if (isKO) {
            clientKOPlayers.put(playerUUID, System.currentTimeMillis());
        } else {
            clientKOPlayers.remove(playerUUID);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            UUID[] currentKOUUIDs;
            for (UUID uuid : currentKOUUIDs = clientKOPlayers.keySet().toArray(new UUID[0])) {
                EntityPlayer player = mc.field_71441_e.func_152378_a(uuid);
                if (player != null) continue;
                clientKOPlayers.remove(uuid);
            }
            EntityPlayerSP localPlayer = mc.field_71439_g;
            if (localPlayer != null && clientKOPlayers.containsKey(localPlayer.func_110124_au()) && localPlayer.func_70051_ag()) {
                localPlayer.func_70031_b(false);
            }
        }
    }
}

