/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ClientConfig {
    public static Configuration config;
    private static File config_dir;
    public static ArrayList<String> SKILLS;

    public static void init(File configFile) {
        System.out.println("INIT START");
        config = new Configuration(configFile);
        String category = "skills";
        config.addCustomCategoryComment(category, "The configuration for skills");
        ClientConfig.reloadSkills();
        config.save();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("minepiece")) {
            ClientConfig.loadConfig();
        }
    }

    private static void loadConfig() {
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static ArrayList<String> reloadSkills() {
        SKILLS = new ArrayList<String>(Arrays.asList(config.getString("skill1", "skills", "", "First skill"), config.getString("skill2", "skills", "", "Second skill"), config.getString("skill3", "skills", "", "Third skill"), config.getString("skill4", "skills", "", "Fourth skill"), config.getString("skill5", "skills", "", "Fifth skill")));
        return SKILLS;
    }

    public static ArrayList<String> getSkills() {
        return ClientConfig.reloadSkills();
    }

    public static String getSkill(int index) {
        return config.getStringList("skills", "abilities", new String[4], "Abilities selection")[index - 1];
    }

    public static void setSkill(int index, String skill) {
        config.get("skills", "skill" + index, "").set(skill);
        ClientConfig.loadConfig();
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ClientConfig.loadConfig();
    }

    public static void registerConfig(FMLPreInitializationEvent e) {
        config_dir = new File(e.getModConfigurationDirectory() + "/" + "minepiece");
        config_dir.mkdirs();
        ClientConfig.init(new File(config_dir.getPath(), "minepiece_client.cfg"));
    }

    static {
        SKILLS = new ArrayList<String>(Arrays.asList("", "", "", "", ""));
    }
}

