/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client.commands;

import fr.minepiece.common.capability.CapabilityHelper;
import fr.minepiece.common.capability.mpdata.IMinePieceData;
import fr.minepiece.common.capability.mpstats.IMinePieceStats;
import fr.minepiece.common.capability.playermodifications.IPlayerModifications;
import fr.minepiece.common.capability.playermodifications.PlayerModificationsStorage;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CapabilityTestClientCommand
implements ICommand {
    public String func_71517_b() {
        return "capagetclient";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " <player> <modifications|data|stats>";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String capabilityType;
        if (args.length < 2) {
            throw new CommandException("Invalid arguments. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayer targetPlayer = Minecraft.func_71410_x().field_71441_e.func_72924_a(args[0]);
        if (targetPlayer == null) {
            throw new CommandException("Player not found: " + args[0], new Object[0]);
        }
        switch (capabilityType = args[1]) {
            case "modifications": {
                IPlayerModifications modifications = (IPlayerModifications)targetPlayer.getCapability(PlayerModificationsStorage.PLAYER_MODIFICATIONS_CAPABILITY, null);
                if (modifications != null) {
                    String output = "Modifications: " + targetPlayer.func_70005_c_() + "\n";
                    output = output + "Pose: " + modifications.getPose() + "\n";
                    output = output + "Skin: " + modifications.getSkin() + "\n";
                    output = output + "Modifications: " + modifications.getModifications() + "\n";
                    output = output + "Skin Modifications: " + modifications.getSkinModifications() + "\n";
                    output = output + "Skin Color: " + modifications.getSkinColor() + "\n";
                    output = output + "Modification Color: " + modifications.getModificationColor() + "\n";
                    sender.func_145747_a((ITextComponent)new TextComponentString(output));
                    break;
                }
                throw new CommandException("Player modifications capability not found.", new Object[0]);
            }
            case "data": {
                IMinePieceData data = CapabilityHelper.getPlayerData(targetPlayer);
                if (data != null) {
                    String output = "Data for: " + targetPlayer.func_70005_c_() + "\n";
                    output = output + "Level: " + data.getLevel() + "\n";
                    output = output + "Experience: " + data.getXP() + "\n";
                    output = output + "RP Name: " + data.getRPName() + "\n";
                    output = output + "RP Last Name: " + data.getRPLastName() + "\n";
                    output = output + "Race: " + (Object)((Object)data.getRace()) + "\n";
                    output = output + "Skills: " + data.getSkills() + "\n";
                    output = output + "Daily Craft Limit: " + data.getDailyCraftLimit() + "\n";
                    output = output + "Job: " + (Object)((Object)data.getJob()) + "\n";
                    output = output + "Job Level: " + data.getJobLevel() + "\n";
                    output = output + "Job XP: " + data.getJobXP() + "\n";
                    output = output + "RP age: " + data.getRPAge() + "\n";
                    sender.func_145747_a((ITextComponent)new TextComponentString(output));
                    break;
                }
                throw new CommandException("Player data capability not found.", new Object[0]);
            }
            case "stats": {
                IMinePieceStats stats = CapabilityHelper.getPlayerStats(targetPlayer);
                if (stats != null) {
                    String output = "Stats for: " + targetPlayer.func_70005_c_() + "\n";
                    output = output + "Energy: " + stats.getEnergy() + "\n";
                    output = output + "Max Energy: " + stats.getMaxEnergy() + "\n";
                    output = output + "Actual Max Energy: " + stats.getActualMaxEnergy() + "\n";
                    output = output + "Strength: " + stats.getStrength() + "\n";
                    output = output + "HP: " + stats.getHP() + "\n";
                    output = output + "Speed: " + stats.getSpeed() + "\n";
                    output = output + "Defense: " + stats.getToughness() + "\n";
                    output = output + "StatPoints: " + stats.getStatPoints() + "\n";
                    sender.func_145747_a((ITextComponent)new TextComponentString(output));
                    break;
                }
                throw new CommandException("Player stats capability not found.", new Object[0]);
            }
            default: {
                throw new CommandException("Invalid capability type. Usage: " + this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return 0;
    }
}

