/*
 * Decompiled with CFR 0.152.
 */
package fr.minepiece.client;

import fr.minepiece.client.commands.CapabilityTestClientCommand;
import fr.minepiece.client.commands.ClientParticleTestCommand;
import fr.minepiece.client.commands.FPSTestCommand;
import fr.minepiece.client.commands.TestShader;
import fr.minepiece.client.config.ClientConfig;
import fr.minepiece.client.gui.component.fontv3.IFont;
import fr.minepiece.client.gui.component.fontv3.Lang;
import fr.minepiece.client.gui.component.fontv3.StyledFont;
import fr.minepiece.client.gui.hud.HudHandler;
import fr.minepiece.client.model.ClientModTieredItems;
import fr.minepiece.client.model.layers.LayerCustomSkinRender;
import fr.minepiece.client.particles.ModParticles;
import fr.minepiece.client.render.ShaderHelper;
import fr.minepiece.client.render.tesr.CannonTEISR;
import fr.minepiece.client.render.tesr.RenderTileCannon;
import fr.minepiece.common.CommonProxy;
import fr.minepiece.common.blocks.canons.TileEntityCannon;
import fr.minepiece.common.init.ModBlocks;
import fr.minepiece.common.init.ModEntities;
import fr.minepiece.common.init.ModKeybindings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class ClientProxy
extends CommonProxy {
    public static IFont text = new StyledFont("minecraft.ttf", 64, 0.0f, 0.0f, 1.0f, Lang.FR);
    public static final String FONT_DIR = "/assets/minepiece/font/";
    public static int fontSize;

    @SubscribeEvent
    public static void onKey(InputEvent.KeyInputEvent e) {
    }

    @Override
    public void registerItemRenderer(Item item, int meta, String id) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), id));
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        ClientConfig.registerConfig(e);
        ModKeybindings.registerKeybindings();
        ModEntities.registerEntitiesRender();
        ClientCommandHandler.instance.func_71560_a((ICommand)new ClientParticleTestCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new CapabilityTestClientCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new FPSTestCommand());
        ClientCommandHandler.instance.func_71560_a((ICommand)new TestShader());
        ClientModTieredItems.init();
        ShaderHelper.initShaders();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        HudHandler.registerComponents();
        System.out.println("ClientProxy init");
        if (ModBlocks.CANNON_ITEM != null) {
            System.out.println("Setting TEISR for: " + ModBlocks.CANNON_ITEM.getRegistryName());
            RenderTileCannon blockRenderer = new RenderTileCannon();
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityCannon.class, (TileEntitySpecialRenderer)blockRenderer);
            ModBlocks.CANNON_ITEM.setTileEntityItemStackRenderer(new CannonTEISR(blockRenderer));
        } else {
            System.err.println("ERROR: ModBlocks.CANNON_ITEM was null during ClientProxy init! TEISR not registered.");
        }
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
        ModParticles.registerParticles();
        this.addRenderLayers();
    }

    private void addRenderLayers() {
        for (RenderPlayer playerRender : Minecraft.func_71410_x().func_175598_ae().getSkinMap().values()) {
            playerRender.func_177094_a((LayerRenderer)new LayerCustomSkinRender(playerRender));
        }
    }
}

