/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tile.parent;

import com.creativemd.creativecore.common.utils.type.Pair;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.attribute.LittleStructureAttribute;
import com.creativemd.littletiles.common.structure.exception.CorruptedConnectionException;
import com.creativemd.littletiles.common.structure.exception.CorruptedLinkException;
import com.creativemd.littletiles.common.structure.exception.NotYetConnectedException;
import com.creativemd.littletiles.common.tile.LittleTile;
import com.creativemd.littletiles.common.tile.parent.IParentTileList;
import com.creativemd.littletiles.common.tile.parent.IStructureTileList;
import com.creativemd.littletiles.common.tile.parent.ParentTileList;
import com.creativemd.littletiles.common.tile.parent.StructureTileList;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileList
extends ParentTileList {
    public TileEntityLittleTiles te;
    private final ConcurrentHashMap<Integer, StructureTileList> structures = new ConcurrentHashMap();
    private int attributes = 0;
    private final boolean client;

    public TileList(TileEntityLittleTiles te, boolean client) {
        this.te = te;
        this.client = client;
    }

    private void clearStructures() {
        for (StructureTileList structure : this.structures.values()) {
            structure.unload();
        }
        this.structures.clear();
    }

    @Override
    protected void readExtra(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("children", 10);
        HashMap<Integer, StructureTileList> previous = new HashMap<Integer, StructureTileList>(this.structures);
        this.structures.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound childNBT = list.func_150305_b(i);
            StructureTileList child = previous.remove(childNBT.func_74762_e("index"));
            if (child == null) {
                child = new StructureTileList(this, childNBT);
            } else {
                child.read(childNBT);
            }
            this.structures.put(child.getIndex(), child);
        }
        for (StructureTileList child : previous.values()) {
            child.unload();
        }
        this.reloadAttributes();
    }

    @Override
    protected void writeExtra(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (StructureTileList child : this.structures.values()) {
            list.func_74742_a((NBTBase)child.write());
        }
        nbt.func_74782_a("children", (NBTBase)list);
    }

    public void clearEverything() {
        super.clear();
        this.clearStructures();
    }

    public int countStructures() {
        return this.structures.size();
    }

    public boolean removeStructure(int index) {
        StructureTileList list = this.structures.remove(index);
        if (list != null) {
            list.removed();
        }
        boolean removed = list != null;
        this.reloadAttributes();
        return removed;
    }

    public void addStructure(int index, StructureTileList list) {
        if (this.structures.containsKey(index)) {
            throw new IllegalArgumentException("index '" + index + "' already exists");
        }
        this.structures.put(index, list);
    }

    public StructureTileList addStructure(int index, int attribute) {
        if (this.structures.containsKey(index)) {
            throw new IllegalArgumentException("index '" + index + "' already exists");
        }
        StructureTileList list = new StructureTileList(this, index, attribute);
        this.structures.put(index, list);
        this.reloadAttributes();
        return list;
    }

    public Iterable<LittleStructure> loadedStructures() {
        return new Iterable<LittleStructure>(){

            @Override
            public Iterator<LittleStructure> iterator() {
                return new Iterator<LittleStructure>(){
                    Iterator<StructureTileList> itr;
                    StructureTileList next;
                    {
                        this.itr = TileList.this.structures.values().iterator();
                        this.next = null;
                    }

                    @Override
                    public boolean hasNext() {
                        while (this.next == null) {
                            if (!this.itr.hasNext()) {
                                return false;
                            }
                            this.next = this.itr.next();
                            try {
                                this.next.checkConnection();
                            }
                            catch (CorruptedConnectionException | NotYetConnectedException e) {
                                this.next = null;
                            }
                        }
                        return this.next != null;
                    }

                    @Override
                    public LittleStructure next() {
                        try {
                            StructureTileList temp = this.next;
                            this.next = null;
                            return temp.getStructure();
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                };
            }
        };
    }

    public Iterable<IStructureTileList> structures() {
        return new Iterable<IStructureTileList>(){

            @Override
            public Iterator<IStructureTileList> iterator() {
                return new Iterator<IStructureTileList>(){
                    Iterator<StructureTileList> iterator;
                    {
                        this.iterator = TileList.this.structures.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public IStructureTileList next() {
                        return this.iterator.next();
                    }
                };
            }
        };
    }

    public Iterable<StructureTileList> structuresReal() {
        return this.structures.values();
    }

    public Iterable<LittleStructure> loadedStructures(final int attribute) {
        return new Iterable<LittleStructure>(){

            @Override
            public Iterator<LittleStructure> iterator() {
                if (LittleStructureAttribute.listener(attribute) || LittleStructureAttribute.active(attribute)) {
                    return new Iterator<LittleStructure>(){
                        public Iterator<StructureTileList> iterator;
                        public LittleStructure next;
                        {
                            this.iterator = TileList.this.structures.values().iterator();
                            this.findNext();
                        }

                        public void findNext() {
                            while (this.iterator.hasNext()) {
                                StructureTileList structure = this.iterator.next();
                                if ((structure.getAttribute() & attribute) == 0) continue;
                                try {
                                    this.next = structure.getStructure();
                                }
                                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                                    // empty catch block
                                }
                                return;
                            }
                            this.next = null;
                        }

                        @Override
                        public boolean hasNext() {
                            return this.next != null;
                        }

                        @Override
                        public LittleStructure next() {
                            LittleStructure toReturn = this.next;
                            this.findNext();
                            return toReturn;
                        }
                    };
                }
                return new Iterator<LittleStructure>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public LittleStructure next() {
                        return null;
                    }
                };
            }
        };
    }

    public boolean hasTicking() {
        return LittleStructureAttribute.ticking(this.attributes);
    }

    public boolean hasRendered() {
        return LittleStructureAttribute.tickRendering(this.attributes);
    }

    public boolean hasCollisionListener() {
        if (this.checkCollision() && LittleStructureAttribute.collisionListener(this.attributes)) {
            return true;
        }
        for (StructureTileList child : this.structures.values()) {
            if (!child.checkCollision()) continue;
            return true;
        }
        return false;
    }

    public Iterable<IParentTileList> groups() {
        return new Iterable<IParentTileList>(){

            @Override
            public Iterator<IParentTileList> iterator() {
                return new Iterator<IParentTileList>(){
                    IParentTileList current;
                    Iterator<IStructureTileList> children;
                    {
                        this.current = TileList.this;
                        this.children = TileList.this.structures().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.current != null) {
                            return true;
                        }
                        if (!this.children.hasNext()) {
                            return false;
                        }
                        this.current = this.children.next();
                        return true;
                    }

                    @Override
                    public IParentTileList next() {
                        IParentTileList result = this.current;
                        this.current = null;
                        return result;
                    }
                };
            }
        };
    }

    public Iterable<Pair<IParentTileList, LittleTile>> allTiles() {
        final Iterator<IParentTileList> iterator = this.groups().iterator();
        return new Iterable<Pair<IParentTileList, LittleTile>>(){

            @Override
            public Iterator<Pair<IParentTileList, LittleTile>> iterator() {
                return new Iterator<Pair<IParentTileList, LittleTile>>(){
                    Iterator<LittleTile> inBlock = null;
                    Pair<IParentTileList, LittleTile> pair = null;

                    @Override
                    public boolean hasNext() {
                        while (this.inBlock == null || !this.inBlock.hasNext()) {
                            if (!iterator.hasNext()) {
                                return false;
                            }
                            IParentTileList list = (IParentTileList)iterator.next();
                            this.pair = new Pair((Object)list, null);
                            this.inBlock = list.iterator();
                        }
                        return true;
                    }

                    @Override
                    public Pair<IParentTileList, LittleTile> next() {
                        this.pair.setValue((Object)this.inBlock.next());
                        return this.pair;
                    }
                };
            }
        };
    }

    @Override
    public LittleTile first() {
        return this.isEmpty() ? null : (LittleTile)super.get(0);
    }

    @Override
    public int totalSize() {
        int size = this.size();
        for (StructureTileList list : this.structures.values()) {
            size += list.totalSize();
        }
        return size;
    }

    @Override
    public LittleTile last() {
        return this.isEmpty() ? null : (LittleTile)super.get(this.size() - 1);
    }

    private void reloadAttributes() {
        this.attributes = 0;
        for (StructureTileList structure : this.structures.values()) {
            this.attributes |= structure.getAttribute();
        }
    }

    @Override
    public TileEntityLittleTiles getTe() {
        return this.te;
    }

    @Override
    public boolean isStructure() {
        return false;
    }

    @Override
    public boolean isMain() {
        return false;
    }

    @Override
    public boolean isStructureChild(LittleStructure structure) throws CorruptedConnectionException, NotYetConnectedException {
        return false;
    }

    @Override
    public LittleStructure getStructure() throws CorruptedLinkException {
        throw new CorruptedLinkException();
    }

    public StructureTileList getStructure(int index) {
        return this.structures.get(index);
    }

    @Override
    public int getAttribute() {
        return 0;
    }

    @Override
    public void setAttribute(int attribute) {
    }

    @Override
    public boolean isClient() {
        return this.client;
    }

    public void add(TileList tiles) {
        this.addAll(tiles);
        tiles.structures.putAll(this.structures);
        for (StructureTileList list : this.structures.values()) {
            list.setParent(this);
        }
    }

    public void fillUsedIds(BitSet usedIds) {
        for (Integer id : this.structures.keySet()) {
            if (id < 0) continue;
            usedIds.set(id);
        }
    }

    public void removeEmptyLists() {
        Iterator<StructureTileList> iterator = this.structures.values().iterator();
        while (iterator.hasNext()) {
            StructureTileList child = iterator.next();
            if (!child.isEmpty()) continue;
            child.isRemoved();
            iterator.remove();
        }
    }

    public boolean isCompletelyEmpty() {
        return super.isEmpty() && this.structures.isEmpty();
    }

    @Override
    public void unload() {
        super.unload();
        for (StructureTileList child : this.structures.values()) {
            child.unload();
        }
    }
}

