/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.gui.signal;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiScrollBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTabStateButtonTranslated;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.ControlEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.client.gui.signal.GuiSignalController;
import com.creativemd.littletiles.common.structure.signal.input.SignalInputCondition;
import com.creativemd.littletiles.common.structure.signal.logic.SignalLogicOperator;
import com.creativemd.littletiles.common.structure.signal.logic.SignalPatternParser;
import com.creativemd.littletiles.common.structure.signal.logic.SignalTarget;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.text.ParseException;
import java.util.ArrayList;

public class SubGuiDialogSignalInput
extends SubGui {
    public final GuiSignalController.GuiSignalNodeInput input;
    public int bandwidth;

    public SubGuiDialogSignalInput(GuiSignalController.GuiSignalNodeInput input) {
        this.input = input;
    }

    public void createControls() {
        this.controls.add(new GuiLabel(this.input.component.name + "[", 0, 0));
        this.controls.add(new GuiTextfield("range", this.input.getRange(), 20, 0, 100, 10));
        this.controls.add(new GuiLabel("result", "] " + this.input.component.bandwidth + " ->", 124, 0));
        this.controls.add(new GuiTabStateButtonTranslated("type", this.input.operator, "gui.signal.configuration.input.operation.type.", 0, 20, 10, new String[]{"none", "operation", "pattern", "equation"}));
        this.controls.add(new GuiScrollBox("config", 0, 40, 170, 96));
        this.controls.add(new GuiButton("cancel", 0, 146){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogSignalInput.this.closeGui();
            }
        });
        this.controls.add(new GuiButton("save", 146, 146){

            public void onClicked(int x, int y, int button) {
                GuiTextfield range = (GuiTextfield)SubGuiDialogSignalInput.this.get("range");
                try {
                    SubGuiDialogSignalInput.this.input.indexes = SubGuiDialogSignalInput.this.parseRange(range.text);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                GuiTabStateButtonTranslated tab = (GuiTabStateButtonTranslated)SubGuiDialogSignalInput.this.get("type");
                GuiScrollBox panel = (GuiScrollBox)SubGuiDialogSignalInput.this.get("config");
                SubGuiDialogSignalInput.this.input.operator = tab.getState();
                switch (tab.getState()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        GuiStateButton operation = (GuiStateButton)panel.get("operation");
                        SubGuiDialogSignalInput.this.input.logic = SignalLogicOperator.values()[operation.getState()];
                        break;
                    }
                    case 2: {
                        int[] indexes = new int[SubGuiDialogSignalInput.this.bandwidth];
                        for (int i = 0; i < SubGuiDialogSignalInput.this.bandwidth; ++i) {
                            GuiStateButton stateButton = (GuiStateButton)panel.get(i + "");
                            indexes[i] = stateButton.getState();
                        }
                        SubGuiDialogSignalInput.this.input.pattern = indexes;
                        break;
                    }
                    case 3: {
                        GuiTextfield textfield = (GuiTextfield)SubGuiDialogSignalInput.this.get("equation");
                        try {
                            SubGuiDialogSignalInput.this.input.equation = SignalInputCondition.parseExpression(new SignalPatternParser(textfield.text), new char[0], false, true);
                            break;
                        }
                        catch (ParseException e) {
                            SubGuiDialogSignalInput.this.input.equation = null;
                        }
                    }
                }
                SubGuiDialogSignalInput.this.input.updateLabel();
                SubGuiDialogSignalInput.this.closeGui();
            }
        });
        this.updateBandwidth();
    }

    @CustomEventSubscribe
    public void changed(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"type"})) {
            GuiTabStateButtonTranslated tab = (GuiTabStateButtonTranslated)this.get("type");
            GuiScrollBox panel = (GuiScrollBox)this.get("config");
            panel.controls.clear();
            switch (tab.getState()) {
                case 0: {
                    break;
                }
                case 1: {
                    panel.addControl((GuiControl)new GuiStateButton("operation", this.input.logic == null ? 0 : this.input.logic.ordinal(), 0, 0, 40, 14, new String[]{SignalLogicOperator.AND.display, SignalLogicOperator.OR.display, SignalLogicOperator.XOR.display}));
                    break;
                }
                case 2: {
                    for (int i = 0; i < this.bandwidth; ++i) {
                        int state = 2;
                        if (this.input.pattern != null && this.input.pattern.length > i) {
                            state = this.input.pattern[i];
                        }
                        panel.addControl((GuiControl)new GuiLabel(i + ":", 10, i * 20 + 3));
                        panel.addControl((GuiControl)new GuiStateButton(i + "", state, 30, i * 20, 60, new String[]{"false", "true", "ignore"}));
                    }
                    break;
                }
                case 3: {
                    panel.addControl((GuiControl)new GuiTextfield("equation", this.input.equation != null ? this.input.equation.write() : "", 0, 0, 100, 10));
                    panel.addControl((GuiControl)new GuiLabel("d<index>", 0, 20));
                }
            }
            panel.refreshControls();
        } else if (event.source.is(new String[]{"range"})) {
            this.updateBandwidth();
        }
    }

    public void updateBandwidth() {
        GuiTextfield range = (GuiTextfield)this.get("range");
        try {
            SignalTarget.SignalCustomIndex[] indexes = this.parseRange(range.text);
            if (indexes == null) {
                this.bandwidth = this.input.component.bandwidth;
            } else {
                this.bandwidth = 0;
                for (int i = 0; i < indexes.length; ++i) {
                    this.bandwidth += indexes[i].length();
                }
            }
        }
        catch (ParseException e) {
            this.bandwidth = this.input.component.bandwidth;
        }
        GuiLabel result = (GuiLabel)this.get("result");
        result.setCaption("] " + this.input.component.bandwidth + " -> " + this.bandwidth);
        this.raiseEvent((ControlEvent)new GuiControlChangedEvent(this.get("type")));
    }

    private SignalTarget.SignalCustomIndex[] parseRange(String range) throws ParseException {
        SignalPatternParser parser = new SignalPatternParser(range);
        ArrayList<SignalTarget.SignalCustomIndex> indexes = new ArrayList<SignalTarget.SignalCustomIndex>();
        while (parser.hasNext()) {
            indexes.add(SignalTarget.parseIndex(parser));
            if (parser.hasNext() && parser.next(true) == ',') continue;
        }
        if (indexes.isEmpty()) {
            return null;
        }
        return indexes.toArray(new SignalTarget.SignalCustomIndex[indexes.size()]);
    }
}

