/*
 * Decompiled with CFR 0.152.
 */
package uk.co.caprica.vlcj.support.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Version
implements Comparable<Version> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)[\\-_\\s]?(.*)");
    private final String version;
    private final int major;
    private final int minor;
    private final int revision;
    private final String extra;

    public Version(String version) {
        this.version = version;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.revision = Integer.parseInt(matcher.group(3));
            this.extra = matcher.groupCount() > 3 ? matcher.group(4) : null;
        } else {
            throw new IllegalArgumentException("Can't parse version from '" + version + "'");
        }
    }

    public String version() {
        return this.version;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int revision() {
        return this.revision;
    }

    public String extra() {
        return this.extra;
    }

    public boolean atLeast(Version required) {
        return this.compareTo(required) >= 0;
    }

    @Override
    public int compareTo(Version o) {
        int delta = this.major - o.major;
        if (delta == 0 && (delta = this.minor - o.minor) == 0) {
            delta = this.revision - o.revision;
        }
        return delta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(20);
        sb.append(this.version);
        return sb.toString();
    }
}

