/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tile.math.location.StructureLocation;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import team.creative.littleframes.common.structure.LittleFrame;

public class LittleFramePacket
extends CreativeCorePacket {
    public StructureLocation location;
    public boolean playing;
    boolean prev;
    boolean next;
    public int tick;

    public LittleFramePacket() {
    }

    public LittleFramePacket(StructureLocation location, boolean playing, int tick, boolean next, boolean prev) {
        this.location = location;
        this.playing = playing;
        this.tick = tick;
        this.prev = prev;
        this.next = next;
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeStructureLocation((StructureLocation)this.location, (ByteBuf)buf);
        buf.writeBoolean(this.playing);
        buf.writeInt(this.tick);
    }

    public void readBytes(ByteBuf buf) {
        this.location = LittleAction.readStructureLocation((ByteBuf)buf);
        this.playing = buf.readBoolean();
        this.tick = buf.readInt();
    }

    public void executeClient(EntityPlayer player) {
        try {
            LittleStructure structure = this.location.find(player.field_70170_p);
            if (structure instanceof LittleFrame) {
                LittleFrame frame = (LittleFrame)structure;
                frame.playing = this.playing;
                frame.tick = this.tick;
                if (frame.display != null) {
                    if (this.playing) {
                        frame.display.resume(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
                    } else {
                        frame.display.resume(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
                    }
                }
            }
        }
        catch (LittleActionException littleActionException) {
            // empty catch block
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

