/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import team.creative.littleframes.common.block.TileEntityCreativeFrame;

public class CreativeFramePacket
extends CreativeCorePacket {
    public BlockPos pos;
    public boolean playing;
    public boolean next;
    public boolean prev;
    public int tick;

    public CreativeFramePacket() {
    }

    public CreativeFramePacket(BlockPos pos, boolean playing, int tick, boolean next, boolean prev) {
        this.pos = pos;
        this.playing = playing;
        this.tick = tick;
        this.prev = prev;
        this.next = next;
    }

    public void writeBytes(ByteBuf buf) {
        CreativeFramePacket.writePos((ByteBuf)buf, (BlockPos)this.pos);
        buf.writeBoolean(this.playing);
        buf.writeInt(this.tick);
    }

    public void readBytes(ByteBuf buf) {
        this.pos = CreativeFramePacket.readPos((ByteBuf)buf);
        this.playing = buf.readBoolean();
        this.tick = buf.readInt();
    }

    public void executeClient(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_175625_s(this.pos);
        if (te instanceof TileEntityCreativeFrame) {
            TileEntityCreativeFrame frame = (TileEntityCreativeFrame)te;
            frame.playing = this.playing;
            frame.tick = this.tick;
            if (frame.display != null) {
                if (this.playing) {
                    frame.display.resume(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
                } else {
                    frame.display.pause(frame.getURL(), frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
                }
            }
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

