/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.common.block;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.tileentity.TileEntityCreative;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.AlignedBox;
import com.creativemd.creativecore.common.utils.math.vec.Vec3;
import javax.vecmath.Vector2f;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.littleframes.client.display.FrameDisplay;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.common.packet.CreativeFramePacket;
import team.creative.littleframes.common.structure.LittleFrame;

public class TileEntityCreativeFrame
extends TileEntityCreative
implements ITickable {
    public String mtime = "";
    private String url = "";
    public Vector2f min = new Vector2f(0.0f, 0.0f);
    public Vector2f max = new Vector2f(1.0f, 1.0f);
    public float rotation = 0.0f;
    public boolean flipX = false;
    public boolean flipY = false;
    public boolean visibleFrame = true;
    public boolean bothSides = false;
    public float brightness = 1.0f;
    public float alpha = 1.0f;
    public int renderDistance = 128;
    public float volume = 1.0f;
    public float minDistance = 0.0f;
    public float maxDistance = 20.0f;
    public boolean loop = true;
    public int tick = 0;
    public boolean playing = false;
    @SideOnly(value=Side.CLIENT)
    public TextureCache cache;
    @SideOnly(value=Side.CLIENT)
    public FrameDisplay display;

    @SideOnly(value=Side.CLIENT)
    public boolean isURLEmpty() {
        return this.url.isEmpty();
    }

    @SideOnly(value=Side.CLIENT)
    public String getURL() {
        return LittleFrame.getUrl(this.url);
    }

    public String getRealURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    @SideOnly(value=Side.CLIENT)
    public FrameDisplay requestDisplay() {
        String url = this.getURL();
        if (this.cache == null || !this.cache.url.equals(url)) {
            this.cache = TextureCache.get(url);
            if (this.display != null) {
                this.display.release();
            }
            this.display = null;
        }
        if (!(this.cache.isVideo() || this.cache.ready() && this.cache.getError() == null)) {
            return null;
        }
        if (this.display != null) {
            return this.display;
        }
        this.display = this.cache.createDisplay(new Vec3((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()), url, this.volume, this.minDistance, this.maxDistance, this.loop);
        return this.display;
    }

    public AlignedBox getBox() {
        EnumFacing.Axis two;
        EnumFacing.Axis one;
        AlignedBox box = new AlignedBox();
        EnumFacing facing = EnumFacing.func_82600_a((int)this.func_145832_p());
        if (facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            box.setMin(facing.func_176740_k(), 0.0f);
            box.setMax(facing.func_176740_k(), 0.031f);
        } else {
            box.setMin(facing.func_176740_k(), 0.969f);
            box.setMax(facing.func_176740_k(), 1.0f);
        }
        if (facing.func_176740_k() != EnumFacing.Axis.Z) {
            one = RotationUtils.getTwo((EnumFacing.Axis)facing.func_176740_k());
            two = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
        } else {
            one = RotationUtils.getOne((EnumFacing.Axis)facing.func_176740_k());
            two = RotationUtils.getTwo((EnumFacing.Axis)facing.func_176740_k());
        }
        box.setMin(one, this.min.x);
        box.setMax(one, this.max.x);
        box.setMin(two, this.min.y);
        box.setMax(two, this.max.y);
        return box;
    }

    public float getSizeX() {
        return this.max.x - this.min.x;
    }

    public float getSizeY() {
        return this.max.y - this.min.y;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return Math.pow(this.renderDistance, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getBox().getBB(this.field_174879_c);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        nbt = super.func_189515_b(nbt);
        this.writePictureNBT(nbt);
        return nbt;
    }

    public void play() {
        this.playing = true;
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new CreativeFramePacket(this.field_174879_c, true, this.tick, false, false), (World)this.field_145850_b, (BlockPos)this.field_174879_c, null);
    }

    public void pause() {
        this.playing = false;
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new CreativeFramePacket(this.field_174879_c, false, this.tick, false, false), (World)this.field_145850_b, (BlockPos)this.field_174879_c, null);
    }

    public void stop() {
        this.playing = false;
        this.tick = 0;
        PacketHandler.sendPacketToTrackingPlayers((CreativeCorePacket)new CreativeFramePacket(this.field_174879_c, false, this.tick, false, false), (World)this.field_145850_b, (BlockPos)this.field_174879_c, null);
    }

    protected void writePictureNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("url", this.url);
        nbt.func_74776_a("minx", this.min.x);
        nbt.func_74776_a("miny", this.min.y);
        nbt.func_74776_a("maxx", this.max.x);
        nbt.func_74776_a("maxy", this.max.y);
        nbt.func_74776_a("rotation", this.rotation);
        nbt.func_74768_a("render", this.renderDistance);
        nbt.func_74757_a("visibleFrame", this.visibleFrame);
        nbt.func_74757_a("bothSides", this.bothSides);
        nbt.func_74757_a("flipX", this.flipX);
        nbt.func_74757_a("flipY", this.flipY);
        nbt.func_74776_a("alpha", this.alpha);
        nbt.func_74776_a("brightness", this.brightness);
        nbt.func_74776_a("volume", this.volume);
        nbt.func_74776_a("min", this.minDistance);
        nbt.func_74776_a("max", this.maxDistance);
        nbt.func_74757_a("playing", this.playing);
        nbt.func_74768_a("tick", this.tick);
        nbt.func_74757_a("loop", this.loop);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readPictureNBT(nbt);
    }

    public void handleUpdate(NBTTagCompound nbt, boolean chunkUpdate) {
        this.func_145839_a(nbt);
    }

    protected void readPictureNBT(NBTTagCompound nbt) {
        this.url = nbt.func_74779_i("url");
        this.min.x = nbt.func_74760_g("minx");
        this.min.y = nbt.func_74760_g("miny");
        this.max.x = nbt.func_74760_g("maxx");
        this.max.y = nbt.func_74760_g("maxy");
        this.rotation = nbt.func_74760_g("rotation");
        this.renderDistance = nbt.func_74762_e("render");
        this.visibleFrame = nbt.func_74767_n("visibleFrame");
        this.bothSides = nbt.func_74767_n("bothSides");
        this.flipX = nbt.func_74767_n("flipX");
        this.flipY = nbt.func_74767_n("flipY");
        this.alpha = nbt.func_74764_b("alpha") ? nbt.func_74760_g("alpha") : 1.0f;
        this.brightness = nbt.func_74764_b("brightness") ? nbt.func_74760_g("brightness") : 1.0f;
        this.volume = nbt.func_74760_g("volume");
        this.minDistance = nbt.func_74764_b("min") ? nbt.func_74760_g("min") : 0.0f;
        this.maxDistance = nbt.func_74764_b("max") ? nbt.func_74760_g("max") : 20.0f;
        this.playing = nbt.func_74767_n("playing");
        this.tick = nbt.func_74762_e("tick");
        this.loop = nbt.func_74767_n("loop");
    }

    public void func_73660_a() {
        TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c);
        if (te instanceof TileEntityCreativeFrame) {
            FrameDisplay display;
            TileEntityCreativeFrame frame = (TileEntityCreativeFrame)te;
            if (this.isClientSide() && (display = frame.requestDisplay()) != null && display.canTick()) {
                display.tick(frame.url, frame.volume, frame.minDistance, frame.maxDistance, frame.playing, frame.loop, frame.tick);
            }
            if (frame.playing) {
                ++frame.tick;
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.isClientSide() && this.display != null) {
            this.display.release();
        }
    }

    public void onChunkUnload() {
        if (this.isClientSide() && this.display != null) {
            this.display.release();
        }
    }
}

