/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.vlc;

import team.creative.littleframes.client.vlc.LinuxNativeDiscoveryStrategyFixed;
import team.creative.littleframes.client.vlc.MacOsNativeDiscoveryStrategyFixed;
import team.creative.littleframes.client.vlc.WindowsNativeDiscoveryStrategyFixed;
import uk.co.caprica.vlcj.factory.MediaPlayerFactory;
import uk.co.caprica.vlcj.factory.discovery.NativeDiscovery;

public class VLCDiscovery {
    private static volatile boolean loaded = false;
    private static volatile boolean startedLoading = false;
    private static volatile boolean successful = false;
    private static volatile NativeDiscovery discovery;
    public static volatile MediaPlayerFactory factory;

    public static boolean isLoaded() {
        return loaded;
    }

    public static boolean isLoadedOrRequest() {
        if (loaded) {
            return true;
        }
        if (!startedLoading) {
            startedLoading = true;
            new Thread(VLCDiscovery::load).start();
        }
        return false;
    }

    public static boolean isAvailable() {
        return successful;
    }

    public static synchronized boolean load() {
        if (loaded) {
            return successful;
        }
        try {
            discovery = new NativeDiscovery(new LinuxNativeDiscoveryStrategyFixed(), new MacOsNativeDiscoveryStrategyFixed(), new WindowsNativeDiscoveryStrategyFixed());
            successful = discovery.discover();
            loaded = true;
            if (successful) {
                factory = new MediaPlayerFactory("--quiet", "--aout=directsound");
                System.out.println("Loaded VLC in '" + discovery.discoveredPath() + "'");
                Runtime.getRuntime().addShutdownHook(new Thread(() -> factory.release()));
            } else {
                System.out.println("Failed to load VLC");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            loaded = true;
            successful = false;
            System.out.println("Failed to load VLC");
        }
        return successful;
    }
}

