/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.vlc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import team.creative.littleframes.client.vlc.LocalFileDiscoveryDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.DiscoveryDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.JnaLibraryPathDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.LinuxWellKnownDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.SystemPathDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.UserDirDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.provider.WindowsInstallDirectoryProvider;
import uk.co.caprica.vlcj.factory.discovery.strategy.BaseNativeDiscoveryStrategy;

public abstract class DirectoryProviderDiscoveryStrategyFixed
extends BaseNativeDiscoveryStrategy {
    private static final List<DiscoveryDirectoryProvider> directoryProviders = Arrays.asList(new LocalFileDiscoveryDirectoryProvider(), new JnaLibraryPathDirectoryProvider(), new LinuxWellKnownDirectoryProvider(), new SystemPathDirectoryProvider(), new UserDirDirectoryProvider(), new WindowsInstallDirectoryProvider());

    public DirectoryProviderDiscoveryStrategyFixed(String[] filenamePatterns, String[] pluginPathFormats) {
        super(filenamePatterns, pluginPathFormats);
    }

    @Override
    public final List<String> discoveryDirectories() {
        ArrayList<String> directories = new ArrayList<String>();
        for (DiscoveryDirectoryProvider provider : this.getSupportedProviders()) {
            directories.addAll(Arrays.asList(provider.directories()));
        }
        return directories;
    }

    private List<DiscoveryDirectoryProvider> getSupportedProviders() {
        ArrayList<DiscoveryDirectoryProvider> result = new ArrayList<DiscoveryDirectoryProvider>();
        for (DiscoveryDirectoryProvider service : directoryProviders) {
            if (!service.supported()) continue;
            result.add(service);
        }
        return this.sort(result);
    }

    private List<DiscoveryDirectoryProvider> sort(List<DiscoveryDirectoryProvider> providers) {
        Collections.sort(providers, new Comparator<DiscoveryDirectoryProvider>(){

            @Override
            public int compare(DiscoveryDirectoryProvider p1, DiscoveryDirectoryProvider p2) {
                return p2.priority() - p1.priority();
            }
        });
        return providers;
    }
}

