/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.texture;

import com.madgag.gif.fmsware.GifsDecoder;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.texture.TextureStorage;

public class TextureSeeker
extends Thread {
    public static final Logger LOGGER = LogManager.getLogger(LittleFrames.class);
    public static final TextureStorage TEXTURE_STORAGE = new TextureStorage();
    public static final DateFormat FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
    public static final Object LOCK = new Object();
    public static final int MAXIMUM_ACTIVE_DOWNLOADS = 5;
    public static int activeDownloads = 0;
    private static final Minecraft mc = Minecraft.func_71410_x();
    private final TextureCache cache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextureSeeker(TextureCache cache) {
        this.cache = cache;
        Object object = LOCK;
        synchronized (object) {
            ++activeDownloads;
        }
        this.setName("OPF Download \"" + cache.url + "\"");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Exception exception = null;
        boolean isVideo = false;
        boolean processed = false;
        try {
            ByteArrayInputStream in;
            block24: {
                byte[] data = TextureSeeker.load(this.cache.url);
                String type = TextureSeeker.readType(data);
                in = null;
                try {
                    in = new ByteArrayInputStream(data);
                    if (type != null && type.equalsIgnoreCase("gif")) {
                        GifsDecoder gif = new GifsDecoder();
                        int status = gif.read(in);
                        if (status == 0) {
                            mc.func_152344_a(() -> this.cache.process(gif));
                            processed = true;
                        } else {
                            LOGGER.error("Failed to read gif: {}", (Object)status);
                        }
                        break block24;
                    }
                    try {
                        BufferedImage image = ImageIO.read(in);
                        if (image != null) {
                            mc.func_152344_a(() -> this.cache.process(image));
                            processed = true;
                        }
                    }
                    catch (IOException e1) {
                        exception = e1;
                        LOGGER.error("Failed to parse BufferedImage from stream", (Throwable)e1);
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
        }
        catch (FoundVideoException e) {
            if (LittleFrames.CONFIG.useVLC) {
                this.cache.processVideo();
                isVideo = true;
            } else {
                exception = e;
            }
        }
        catch (Exception e) {
            if (LittleFrames.CONFIG.useVLC) {
                this.cache.processVideo();
                isVideo = true;
            }
            exception = e;
            LOGGER.error("An exception occurred while loading LittleFrames image", (Throwable)e);
        }
        if (!isVideo && !processed) {
            if (exception == null) {
                this.cache.processFailed("download.exception.gif");
            } else if (exception.getMessage().startsWith("Server returned HTTP response code: 403")) {
                this.cache.processFailed("download.exception.forbidden");
            } else if (exception.getMessage().startsWith("Server returned HTTP response code: 404")) {
                this.cache.processFailed("download.exception.notfound");
            } else {
                this.cache.processFailed("download.exception.invalid");
            }
            TEXTURE_STORAGE.deleteEntry(this.cache.url);
        }
        Object object = LOCK;
        synchronized (object) {
            --activeDownloads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] load(String url) throws IOException, FoundVideoException {
        byte[] data;
        long lastModifiedTimestamp;
        long expireTimestamp;
        String etag;
        InputStream in;
        block27: {
            File file;
            String lastModified;
            String expires;
            TextureStorage.CacheEntry entry = TEXTURE_STORAGE.getEntry(url);
            long requestTime = System.currentTimeMillis();
            URLConnection connection = new URL(url).openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:25.0) Gecko/20100101 Firefox/25.0");
            int responseCode = -1;
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection httpConnection = (HttpURLConnection)connection;
                if (entry != null && entry.getFile().exists()) {
                    if (entry.getEtag() != null) {
                        httpConnection.setRequestProperty("If-None-Match", entry.getEtag());
                    } else if (entry.getTime() != -1L) {
                        httpConnection.setRequestProperty("If-Modified-Since", FORMAT.format(new Date(entry.getTime())));
                    }
                }
                responseCode = httpConnection.getResponseCode();
            }
            in = null;
            in = connection.getInputStream();
            if (responseCode != 304) {
                etag = connection.getContentType();
                if (etag == null) {
                    throw new FoundVideoException();
                }
                if (!etag.startsWith("image")) {
                    throw new FoundVideoException();
                }
            }
            etag = connection.getHeaderField("ETag");
            expireTimestamp = -1L;
            String maxAge = connection.getHeaderField("max-age");
            if (maxAge != null && !maxAge.isEmpty()) {
                try {
                    expireTimestamp = requestTime + Long.parseLong(maxAge) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((expires = connection.getHeaderField("Expires")) != null && !expires.isEmpty()) {
                try {
                    expireTimestamp = FORMAT.parse(expires).getTime();
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if ((lastModified = connection.getHeaderField("Last-Modified")) != null && !lastModified.isEmpty()) {
                try {
                    lastModifiedTimestamp = FORMAT.parse(lastModified).getTime();
                }
                catch (ParseException e) {
                    lastModifiedTimestamp = requestTime;
                }
            } else {
                lastModifiedTimestamp = requestTime;
            }
            if (entry == null) break block27;
            if (etag != null && !etag.isEmpty()) {
                entry.setEtag(etag);
            }
            entry.setTime(lastModifiedTimestamp);
            if (responseCode != 304 || !(file = entry.getFile()).exists()) break block27;
            try (FileInputStream fileStream = new FileInputStream(file);){
                byte[] byArray = IOUtils.toByteArray((InputStream)fileStream);
                return byArray;
            }
        }
        if (TextureSeeker.readType(data = IOUtils.toByteArray((InputStream)in)) == null) {
            throw new FoundVideoException();
        }
        TEXTURE_STORAGE.save(url, etag, lastModifiedTimestamp, expireTimestamp, data);
        byte[] byArray = data;
        return byArray;
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static String readType(byte[] input) throws IOException {
        String string;
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(input);
            string = TextureSeeker.readType(in);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(in);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readType(InputStream input) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(input);
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        ImageReader reader = iter.next();
        if (reader.getFormatName().equalsIgnoreCase("gif")) {
            return "gif";
        }
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            reader.read(0, param);
        }
        catch (IOException e) {
            LOGGER.error("Failed to parse input format", (Throwable)e);
        }
        finally {
            reader.dispose();
            IOUtils.closeQuietly((Closeable)stream);
        }
        input.reset();
        return reader.getFormatName();
    }

    public static class FoundVideoException
    extends Exception {
    }
}

