/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littleframes.client.gui;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiAnalogeSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiSteppedSlider;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.littleframes.LittleFrames;
import team.creative.littleframes.client.gui.GuiUrlTextfield;
import team.creative.littleframes.client.texture.TextureCache;
import team.creative.littleframes.client.texture.TextureSeeker;
import team.creative.littleframes.common.structure.LittleFrame;

@SideOnly(value=Side.CLIENT)
public class SubGuiLittleFrame
extends SubGui {
    public LittleFrame frame;
    public GuiTextfield url;
    public GuiButton save;
    public GuiComboBox customlinksbox;

    public static boolean isValidURL(String urlString) {
        try {
            URL url = new URL(urlString);
            url.toURI();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setSelectedVideo() {
        GuiComboBox box = (GuiComboBox)this.get("files");
        if (!Objects.equals(box.getCaption(), "none")) {
            String indexlink;
            JsonObject jo;
            ArrayList customlinkslinks = new ArrayList();
            JsonParser jsonParser = new JsonParser();
            try {
                jo = (JsonObject)jsonParser.parse((Reader)new FileReader(SubGuiLittleFrame.mc.field_71412_D.getAbsolutePath() + "/config/littleframes-client.json"));
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            JsonObject jArray = jo.getAsJsonObject("customLinks");
            JsonArray desc = jArray.getAsJsonArray("link");
            Gson gJson = new Gson();
            ArrayList jsonObjArrayList = (ArrayList)gJson.fromJson((JsonElement)desc, ArrayList.class);
            customlinkslinks.addAll(jsonObjArrayList);
            if (box.index - 1 < customlinkslinks.size() && box.index - 1 >= 0 && SubGuiLittleFrame.isValidURL(indexlink = (String)customlinkslinks.get(box.index - 1)) && indexlink != null) {
                this.url.text = indexlink;
            }
        }
    }

    public SubGuiLittleFrame(LittleFrame frame) {
        this(frame, false, 16);
    }

    public SubGuiLittleFrame(LittleFrame frame, boolean editFacing, int scaleSize) {
        super(350, editFacing ? 220 : 240);
        this.frame = frame;
    }

    public void createControls() {
        JsonObject jo;
        this.save = new GuiButton(SubGuiLittleFrame.translate((String)"gui.creative_frame.save"), 144, 180, 50){

            public void onClicked(int x, int y, int button) {
                SubGuiLittleFrame.this.setSelectedVideo();
                NBTTagCompound nbt = new NBTTagCompound();
                GuiTextfield url = (GuiTextfield)SubGuiLittleFrame.this.get("url");
                GuiSteppedSlider renderDistance = (GuiSteppedSlider)SubGuiLittleFrame.this.get("renderDistance");
                GuiSteppedSlider minDistance = (GuiSteppedSlider)SubGuiLittleFrame.this.get("min");
                GuiSteppedSlider maxDistance = (GuiSteppedSlider)SubGuiLittleFrame.this.get("max");
                GuiStateButton fit = (GuiStateButton)SubGuiLittleFrame.this.get("fit");
                GuiAnalogeSlider transparency = (GuiAnalogeSlider)SubGuiLittleFrame.this.get("transparency");
                GuiAnalogeSlider brightness = (GuiAnalogeSlider)SubGuiLittleFrame.this.get("brightness");
                GuiCheckBox loop = (GuiCheckBox)SubGuiLittleFrame.this.get("loop");
                GuiAnalogeSlider volume = (GuiAnalogeSlider)SubGuiLittleFrame.this.get("volume");
                nbt.func_74768_a("fit", fit.getState());
                nbt.func_74768_a("render", (int)renderDistance.value);
                nbt.func_74776_a("transparency", (float)transparency.value);
                nbt.func_74776_a("brightness", (float)brightness.value);
                nbt.func_74757_a("loop", loop.value);
                nbt.func_74776_a("volume", (float)volume.value);
                nbt.func_74776_a("min", (float)minDistance.value);
                nbt.func_74776_a("max", (float)maxDistance.value);
                nbt.func_74778_a("url", url.text);
                nbt.func_74768_a("type", 0);
                if (!url.text.isEmpty()) {
                    SubGuiLittleFrame.this.sendPacketToServer(nbt);
                }
            }
        };
        this.url = new GuiUrlTextfield(this.save, "url", this.frame.getRealURL(), 0, 0, 344, 16);
        this.url.maxLength = 512;
        this.controls.add(this.url);
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)(this.frame.cache != null && this.frame.cache.getError() != null ? this.frame.cache.getError() : "")), 0, 20, -65536));
        this.save.setEnabled(LittleFrames.CONFIG.canUse((EntityPlayer)SubGuiLittleFrame.mc.field_71439_g, this.url.text));
        this.controls.add(this.save);
        String[] args = new String[LittleFrame.FitMode.values().length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = SubGuiLittleFrame.translate((String)("gui.little_frame.fitmode." + LittleFrame.FitMode.values()[i].name()));
        }
        this.controls.add(new GuiStateButton("fit", this.frame.fitMode.ordinal(), 0, 28, 70, args));
        ArrayList<String> customlinks = new ArrayList<String>();
        JsonParser jsonParser = new JsonParser();
        try {
            jo = (JsonObject)jsonParser.parse((Reader)new FileReader(SubGuiLittleFrame.mc.field_71412_D.getAbsolutePath() + "/config/littleframes-client.json"));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        JsonObject jArray = jo.getAsJsonObject("customLinks");
        JsonArray desc = jArray.getAsJsonArray("description");
        customlinks.add("none");
        Gson gJson = new Gson();
        ArrayList jsonObjArrayList = (ArrayList)gJson.fromJson((JsonElement)desc, ArrayList.class);
        customlinks.addAll(jsonObjArrayList);
        this.customlinksbox = (GuiComboBox)new GuiComboBox("files", 100, 28, 244, customlinks){}.setCustomTooltip(new String[]{SubGuiLittleFrame.translate((String)"gui.creative_frame.customlinksinfo")});
        this.controls.add(this.customlinksbox);
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)"gui.creative_frame.transparency"), 0, 58));
        this.controls.add(new GuiAnalogeSlider("transparency", 80, 60, 109, 5, (double)this.frame.alpha, 0.0, 1.0));
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)"gui.creative_frame.brightness"), 0, 73));
        this.controls.add(new GuiAnalogeSlider("brightness", 80, 75, 109, 5, (double)this.frame.brightness, 0.0, 1.0));
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)"gui.creative_frame.distance"), 0, 88));
        this.controls.add(new GuiSteppedSlider("renderDistance", 80, 90, 109, 5, this.frame.renderDistance, 5, 1024));
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)"gui.creative_frame.range_min"), 0, 103));
        this.controls.add(new GuiSteppedSlider("min", 80, 105, 109, 5, (int)this.frame.minDistance, 0, 512));
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)"gui.creative_frame.range_max"), 0, 118));
        this.controls.add(new GuiSteppedSlider("max", 80, 120, 109, 5, (int)this.frame.maxDistance, 0, 512));
        this.controls.add(new GuiCheckBox("loop", SubGuiLittleFrame.translate((String)"gui.creative_frame.loop"), 150, 148, this.frame.loop));
        this.controls.add(new GuiLabel(SubGuiLittleFrame.translate((String)"gui.creative_frame.volume"), 60, 148));
        this.controls.add(new GuiAnalogeSlider("volume", 105, 150, 30, 5, (double)this.frame.volume, 0.0, 1.0));
        this.controls.add(new GuiButton(SubGuiLittleFrame.translate((String)"gui.creative_frame.reload"), 102, 180){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onClicked(int x, int y, int button) {
                Object object = TextureSeeker.LOCK;
                synchronized (object) {
                    if (GuiScreen.func_146272_n()) {
                        TextureCache.reloadAll();
                    } else if (SubGuiLittleFrame.this.frame.cache != null) {
                        SubGuiLittleFrame.this.frame.cache.reload();
                    }
                }
            }
        }.setCustomTooltip(new String[]{SubGuiLittleFrame.translate((String)"gui.creative_frame.reloadtooltip")}));
        this.controls.add(new GuiIconButton("play", 0, 148, 10){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("play", true);
                SubGuiLittleFrame.this.sendPacketToServer(nbt);
            }
        });
        this.controls.add(new GuiIconButton("pause", 20, 148, 9){

            public void onClicked(int x, int y, int button) {
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new TextComponentString("Aktueller Tick: " + SubGuiLittleFrame.this.frame.tick), true);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("pause", true);
                SubGuiLittleFrame.this.sendPacketToServer(nbt);
            }
        });
        this.controls.add(new GuiIconButton("stop", 40, 148, 11){

            public void onClicked(int x, int y, int button) {
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("stop", true);
                SubGuiLittleFrame.this.sendPacketToServer(nbt);
            }
        });
    }
}

